/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.impl;

import com.intellij.openapi.util.io.NioFiles;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.services.KotlinTestInfo;
import org.jetbrains.kotlin.test.services.KotlinTestInfoKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManager;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\r\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/TemporaryDirectoryManagerImpl;", "Lorg/jetbrains/kotlin/test/services/TemporaryDirectoryManager;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "cache", "", "", "Ljava/io/File;", "rootTempDir", "Lkotlin/Lazy;", "Lkotlin/jvm/internal/EnhancedNullability;", "rootDir", "getRootDir", "()Ljava/io/File;", "getOrCreateTempDirectory", "name", "cleanupTemporaryDirectories", "", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nTemporaryDirectoryManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemporaryDirectoryManagerImpl.kt\norg/jetbrains/kotlin/test/services/impl/TemporaryDirectoryManagerImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,57:1\n381#2,7:58\n*S KotlinDebug\n*F\n+ 1 TemporaryDirectoryManagerImpl.kt\norg/jetbrains/kotlin/test/services/impl/TemporaryDirectoryManagerImpl\n*L\n38#1:58,7\n*E\n"})
public final class TemporaryDirectoryManagerImpl
extends TemporaryDirectoryManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, File> cache;
    @NotNull
    private final Lazy<File> rootTempDir;
    private static final boolean onWindows;

    public TemporaryDirectoryManagerImpl(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
        this.cache = new LinkedHashMap();
        this.rootTempDir = LazyKt.lazy(() -> TemporaryDirectoryManagerImpl.rootTempDir$lambda$0(testServices));
    }

    @Override
    @NotNull
    public File getRootDir() {
        Object object = this.rootTempDir.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
        return (File)object;
    }

    @Override
    @NotNull
    public File getOrCreateTempDirectory(@NotNull String name) {
        File file;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, File> $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        File value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            File file2 = KtTestUtil.tmpDir(this.getRootDir(), name);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"tmpDir(...)");
            File answer$iv = file2;
            $this$getOrPut$iv.put(name, answer$iv);
            file = answer$iv;
        } else {
            file = value$iv;
        }
        return file;
    }

    @Override
    public void cleanupTemporaryDirectories() {
        this.cache.clear();
        if (this.rootTempDir.isInitialized()) {
            NioFiles.deleteRecursively((Path)Paths.get(this.getRootDir().getPath(), new String[0]));
        }
    }

    private static final File rootTempDir$lambda$0(TestServices $testServices) {
        KotlinTestInfo testInfo = KotlinTestInfoKt.getTestInfo($testServices);
        String className = testInfo.getClassName();
        String methodName = testInfo.getMethodName();
        if (!onWindows && className.length() + methodName.length() < 255) {
            return KtTestUtil.tmpDirForTest(className, methodName);
        }
        int lastDot = StringsKt.lastIndexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null);
        String string = className.substring(lastDot + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String simplifiedClassName = TemporaryDirectoryManagerImpl.Companion.getOnlyUpperCaseSymbols(string);
        String simplifiedMethodName = TemporaryDirectoryManagerImpl.Companion.getOnlyUpperCaseSymbols(methodName);
        return KtTestUtil.tmpDirForTest(simplifiedClassName, simplifiedMethodName);
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        onWindows = StringsKt.contains$default((CharSequence)string3, (CharSequence)"windows", (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/TemporaryDirectoryManagerImpl$Companion;", "", "<init>", "()V", "onWindows", "", "getOnlyUpperCaseSymbols", "", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nTemporaryDirectoryManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemporaryDirectoryManagerImpl.kt\norg/jetbrains/kotlin/test/services/impl/TemporaryDirectoryManagerImpl$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,57:1\n434#2:58\n507#2,5:59\n*S KotlinDebug\n*F\n+ 1 TemporaryDirectoryManagerImpl.kt\norg/jetbrains/kotlin/test/services/impl/TemporaryDirectoryManagerImpl$Companion\n*L\n53#1:58\n53#1:59,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final String getOnlyUpperCaseSymbols(String $this$getOnlyUpperCaseSymbols) {
            void $this$filterTo$iv$iv;
            String $this$filter$iv = $this$getOnlyUpperCaseSymbols;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!(Character.isUpperCase(it) || it == '$')) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)StringsKt.toList((CharSequence)((StringBuilder)destination$iv$iv).toString()), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

