/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.WasmPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.frontend.fir.Fir2IrJsResultsConverter;
import org.jetbrains.kotlin.test.frontend.fir.Fir2IrJvmResultsConverter;
import org.jetbrains.kotlin.test.frontend.fir.Fir2IrWasmResultsConverter;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.model.BackendKinds;
import org.jetbrains.kotlin.test.model.Frontend2BackendConverter;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/Fir2IrResultsConverter;", "Lorg/jetbrains/kotlin/test/model/Frontend2BackendConverter;", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "jvmResultsConverter", "Lorg/jetbrains/kotlin/test/frontend/fir/Fir2IrJvmResultsConverter;", "jsResultsConverter", "Lorg/jetbrains/kotlin/test/frontend/fir/Fir2IrJsResultsConverter;", "wasmResultsConverter", "Lorg/jetbrains/kotlin/test/frontend/fir/Fir2IrWasmResultsConverter;", "transform", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "inputArtifact", "tests-common-new_test"})
public final class Fir2IrResultsConverter
extends Frontend2BackendConverter<FirOutputArtifact, IrBackendInput> {
    @NotNull
    private final Fir2IrJvmResultsConverter jvmResultsConverter;
    @NotNull
    private final Fir2IrJsResultsConverter jsResultsConverter;
    @NotNull
    private final Fir2IrWasmResultsConverter wasmResultsConverter;

    public Fir2IrResultsConverter(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, FrontendKinds.FIR.INSTANCE, BackendKinds.IrBackend.INSTANCE);
        this.jvmResultsConverter = new Fir2IrJvmResultsConverter(testServices);
        this.jsResultsConverter = new Fir2IrJsResultsConverter(testServices);
        this.wasmResultsConverter = new Fir2IrWasmResultsConverter(testServices);
    }

    @Override
    @Nullable
    public IrBackendInput transform(@NotNull TestModule module, @NotNull FirOutputArtifact inputArtifact) {
        IrBackendInput irBackendInput;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)inputArtifact, (String)"inputArtifact");
        if (JvmPlatformKt.isJvm((TargetPlatform)module.getTargetPlatform()) || TargetPlatformKt.isCommon((TargetPlatform)module.getTargetPlatform())) {
            irBackendInput = this.jvmResultsConverter.transform(module, inputArtifact);
        } else if (JsPlatformKt.isJs((TargetPlatform)module.getTargetPlatform())) {
            irBackendInput = this.jsResultsConverter.transform(module, inputArtifact);
        } else if (WasmPlatformKt.isWasm((TargetPlatform)module.getTargetPlatform())) {
            irBackendInput = this.wasmResultsConverter.transform(module, inputArtifact);
        } else {
            throw new IllegalStateException(("Unsupported platform: " + module.getTargetPlatform()).toString());
        }
        return irBackendInput;
    }
}

