/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.classic;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CodegenTestUtil;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.JvmCompilationUtils;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.JvmEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManagerKt;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/test/backend/classic/JavaCompilerFacade;", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "compileJavaFiles", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "classFileFactory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nJavaCompilerFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCompilerFacade.kt\norg/jetbrains/kotlin/test/backend/classic/JavaCompilerFacade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1557#2:96\n1628#2,3:97\n1755#2,3:100\n*S KotlinDebug\n*F\n+ 1 JavaCompilerFacade.kt\norg/jetbrains/kotlin/test/backend/classic/JavaCompilerFacade\n*L\n33#1:96\n33#1:97,3\n42#1:100,3\n*E\n"})
public final class JavaCompilerFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestServices testServices;

    public JavaCompilerFacade(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
    }

    /*
     * WARNING - void declaration
     */
    public final void compileJavaFiles(@NotNull TestModule module, @NotNull CompilerConfiguration configuration2, @NotNull ClassFileFactory classFileFactory) {
        boolean bl;
        File file;
        List<String> list;
        Collection collection;
        block5: {
            void $this$any$iv;
            TestFile it;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)classFileFactory, (String)"classFileFactory");
            if (SourceFileProviderKt.getJavaFiles(module).isEmpty()) {
                return;
            }
            File outputDir = CompiledClassesManagerKt.getCompiledClassesManager(this.testServices).compileKotlinToDiskAndGetOutputDir(module, classFileFactory);
            Iterable iterable = JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)configuration2);
            collection = CollectionsKt.listOf((Object)outputDir.getPath());
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Iterable<String> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                File file2 = (File)item$iv$iv;
                list = destination$iv$iv;
                boolean bl2 = false;
                list.add(((File)((Object)it)).getAbsolutePath());
            }
            List javaClasspath = CollectionsKt.plus((Collection)collection, (Iterable)destination$iv$iv);
            List<String> javacOptions = Companion.extractJavacOptions(module, (JvmTarget)configuration2.get(JVMConfigurationKeys.JVM_TARGET), configuration2.getBoolean(JVMConfigurationKeys.ENABLE_JVM_PREVIEW));
            destination$iv$iv = module.getFiles();
            file = outputDir;
            list = javacOptions;
            collection = javaClasspath;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (TestFile)element$iv;
                    boolean bl3 = false;
                    if (!SourceFileProviderKt.isModuleInfoJavaFile(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean bl4 = bl;
        List<String> list2 = CodegenTestUtil.prepareJavacOptions((List<String>)collection, list, file, bl4);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"prepareJavacOptions(...)");
        List<String> finalJavacOptions = list2;
        List<File> javaFiles = SourceFileProviderKt.getRealJavaFiles(SourceFileProviderKt.getSourceFileProvider(this.testServices), module);
        boolean ignoreErrors = module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_JAVA_ERRORS());
        Companion.compileJavaFiles(AssertionsKt.getAssertions(this.testServices), module, javaFiles, finalJavacOptions, ignoreErrors);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ:\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/test/backend/classic/JavaCompilerFacade$Companion;", "", "<init>", "()V", "extractJavacOptions", "", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "kotlinTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "isJvmPreviewEnabled", "", "compileJavaFiles", "", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "files", "Ljava/io/File;", "javacOptions", "ignoreErrors", "getExplicitJdkHome", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nJavaCompilerFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCompilerFacade.kt\norg/jetbrains/kotlin/test/backend/classic/JavaCompilerFacade$Companion\n+ 2 JvmEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/JvmEnvironmentConfigurator$Companion\n*L\n1#1,95:1\n146#2,7:96\n*S KotlinDebug\n*F\n+ 1 JavaCompilerFacade.kt\norg/jetbrains/kotlin/test/backend/classic/JavaCompilerFacade$Companion\n*L\n89#1:96,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> extractJavacOptions(@NotNull TestModule module, @Nullable JvmTarget kotlinTarget, boolean isJvmPreviewEnabled) {
            List list;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            List $this$extractJavacOptions_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$extractJavacOptions_u24lambda_u240.addAll((Collection)module.getDirectives().get(CodegenTestDirectives.INSTANCE.getJAVAC_OPTIONS()));
            if (kotlinTarget != null) {
                boolean bl2;
                if (isJvmPreviewEnabled) {
                    $this$extractJavacOptions_u24lambda_u240.add("--release");
                    $this$extractJavacOptions_u24lambda_u240.add(kotlinTarget.getDescription());
                    bl2 = $this$extractJavacOptions_u24lambda_u240.add("--enable-preview");
                } else {
                    $this$extractJavacOptions_u24lambda_u240.add("-source");
                    $this$extractJavacOptions_u24lambda_u240.add(kotlinTarget.getDescription());
                    $this$extractJavacOptions_u24lambda_u240.add("-target");
                    bl2 = $this$extractJavacOptions_u24lambda_u240.add(kotlinTarget.getDescription());
                }
            }
            return CollectionsKt.build((List)list);
        }

        public final void compileJavaFiles(@NotNull Assertions assertions, @NotNull TestModule module, @NotNull List<? extends File> files, @NotNull List<String> javacOptions, boolean ignoreErrors) {
            Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter(javacOptions, (String)"javacOptions");
            File jdkHome = this.getExplicitJdkHome(module);
            if (jdkHome == null) {
                JvmCompilationUtils.compileJavaFiles((Collection<? extends File>)files, javacOptions, null, assertions, ignoreErrors);
            } else {
                boolean success = JvmCompilationUtils.compileJavaFilesExternally((Collection<? extends File>)files, javacOptions, jdkHome);
                if (!success && !ignoreErrors) {
                    throw new AssertionError((Object)"Java files are not compiled successfully");
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final File getExplicitJdkHome(@NotNull TestModule module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            v0 = jdkKind = DirectiveKt.singleOrZeroValue(module.getDirectives(), JvmEnvironmentConfigurationDirectives.INSTANCE.getJDK_KIND());
            switch (v0 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
                case 1: {
                    v1 = KtTestUtil.getJdk8Home();
                    break;
                }
                case 2: {
                    v1 = KtTestUtil.getJdk11Home();
                    break;
                }
                case 3: {
                    v1 = KtTestUtil.getJdk17Home();
                    break;
                }
                case 4: {
                    v1 = KtTestUtil.getJdk21Home();
                    break;
                }
                case -1: {
                    this_$iv = JvmEnvironmentConfigurator.Companion;
                    $i$f$getJdkHomeFromProperty = false;
                    v2 = version$iv = this_$iv.getDEFAULT_JVM_VERSION_FROM_PROPERTY();
                    if (v2 == null) ** GOTO lbl45
                    switch (v2.hashCode()) {
                        case 1568: {
                            if (!version$iv.equals("11")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case 1574: {
                            if (!version$iv.equals("17")) {
                                ** break;
                            }
                            ** GOTO lbl41
                        }
                        case 48571: {
                            if (version$iv.equals("1.8")) break;
                            ** break;
                        }
                        case 1599: {
                            if (!version$iv.equals("21")) {
                                ** break;
                            }
                            ** GOTO lbl43
                        }
                    }
                    v1 = KtTestUtil.getJdk8Home();
                    break;
lbl39:
                    // 1 sources

                    v1 = KtTestUtil.getJdk11Home();
                    break;
lbl41:
                    // 1 sources

                    v1 = KtTestUtil.getJdk17Home();
                    break;
lbl43:
                    // 1 sources

                    v1 = KtTestUtil.getJdk21Home();
                    break;
lbl45:
                    // 1 sources

                    $i$a$-getJdkHomeFromProperty-JavaCompilerFacade$Companion$getExplicitJdkHome$1 = false;
                    v1 = null;
                    break;
lbl48:
                    // 5 sources

                    throw new IllegalStateException(("Unknown JDK version: \"kotlin.test.default.jvm.version=" + version$iv + "\". Only following versions are allowed: [1.8, 11, 17, 21]").toString());
                }
                default: {
                    throw new IllegalStateException(("JDK " + (Object)jdkKind + " does not support compilation").toString());
                }
            }
            return v1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TestJdkKind.values().length];
                try {
                    nArray[TestJdkKind.FULL_JDK.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.FULL_JDK_11.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.FULL_JDK_17.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.FULL_JDK_21.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

