/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.TargetBackend;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005J\b\u0010\u0016\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/codegen/OccurrenceInfo;", "", "numberOfOccurrences", "", "needle", "", "backend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "inlineScopesNumbersEnabled", "", "<init>", "(ILjava/lang/String;Lorg/jetbrains/kotlin/test/TargetBackend;Z)V", "getBackend", "()Lorg/jetbrains/kotlin/test/TargetBackend;", "getInlineScopesNumbersEnabled", "()Z", "pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "getActualOccurrence", "text", "toString", "test-infrastructure-utils_test"})
public final class OccurrenceInfo {
    private final int numberOfOccurrences;
    @NotNull
    private final String needle;
    @NotNull
    private final TargetBackend backend;
    private final boolean inlineScopesNumbersEnabled;
    private final Pattern pattern;

    public OccurrenceInfo(int numberOfOccurrences, @NotNull String needle, @NotNull TargetBackend backend, boolean inlineScopesNumbersEnabled) {
        Intrinsics.checkNotNullParameter((Object)needle, (String)"needle");
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        this.numberOfOccurrences = numberOfOccurrences;
        this.needle = needle;
        this.backend = backend;
        this.inlineScopesNumbersEnabled = inlineScopesNumbersEnabled;
        this.pattern = Pattern.compile('(' + this.needle + ')');
    }

    @NotNull
    public final TargetBackend getBackend() {
        return this.backend;
    }

    public final boolean getInlineScopesNumbersEnabled() {
        return this.inlineScopesNumbersEnabled;
    }

    @NotNull
    public final String getActualOccurrence(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int actualCount = StringUtil.findMatches((String)text, (Pattern)this.pattern).size();
        return "" + actualCount + ' ' + this.needle;
    }

    @NotNull
    public String toString() {
        return "" + this.numberOfOccurrences + ' ' + this.needle;
    }
}

