/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.support.hierarchical.ParallelExecutionConfiguration;
import org.junit.platform.engine.support.hierarchical.ParallelExecutionConfigurationStrategy;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/test/DynamicWithMaxThresholdParallelExecutionConfigurationStrategy;", "Lorg/junit/platform/engine/support/hierarchical/ParallelExecutionConfigurationStrategy;", "<init>", "()V", "createConfiguration", "Lorg/junit/platform/engine/support/hierarchical/ParallelExecutionConfiguration;", "configurationParameters", "Lorg/junit/platform/engine/ConfigurationParameters;", "Companion", "tests-common-new_test"})
public final class DynamicWithMaxThresholdParallelExecutionConfigurationStrategy
implements ParallelExecutionConfigurationStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String FIXED_THRESHOLD = "fixed.threshold";
    private static final int DEFAULT_VALUE = 16;
    private static final int KEEP_ALIVE_SECONDS = 30;

    @NotNull
    public ParallelExecutionConfiguration createConfiguration(@NotNull ConfigurationParameters configurationParameters) {
        Intrinsics.checkNotNullParameter((Object)configurationParameters, (String)"configurationParameters");
        Integer n = configurationParameters.get(FIXED_THRESHOLD).map(arg_0 -> DynamicWithMaxThresholdParallelExecutionConfigurationStrategy.createConfiguration$lambda$1(DynamicWithMaxThresholdParallelExecutionConfigurationStrategy::createConfiguration$lambda$0, arg_0)).orElse(null);
        int threshold = n != null ? n : 16;
        int cpuCores = Runtime.getRuntime().availableProcessors();
        int parallelism = threshold > 0 ? Math.min(cpuCores, threshold) : cpuCores;
        return new ParallelExecutionConfiguration(parallelism){
            final /* synthetic */ int $parallelism;
            {
                this.$parallelism = $parallelism;
            }

            public int getParallelism() {
                return this.$parallelism;
            }

            public int getMinimumRunnable() {
                return this.$parallelism;
            }

            public int getMaxPoolSize() {
                return 256 + this.$parallelism;
            }

            public int getCorePoolSize() {
                return this.$parallelism;
            }

            public int getKeepAliveSeconds() {
                return 30;
            }
        };
    }

    private static final Integer createConfiguration$lambda$0(String it) {
        Intrinsics.checkNotNull((Object)it);
        return StringsKt.toIntOrNull((String)it);
    }

    private static final Integer createConfiguration$lambda$1(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/test/DynamicWithMaxThresholdParallelExecutionConfigurationStrategy$Companion;", "", "<init>", "()V", "FIXED_THRESHOLD", "", "DEFAULT_VALUE", "", "KEEP_ALIVE_SECONDS", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

