/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/test/utils/TestMessageCollector;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "<init>", "()V", "messages", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/test/utils/TestMessageCollector$Message;", "Lkotlin/collections/ArrayList;", "getMessages", "()Ljava/util/ArrayList;", "clear", "", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "hasErrors", "", "toString", "Message", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nTestMessageCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestMessageCollector.kt\norg/jetbrains/kotlin/test/utils/TestMessageCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1755#2,3:32\n1#3:35\n*S KotlinDebug\n*F\n+ 1 TestMessageCollector.kt\norg/jetbrains/kotlin/test/utils/TestMessageCollector\n*L\n25#1:32,3\n*E\n"})
public final class TestMessageCollector
implements MessageCollector {
    @NotNull
    private final ArrayList<Message> messages = new ArrayList();

    @NotNull
    public final ArrayList<Message> getMessages() {
        return this.messages;
    }

    public void clear() {
        this.messages.clear();
    }

    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.messages.add(new Message(severity, message, location));
    }

    public boolean hasErrors() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.messages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Message it = (Message)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSeverity() == CompilerMessageSeverity.EXCEPTION || it.getSeverity() == CompilerMessageSeverity.ERROR)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.messages, (CharSequence)"\n", null, null, (int)0, null, TestMessageCollector::toString$lambda$2, (int)30, null);
    }

    private static final CharSequence toString$lambda$2(Message it) {
        Object object;
        StringBuilder stringBuilder;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                stringBuilder = new StringBuilder().append(it.getSeverity()).append(": ").append(it.getMessage());
                object = it.getLocation();
                if (object == null) break block2;
                CompilerMessageSourceLocation it2 = object;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl = false;
                String string = " at " + it2;
                stringBuilder = stringBuilder2;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return stringBuilder.append((String)object).toString();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/test/utils/TestMessageCollector$Message;", "", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "<init>", "(Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;)V", "getSeverity", "()Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "getMessage", "()Ljava/lang/String;", "getLocation", "()Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "tests-common-new_test"})
    public static final class Message {
        @NotNull
        private final CompilerMessageSeverity severity;
        @NotNull
        private final String message;
        @Nullable
        private final CompilerMessageSourceLocation location;

        public Message(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.severity = severity;
            this.message = message;
            this.location = location;
        }

        @NotNull
        public final CompilerMessageSeverity getSeverity() {
            return this.severity;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final CompilerMessageSourceLocation getLocation() {
            return this.location;
        }

        @NotNull
        public final CompilerMessageSeverity component1() {
            return this.severity;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @Nullable
        public final CompilerMessageSourceLocation component3() {
            return this.location;
        }

        @NotNull
        public final Message copy(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new Message(severity, message, location);
        }

        public static /* synthetic */ Message copy$default(Message message, CompilerMessageSeverity compilerMessageSeverity, String string, CompilerMessageSourceLocation compilerMessageSourceLocation, int n, Object object) {
            if ((n & 1) != 0) {
                compilerMessageSeverity = message.severity;
            }
            if ((n & 2) != 0) {
                string = message.message;
            }
            if ((n & 4) != 0) {
                compilerMessageSourceLocation = message.location;
            }
            return message.copy(compilerMessageSeverity, string, compilerMessageSourceLocation);
        }

        @NotNull
        public String toString() {
            return "Message(severity=" + this.severity + ", message=" + this.message + ", location=" + this.location + ')';
        }

        public int hashCode() {
            int result = this.severity.hashCode();
            result = result * 31 + this.message.hashCode();
            result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Message)) {
                return false;
            }
            Message message = (Message)other;
            if (this.severity != message.severity) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)message.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.location, (Object)message.location);
        }
    }
}

