/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.directives.model.Directive;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\u0003\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00012\u0006\u0010\b\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"withExtension", "Ljava/io/File;", "extension", "", "withSuffixAndExtension", "suffix", "isDirectiveDefined", "", "directive", "removeDirectiveFromFile", "", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\norg/jetbrains/kotlin/test/utils/FileUtilsKt\n+ 2 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,40:1\n284#2,5:41\n1#3:46\n1251#4,2:47\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\norg/jetbrains/kotlin/test/utils/FileUtilsKt\n*L\n25#1:41,5\n25#1:46\n26#1:47,2\n*E\n"})
public final class FileUtilsKt {
    @NotNull
    public static final File withExtension(@NotNull File $this$withExtension, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)$this$withExtension, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return FileUtilsKt.withSuffixAndExtension($this$withExtension, "", extension);
    }

    @NotNull
    public static final File withSuffixAndExtension(@NotNull File $this$withSuffixAndExtension, @NotNull String suffix, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)$this$withSuffixAndExtension, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String extension2 = StringsKt.removePrefix((String)extension, (CharSequence)".");
        File file = $this$withSuffixAndExtension.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        return FilesKt.resolve((File)file, (String)(FilesKt.getNameWithoutExtension((File)$this$withSuffixAndExtension) + suffix + '.' + extension2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isDirectiveDefined(@NotNull File $this$isDirectiveDefined, @NotNull String directive) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isDirectiveDefined, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        File $this$useLines_u24default$iv = $this$isDirectiveDefined;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$useLines = false;
        Object object = $this$useLines_u24default$iv;
        int n = 8192;
        Object object2 = object;
        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), charset$iv);
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        Throwable throwable = null;
        try {
            boolean bl2;
            block6: {
                BufferedReader it$iv = (BufferedReader)object;
                boolean bl3 = false;
                Sequence line = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl4 = false;
                Sequence $this$any$iv = line;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)directive)) continue;
                    bl2 = true;
                    break block6;
                }
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return bl;
    }

    public static final void removeDirectiveFromFile(@NotNull File $this$removeDirectiveFromFile, @NotNull Directive directive) {
        String text;
        Intrinsics.checkNotNullParameter((Object)$this$removeDirectiveFromFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        if (!$this$removeDirectiveFromFile.exists()) {
            return;
        }
        String directiveName = directive.getName();
        Regex directiveRegexp = new Regex("^// " + directiveName + "(:.*)?$(\n)?", RegexOption.MULTILINE);
        MatchResult matchResult = Regex.find$default((Regex)directiveRegexp, (CharSequence)(text = FilesKt.readText$default((File)$this$removeDirectiveFromFile, null, (int)1, null)), (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getRange()) == null) {
            throw new IllegalStateException(("Directive " + directiveName + " was not found in " + $this$removeDirectiveFromFile).toString());
        }
        MatchResult directiveRange = matchResult;
        String textWithoutDirective = ((Object)StringsKt.removeRange((CharSequence)text, (IntRange)directiveRange)).toString();
        FilesKt.writeText$default((File)$this$removeDirectiveFromFile, (String)textWithoutDirective, null, (int)2, null);
    }
}

