/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.SourceFileProvider;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.CustomTestDataUtilsKt;
import org.jetbrains.kotlin.test.utils.FirIdenticalCheckerHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH$J\u0014\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J>\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0004R\u0018\u0010\u0006\u001a\u00060\u0007R\u00020\u0000X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "helper", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker$SpecificHelper;", "getHelper", "()Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker$SpecificHelper;", "checkTestDataFile", "", "testDataFile", "Ljava/io/File;", "check", "failedAssertions", "", "Lorg/jetbrains/kotlin/test/WrappedException;", "assertPreprocessedTestDataAreEqual", "baseFile", "baseContent", "", "customFile", "customContent", "message", "Lkotlin/Function0;", "SpecificHelper", "tests-common-new_test"})
public abstract class AbstractFirIdenticalChecker
extends AfterAnalysisChecker {
    @NotNull
    private final SpecificHelper helper;

    public AbstractFirIdenticalChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
        this.helper = new SpecificHelper();
    }

    @NotNull
    protected final SpecificHelper getHelper() {
        return this.helper;
    }

    protected abstract void checkTestDataFile(@NotNull File var1);

    @Override
    public final void check(@NotNull List<? extends WrappedException> failedAssertions) {
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        if (!((Collection)failedAssertions).isEmpty()) {
            return;
        }
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        this.checkTestDataFile(testDataFile);
    }

    protected final void assertPreprocessedTestDataAreEqual(@NotNull TestServices testServices, @NotNull File baseFile, @NotNull String baseContent, @NotNull File customFile, @NotNull String customContent, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)baseFile, (String)"baseFile");
        Intrinsics.checkNotNullParameter((Object)baseContent, (String)"baseContent");
        Intrinsics.checkNotNullParameter((Object)customFile, (String)"customFile");
        Intrinsics.checkNotNullParameter((Object)customContent, (String)"customContent");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        SourceFileProvider sourceFileProvider = SourceFileProviderKt.getSourceFileProvider(testServices);
        String string = baseFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String processedBaseContent = StringsKt.replace$default((String)sourceFileProvider.getContentOfSourceFile(new TestFile(string, baseContent, baseFile, 0, false, RegisteredDirectives.Companion.getEmpty())), (String)"\r", (String)"", (boolean)false, (int)4, null);
        SourceFileProvider sourceFileProvider2 = SourceFileProviderKt.getSourceFileProvider(testServices);
        String string2 = customFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String processedLlContent = StringsKt.replace$default((String)sourceFileProvider2.getContentOfSourceFile(new TestFile(string2, customContent, customFile, 0, false, RegisteredDirectives.Companion.getEmpty())), (String)"\r", (String)"", (boolean)false, (int)4, null);
        AssertionsKt.getAssertions(testServices).assertEquals(processedBaseContent, processedLlContent, message);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker$SpecificHelper;", "Lorg/jetbrains/kotlin/test/utils/FirIdenticalCheckerHelper;", "<init>", "(Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker;)V", "getClassicFileToCompare", "Ljava/io/File;", "testDataFile", "getFirFileToCompare", "tests-common-new_test"})
    protected final class SpecificHelper
    extends FirIdenticalCheckerHelper {
        public SpecificHelper() {
            super(AbstractFirIdenticalChecker.this.getTestServices());
        }

        @Override
        @NotNull
        public File getClassicFileToCompare(@NotNull File testDataFile) {
            Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
            return CustomTestDataUtilsKt.getOriginalTestDataFile(testDataFile);
        }

        @Override
        @NotNull
        public File getFirFileToCompare(@NotNull File testDataFile) {
            Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
            return CustomTestDataUtilsKt.getFirTestDataFile(testDataFile);
        }
    }
}

