/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.configuration;

import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.jvm.JvmPhasesKt;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.JvmSerializeIrMode;
import org.jetbrains.kotlin.config.JvmStringConcat;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.MockLibraryUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestJavacVersion;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.ConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;
import org.jetbrains.kotlin.test.services.DirectiveToConfigurationKeyExtractor;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.JUnit5Assertions;
import org.jetbrains.kotlin.test.services.KotlinStandardLibrariesPathProvider;
import org.jetbrains.kotlin.test.services.KotlinStandardLibrariesPathProviderKt;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.AdditionalClassPathForJavaCompilationOrAnalysis;
import org.jetbrains.kotlin.test.services.configuration.JvmEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.configuration.JvmEnvironmentConfiguratorKt;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManager;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManagerKt;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.util.StringUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u001a\u0010\u0016\u001a\u00020\u000f*\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0007H\u0002J\"\u0010\u0019\u001a\u00020\u000f*\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0007H\u0002J\u001c\u0010\u001c\u001a\u00020\u000f*\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u001e\u001a\u00020\u000f*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u001f\u001a\u00020\u000f*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0007*\b\u0012\u0004\u0012\u00020\"0\u0007H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u00072\u0006\u0010$\u001a\u00020\"H\u0014R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\n\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/JvmEnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "additionalServices", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "getAdditionalServices", "provideConfigurationKeys", "", "Lorg/jetbrains/kotlin/test/services/DirectiveToConfigurationKeyExtractor;", "configureCompilerConfiguration", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "addJavaSourceRootsByJavaModules", "javaModuleInfoFiles", "Lorg/jetbrains/kotlin/test/model/TestFile;", "addJavaBinaryRootsByJavaModules", "configurationKind", "Lorg/jetbrains/kotlin/test/ConfigurationKind;", "addJavaBinaryRootsByCompiledJavaModulesFromModuleDependencies", "configureDefaultJvmTarget", "putCustomPhaseConfigWithEnabledDump", "registerModuleDependencies", "toFileList", "Ljava/io/File;", "Lorg/jetbrains/kotlin/test/model/DependencyDescription;", "convertDependencyToFileList", "dependency", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nJvmEnvironmentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/JvmEnvironmentConfigurator\n+ 2 TestServices.kt\norg/jetbrains/kotlin/test/services/TestServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,379:1\n25#2:380\n1#3:381\n1#3:428\n1863#4,2:382\n774#4:384\n865#4,2:385\n1557#4:387\n1628#4,3:388\n1557#4:391\n1628#4,3:392\n1557#4:395\n1628#4,3:396\n1557#4:399\n1628#4,3:400\n1557#4:403\n1628#4,3:404\n1611#4,9:407\n1863#4:416\n669#4,11:417\n1864#4:429\n1620#4:430\n774#4:431\n865#4,2:432\n774#4:434\n865#4,2:435\n1557#4:437\n1628#4,3:438\n1368#4:441\n1454#4,5:442\n*S KotlinDebug\n*F\n+ 1 JvmEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/JvmEnvironmentConfigurator\n*L\n158#1:380\n313#1:428\n237#1:382,2\n238#1:384\n238#1:385,2\n250#1:387\n250#1:388,3\n258#1:391\n258#1:392,3\n286#1:395\n286#1:396,3\n288#1:399\n288#1:400,3\n312#1:403\n312#1:404,3\n313#1:407,9\n313#1:416\n314#1:417,11\n313#1:429\n313#1:430\n352#1:431\n352#1:432,2\n354#1:434\n354#1:435,2\n356#1:437\n356#1:438,3\n360#1:441\n360#1:442,5\n*E\n"})
public class JvmEnvironmentConfigurator
extends EnvironmentConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final CompilerConfigurationKey<ConfigurationKind> TEST_CONFIGURATION_KIND_KEY;
    @Nullable
    private static final String DEFAULT_JVM_TARGET_FROM_PROPERTY;
    @NotNull
    private static final String JAVA_BINARIES_JAR_NAME = "java-binaries";

    public JvmEnvironmentConfigurator(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)JvmEnvironmentConfigurationDirectives.INSTANCE);
    }

    @Override
    @NotNull
    public List<ServiceRegistrationData> getAdditionalServices() {
        Function1 serviceConstructor$iv = additionalServices.1.INSTANCE;
        boolean $i$f$service = false;
        return CollectionsKt.listOf((Object)new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(CompiledClassesManager.class), (Function1<? super TestServices, ? extends TestService>)serviceConstructor$iv));
    }

    @Override
    public void provideConfigurationKeys(@NotNull DirectiveToConfigurationKeyExtractor $this$provideConfigurationKeys) {
        Intrinsics.checkNotNullParameter((Object)$this$provideConfigurationKeys, (String)"<this>");
        ValueDirective<JvmStringConcat> valueDirective = JvmEnvironmentConfigurationDirectives.INSTANCE.getSTRING_CONCAT();
        CompilerConfigurationKey compilerConfigurationKey = JVMConfigurationKeys.STRING_CONCAT;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey, (String)"STRING_CONCAT");
        $this$provideConfigurationKeys.register(valueDirective, compilerConfigurationKey);
        ValueDirective<JVMAssertionsMode> valueDirective2 = JvmEnvironmentConfigurationDirectives.INSTANCE.getASSERTIONS_MODE();
        CompilerConfigurationKey compilerConfigurationKey2 = JVMConfigurationKeys.ASSERTIONS_MODE;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey2, (String)"ASSERTIONS_MODE");
        $this$provideConfigurationKeys.register(valueDirective2, compilerConfigurationKey2);
        ValueDirective<JvmClosureGenerationScheme> valueDirective3 = JvmEnvironmentConfigurationDirectives.INSTANCE.getSAM_CONVERSIONS();
        CompilerConfigurationKey compilerConfigurationKey3 = JVMConfigurationKeys.SAM_CONVERSIONS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey3, (String)"SAM_CONVERSIONS");
        $this$provideConfigurationKeys.register(valueDirective3, compilerConfigurationKey3);
        ValueDirective<JvmClosureGenerationScheme> valueDirective4 = JvmEnvironmentConfigurationDirectives.INSTANCE.getLAMBDAS();
        CompilerConfigurationKey compilerConfigurationKey4 = JVMConfigurationKeys.LAMBDAS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey4, (String)"LAMBDAS");
        $this$provideConfigurationKeys.register(valueDirective4, compilerConfigurationKey4);
        SimpleDirective simpleDirective = JvmEnvironmentConfigurationDirectives.INSTANCE.getUSE_OLD_INLINE_CLASSES_MANGLING_SCHEME();
        CompilerConfigurationKey compilerConfigurationKey5 = JVMConfigurationKeys.USE_OLD_INLINE_CLASSES_MANGLING_SCHEME;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey5, (String)"USE_OLD_INLINE_CLASSES_MANGLING_SCHEME");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective, compilerConfigurationKey5, false, 4, null);
        SimpleDirective simpleDirective2 = LanguageSettingsDirectives.INSTANCE.getENABLE_JVM_PREVIEW();
        CompilerConfigurationKey compilerConfigurationKey6 = JVMConfigurationKeys.ENABLE_JVM_PREVIEW;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey6, (String)"ENABLE_JVM_PREVIEW");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective2, compilerConfigurationKey6, false, 4, null);
        SimpleDirective simpleDirective3 = LanguageSettingsDirectives.INSTANCE.getEMIT_JVM_TYPE_ANNOTATIONS();
        CompilerConfigurationKey compilerConfigurationKey7 = JVMConfigurationKeys.EMIT_JVM_TYPE_ANNOTATIONS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey7, (String)"EMIT_JVM_TYPE_ANNOTATIONS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective3, compilerConfigurationKey7, false, 4, null);
        SimpleDirective simpleDirective4 = LanguageSettingsDirectives.INSTANCE.getNO_OPTIMIZED_CALLABLE_REFERENCES();
        CompilerConfigurationKey compilerConfigurationKey8 = JVMConfigurationKeys.NO_OPTIMIZED_CALLABLE_REFERENCES;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey8, (String)"NO_OPTIMIZED_CALLABLE_REFERENCES");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective4, compilerConfigurationKey8, false, 4, null);
        SimpleDirective simpleDirective5 = LanguageSettingsDirectives.INSTANCE.getDISABLE_PARAM_ASSERTIONS();
        CompilerConfigurationKey compilerConfigurationKey9 = JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey9, (String)"DISABLE_PARAM_ASSERTIONS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective5, compilerConfigurationKey9, false, 4, null);
        SimpleDirective simpleDirective6 = LanguageSettingsDirectives.INSTANCE.getDISABLE_CALL_ASSERTIONS();
        CompilerConfigurationKey compilerConfigurationKey10 = JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey10, (String)"DISABLE_CALL_ASSERTIONS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective6, compilerConfigurationKey10, false, 4, null);
        SimpleDirective simpleDirective7 = LanguageSettingsDirectives.INSTANCE.getNO_UNIFIED_NULL_CHECKS();
        CompilerConfigurationKey compilerConfigurationKey11 = JVMConfigurationKeys.NO_UNIFIED_NULL_CHECKS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey11, (String)"NO_UNIFIED_NULL_CHECKS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective7, compilerConfigurationKey11, false, 4, null);
        SimpleDirective simpleDirective8 = LanguageSettingsDirectives.INSTANCE.getPARAMETERS_METADATA();
        CompilerConfigurationKey compilerConfigurationKey12 = JVMConfigurationKeys.PARAMETERS_METADATA;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey12, (String)"PARAMETERS_METADATA");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective8, compilerConfigurationKey12, false, 4, null);
        ValueDirective<JvmTarget> valueDirective5 = JvmEnvironmentConfigurationDirectives.INSTANCE.getJVM_TARGET();
        CompilerConfigurationKey compilerConfigurationKey13 = JVMConfigurationKeys.JVM_TARGET;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey13, (String)"JVM_TARGET");
        $this$provideConfigurationKeys.register(valueDirective5, compilerConfigurationKey13);
        ValueDirective<JvmSerializeIrMode> valueDirective6 = JvmEnvironmentConfigurationDirectives.INSTANCE.getSERIALIZE_IR();
        CompilerConfigurationKey compilerConfigurationKey14 = JVMConfigurationKeys.SERIALIZE_IR;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey14, (String)"SERIALIZE_IR");
        $this$provideConfigurationKeys.register(valueDirective6, compilerConfigurationKey14);
        ValueDirective<Integer> valueDirective7 = LanguageSettingsDirectives.INSTANCE.getJDK_RELEASE();
        CompilerConfigurationKey compilerConfigurationKey15 = JVMConfigurationKeys.JDK_RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey15, (String)"JDK_RELEASE");
        $this$provideConfigurationKeys.register(valueDirective7, compilerConfigurationKey15);
        SimpleDirective simpleDirective9 = LanguageSettingsDirectives.INSTANCE.getUSE_TYPE_TABLE();
        CompilerConfigurationKey compilerConfigurationKey16 = JVMConfigurationKeys.USE_TYPE_TABLE;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey16, (String)"USE_TYPE_TABLE");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective9, compilerConfigurationKey16, false, 4, null);
        SimpleDirective simpleDirective10 = JvmEnvironmentConfigurationDirectives.INSTANCE.getENABLE_DEBUG_MODE();
        CompilerConfigurationKey compilerConfigurationKey17 = JVMConfigurationKeys.ENABLE_DEBUG_MODE;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey17, (String)"ENABLE_DEBUG_MODE");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective10, compilerConfigurationKey17, false, 4, null);
        SimpleDirective simpleDirective11 = LanguageSettingsDirectives.INSTANCE.getNO_NEW_JAVA_ANNOTATION_TARGETS();
        CompilerConfigurationKey compilerConfigurationKey18 = JVMConfigurationKeys.NO_NEW_JAVA_ANNOTATION_TARGETS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey18, (String)"NO_NEW_JAVA_ANNOTATION_TARGETS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective11, compilerConfigurationKey18, false, 4, null);
        SimpleDirective simpleDirective12 = LanguageSettingsDirectives.INSTANCE.getOLD_INNER_CLASSES_LOGIC();
        CompilerConfigurationKey compilerConfigurationKey19 = JVMConfigurationKeys.OLD_INNER_CLASSES_LOGIC;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey19, (String)"OLD_INNER_CLASSES_LOGIC");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective12, compilerConfigurationKey19, false, 4, null);
        SimpleDirective simpleDirective13 = LanguageSettingsDirectives.INSTANCE.getLINK_VIA_SIGNATURES_K1();
        CompilerConfigurationKey compilerConfigurationKey20 = JVMConfigurationKeys.LINK_VIA_SIGNATURES;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey20, (String)"LINK_VIA_SIGNATURES");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective13, compilerConfigurationKey20, false, 4, null);
        SimpleDirective simpleDirective14 = LanguageSettingsDirectives.INSTANCE.getENABLE_JVM_IR_INLINER();
        CompilerConfigurationKey compilerConfigurationKey21 = JVMConfigurationKeys.ENABLE_IR_INLINER;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey21, (String)"ENABLE_IR_INLINER");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective14, compilerConfigurationKey21, false, 4, null);
        SimpleDirective simpleDirective15 = LanguageSettingsDirectives.INSTANCE.getUSE_INLINE_SCOPES_NUMBERS();
        CompilerConfigurationKey compilerConfigurationKey22 = JVMConfigurationKeys.USE_INLINE_SCOPES_NUMBERS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey22, (String)"USE_INLINE_SCOPES_NUMBERS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective15, compilerConfigurationKey22, false, 4, null);
        SimpleDirective simpleDirective16 = JvmEnvironmentConfigurationDirectives.INSTANCE.getUSE_PSI_CLASS_FILES_READING();
        CompilerConfigurationKey compilerConfigurationKey23 = JVMConfigurationKeys.USE_PSI_CLASS_FILES_READING;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey23, (String)"USE_PSI_CLASS_FILES_READING");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective16, compilerConfigurationKey23, false, 4, null);
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, LanguageSettingsDirectives.INSTANCE.getALLOW_KOTLIN_PACKAGE(), CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureCompilerConfiguration(@NotNull CompilerConfiguration configuration2, @NotNull TestModule module) {
        Iterable destination$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Object element$iv2;
        Object object;
        Object object2;
        Object it;
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!JvmPlatforms.INSTANCE.getAllJvmPlatforms().contains(module.getTargetPlatform())) {
            return;
        }
        this.configureDefaultJvmTarget(configuration2);
        RegisteredDirectives registeredDirectives = module.getDirectives();
        TestJdkKind jdkKind = Companion.extractJdkKind(registeredDirectives);
        File file = Companion.getJdkHome(jdkKind);
        if (file != null) {
            it = file;
            boolean bl = false;
            configuration2.put(JVMConfigurationKeys.JDK_HOME, it);
        }
        File file2 = Companion.getJdkClasspathRoot(jdkKind);
        if (file2 != null) {
            it = file2;
            boolean bl = false;
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration2, (File)it);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[jdkKind.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                configuration2.put(JVMConfigurationKeys.NO_JDK, (Object)true);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ConfigurationKind configurationKind = Companion.extractConfigurationKind(registeredDirectives);
        it = configurationKind;
        boolean bl = false;
        configuration2.put(TEST_CONFIGURATION_KIND_KEY, it);
        ConfigurationKind configurationKind2 = configurationKind;
        if (configurationKind2.getWithRuntime()) {
            configurationKind = new K2JVMCompilerArguments();
            it = configurationKind;
            object2 = KotlinStandardLibrariesPathProviderKt.getStandardLibrariesPathProvider(this.getTestServices());
            object = configuration2;
            boolean bl2 = false;
            it.setNoReflect(true);
            Unit unit = Unit.INSTANCE;
            KotlinStandardLibrariesPathProviderKt.configureStandardLibs((CompilerConfiguration)object, (KotlinStandardLibrariesPathProvider)object2, (K2JVMCompilerArguments)configurationKind);
        }
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)configuration2, Companion.getLibraryFilesExceptRealRuntime(this.getTestServices(), configurationKind2, module.getDirectives()));
        TargetBackend targetBackend = module.getTargetBackend();
        boolean isIr = !(targetBackend != null ? !targetBackend.isIR() : false);
        configuration2.put(JVMConfigurationKeys.IR, (Object)isIr);
        configuration2.putIfAbsent(CommonConfigurationKeys.EVALUATED_CONST_TRACKER, (Object)EvaluatedConstTracker.Companion.create());
        if (module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_IR_FOR_GIVEN_PHASES())) {
            this.putCustomPhaseConfigWithEnabledDump(configuration2, module);
        }
        configuration2.put(JVMConfigurationKeys.VALIDATE_IR, (Object)true);
        configuration2.put(JVMConfigurationKeys.VALIDATE_BYTECODE, (Object)true);
        JvmContentRootsKt.configureJdkClasspathRoots((CompilerConfiguration)configuration2);
        this.registerModuleDependencies(configuration2, module);
        this.addJavaBinaryRootsByCompiledJavaModulesFromModuleDependencies(configuration2, configurationKind2, module);
        Collection bl2 = SourceFileProviderKt.getJavaFiles(module);
        if (bl2.isEmpty()) {
            boolean bl3 = false;
            return;
        }
        List javaFiles = (List)bl2;
        Iterable $this$forEach$iv = javaFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            TestFile it2 = (TestFile)element$iv2;
            boolean bl4 = false;
            SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getOrCreateRealFileForSourceFile(it2);
        }
        Iterable $this$filter$iv = javaFiles;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TestFile it3 = (TestFile)element$iv$iv;
            boolean bl5 = false;
            if (!Intrinsics.areEqual((Object)it3.getName(), (Object)"module-info.java")) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List javaModuleInfoFiles = (List)destination$iv$iv2;
        if (!registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getPROVIDE_JAVA_AS_BINARIES())) {
            List list;
            List list2;
            if (!((Collection)javaModuleInfoFiles).isEmpty()) {
                this.addJavaSourceRootsByJavaModules(configuration2, javaModuleInfoFiles);
            } else {
                JvmContentRootsKt.addJavaSourceRoot$default((CompilerConfiguration)configuration2, (File)SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getJavaSourceDirectoryForModule(module), null, (int)2, null);
            }
            CompilerConfiguration compilerConfiguration = configuration2;
            Object object3 = JvmEnvironmentConfiguratorKt.getAdditionalClassPathForJavaCompilationOrAnalysis(this.getTestServices());
            if (object3 != null && (object3 = ((AdditionalClassPathForJavaCompilationOrAnalysis)object3).getClassPath()) != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$filterTo$iv$iv = (Iterable)object3;
                object = compilerConfiguration;
                boolean $i$f$map = false;
                void $i$f$filterTo2 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    String string = (String)item$iv$iv;
                    object2 = destination$iv$iv;
                    boolean bl6 = false;
                    object2.add(new File((String)p0));
                }
                list2 = (List)destination$iv$iv;
                compilerConfiguration = object;
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)compilerConfiguration, list);
        } else if (!((Collection)javaModuleInfoFiles).isEmpty()) {
            this.addJavaBinaryRootsByJavaModules(configuration2, configurationKind2, javaModuleInfoFiles);
        } else {
            void $this$mapTo$iv$iv;
            TestJavacVersion javaVersionToCompile = (TestJavacVersion)((Object)CollectionsKt.singleOrNull(registeredDirectives.get(JvmEnvironmentConfigurationDirectives.INSTANCE.getCOMPILE_JAVA_TO_BINARIES_USING())));
            boolean useJava11ToCompileIncludedJavaFiles = javaVersionToCompile == TestJavacVersion.JAVAC_11;
            Iterable $this$map$iv = JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)configuration2);
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                File bl6 = (File)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl7 = false;
                object.add(it4.getAbsolutePath());
            }
            List jvmClasspathRoots = (List)destination$iv$iv3;
            AdditionalClassPathForJavaCompilationOrAnalysis additionalClassPathForJavaCompilationOrAnalysis = JvmEnvironmentConfiguratorKt.getAdditionalClassPathForJavaCompilationOrAnalysis(this.getTestServices());
            List list = additionalClassPathForJavaCompilationOrAnalysis != null ? additionalClassPathForJavaCompilationOrAnalysis.getClassPath() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List additionalClassPath = list;
            String string = SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getJavaSourceDirectoryForModule(module).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration2, (File)MockLibraryUtil.compileJavaFilesLibraryToJar$default(string, module.getName() + "-java-binaries", false, null, CollectionsKt.plus((Collection)jvmClasspathRoots, (Iterable)additionalClassPath), null, JUnit5Assertions.INSTANCE, useJava11ToCompileIncludedJavaFiles, 44, null));
        }
    }

    private final void addJavaSourceRootsByJavaModules(CompilerConfiguration $this$addJavaSourceRootsByJavaModules, List<TestFile> javaModuleInfoFiles) {
        for (TestFile javaModuleInfoFile : javaModuleInfoFiles) {
            File javaModuleDir = SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getOrCreateRealFileForSourceFile(javaModuleInfoFile).getParentFile();
            Intrinsics.checkNotNull((Object)javaModuleDir);
            JvmContentRootsKt.addJavaSourceRoot$default((CompilerConfiguration)$this$addJavaSourceRootsByJavaModules, (File)javaModuleDir, null, (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addJavaBinaryRootsByJavaModules(CompilerConfiguration $this$addJavaBinaryRootsByJavaModules, ConfigurationKind configurationKind, List<TestFile> javaModuleInfoFiles) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void p0;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv2 = JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)$this$addJavaBinaryRootsByJavaModules);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getAbsolutePath());
        }
        List classPath = (List)destination$iv$iv;
        List list = CollectionsKt.createListBuilder();
        List $this$addJavaBinaryRootsByJavaModules_u24lambda_u2410 = list;
        boolean bl = false;
        Iterable $i$f$mapTo22 = JvmContentRootsKt.getJvmModularRoots((CompilerConfiguration)$this$addJavaBinaryRootsByJavaModules);
        List list2 = $this$addJavaBinaryRootsByJavaModules_u24lambda_u2410;
        boolean $i$f$map2 = false;
        p0 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p02;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(p02.getAbsolutePath());
        }
        list2.addAll((List)destination$iv$iv2);
        if (configurationKind.getWithRuntime()) {
            $this$addJavaBinaryRootsByJavaModules_u24lambda_u2410.add(KotlinStandardLibrariesPathProviderKt.getStandardLibrariesPathProvider(this.getTestServices()).runtimeJarForTests().getPath());
        }
        List modulePath = CollectionsKt.build((List)list);
        for (TestFile javaModuleInfoFile : javaModuleInfoFiles) {
            File javaModuleDir = SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getOrCreateRealFileForSourceFile(javaModuleInfoFile).getParentFile();
            String javaModuleName = StringsKt.substringBefore$default((String)javaModuleInfoFile.getRelativePath(), (char)'/', null, (int)2, null);
            String string = javaModuleDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            File javaModuleBinary = MockLibraryUtil.compileJavaFilesLibraryToJar$default(string, javaModuleName + "-java-binaries", false, null, classPath, modulePath, JUnit5Assertions.INSTANCE, true, 12, null);
            JvmArgumentsKt.addModularRootIfNotNull((CompilerConfiguration)$this$addJavaBinaryRootsByJavaModules, (boolean)true, (String)javaModuleName, (File)javaModuleBinary);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addJavaBinaryRootsByCompiledJavaModulesFromModuleDependencies(CompilerConfiguration $this$addJavaBinaryRootsByCompiledJavaModulesFromModuleDependencies, ConfigurationKind configurationKind, TestModule module) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = module.getAllDependencies();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DependencyDescription dependencyDescription = (DependencyDescription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DependencyProviderKt.getDependencyProvider(this.getTestServices()).getTestModule(it.getModuleName()));
        }
        List moduleDependencies = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = moduleDependencies;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TestFile it$iv$iv;
            Object v0;
            block4: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                TestModule moduleDependency = (TestModule)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$singleOrNull$iv = SourceFileProviderKt.getJavaFiles(moduleDependency);
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    TestFile javaFile = (TestFile)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)javaFile.getName(), (Object)"module-info.java")) continue;
                    if (found$iv) {
                        v0 = null;
                        break block4;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            if ((TestFile)v0 == null) continue;
            boolean bl = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List javaModuleInfoFilesFromModuleDependencies = (List)destination$iv$iv2;
        this.addJavaBinaryRootsByJavaModules($this$addJavaBinaryRootsByCompiledJavaModulesFromModuleDependencies, configurationKind, javaModuleInfoFilesFromModuleDependencies);
    }

    private final void configureDefaultJvmTarget(CompilerConfiguration configuration2) {
        if (DEFAULT_JVM_TARGET_FROM_PROPERTY == null) {
            return;
        }
        JvmTarget jvmTarget = JvmTarget.Companion.fromString(DEFAULT_JVM_TARGET_FROM_PROPERTY);
        if (jvmTarget == null) {
            throw new IllegalStateException(("Can't construct JvmTarget for " + DEFAULT_JVM_TARGET_FROM_PROPERTY).toString());
        }
        JvmTarget customDefaultTarget = jvmTarget;
        JvmTarget originalTarget = (JvmTarget)configuration2.get(JVMConfigurationKeys.JVM_TARGET);
        if (originalTarget == null || customDefaultTarget.getMajorVersion() > originalTarget.getMajorVersion()) {
            configuration2.put(JVMConfigurationKeys.JVM_TARGET, (Object)customDefaultTarget);
        }
    }

    private final void putCustomPhaseConfigWithEnabledDump(CompilerConfiguration $this$putCustomPhaseConfigWithEnabledDump, TestModule module) {
        File dumpDirectory = TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.getTestServices(), "dumped_ir");
        Set phases = CollectionsKt.toSet((Iterable)module.getDirectives().get(CodegenTestDirectives.INSTANCE.getDUMP_IR_FOR_GIVEN_PHASES()));
        if (!((Collection)phases).isEmpty()) {
            PhaseConfig phaseConfig = new PhaseConfig((CompilerPhase)JvmPhasesKt.getJvmPhases(), null, null, null, phases, phases, dumpDirectory.getAbsolutePath(), null, null, null, false, false, false, 8078, null);
            $this$putCustomPhaseConfigWithEnabledDump.put(CLIConfigurationKeys.PHASE_CONFIG, (Object)phaseConfig);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerModuleDependencies(CompilerConfiguration $this$registerModuleDependencies, TestModule module) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv;
        Iterable iterable = module.getAllDependencies();
        JvmEnvironmentConfigurator jvmEnvironmentConfigurator = this;
        CompilerConfiguration compilerConfiguration = $this$registerModuleDependencies;
        boolean $i$f$filter = false;
        void var5_8 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            DependencyDescription it = (DependencyDescription)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == DependencyKind.Binary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<String> collection = (List)destination$iv$iv;
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)compilerConfiguration, jvmEnvironmentConfigurator.toFileList((List<DependencyDescription>)collection));
        Iterable $this$filter$iv2 = module.getFriendDependencies();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DependencyDescription it = (DependencyDescription)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == DependencyKind.Binary)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List binaryFriends = (List)destination$iv$iv2;
        if (!((Collection)binaryFriends).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$filter$iv2 = this.toFileList(binaryFriends);
            jvmEnvironmentConfigurator = JVMConfigurationKeys.FRIEND_PATHS;
            compilerConfiguration = $this$registerModuleDependencies;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                File it = (File)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getAbsolutePath());
            }
            collection = (List)destination$iv$iv2;
            compilerConfiguration.put((CompilerConfigurationKey)jvmEnvironmentConfigurator, (Object)collection);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> toFileList(List<DependencyDescription> $this$toFileList) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$toFileList;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DependencyDescription p0 = (DependencyDescription)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.convertDependencyToFileList(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected List<File> convertDependencyToFileList(@NotNull DependencyDescription dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        TestModule friendModule = DependencyProviderKt.getDependencyProvider(this.getTestServices()).getTestModule(dependency.getModuleName());
        Object[] objectArray = new File[]{CompiledClassesManager.getCompiledKotlinDirForModule$default(CompiledClassesManagerKt.getCompiledClassesManager(this.getTestServices()), friendModule, null, 2, null), CompiledClassesManagerKt.getCompiledClassesManager(this.getTestServices()).getCompiledJavaDirForModule(friendModule)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    static {
        CompilerConfigurationKey compilerConfigurationKey = CompilerConfigurationKey.create((String)"ConfigurationKind");
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey, (String)"create(...)");
        TEST_CONFIGURATION_KIND_KEY = compilerConfigurationKey;
        DEFAULT_JVM_TARGET_FROM_PROPERTY = System.getProperty("kotlin.test.default.jvm.target");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000fJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001a\u001a\u00020\u0011J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001c\u001a\u00020\u0011R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/JvmEnvironmentConfigurator$Companion;", "", "<init>", "()V", "TEST_CONFIGURATION_KIND_KEY", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "Lorg/jetbrains/kotlin/test/ConfigurationKind;", "kotlin.jvm.PlatformType", "getTEST_CONFIGURATION_KIND_KEY", "()Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "DEFAULT_JVM_TARGET_FROM_PROPERTY", "", "JAVA_BINARIES_JAR_NAME", "extractConfigurationKind", "registeredDirectives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "extractJdkKind", "Lorg/jetbrains/kotlin/test/TestJdkKind;", "getLibraryFilesExceptRealRuntime", "", "Ljava/io/File;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "configurationKind", "directives", "getJdkHome", "jdkKindTestJdkKind", "getJdkClasspathRoot", "jdkKind", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompilerConfigurationKey<ConfigurationKind> getTEST_CONFIGURATION_KIND_KEY() {
            return TEST_CONFIGURATION_KIND_KEY;
        }

        @NotNull
        public final ConfigurationKind extractConfigurationKind(@NotNull RegisteredDirectives registeredDirectives) {
            Intrinsics.checkNotNullParameter((Object)registeredDirectives, (String)"registeredDirectives");
            boolean withStdlib = registeredDirectives.contains(ConfigurationDirectives.INSTANCE.getWITH_STDLIB());
            boolean withReflect = registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getWITH_REFLECT());
            boolean noRuntime = registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getNO_RUNTIME());
            if (noRuntime && withStdlib) {
                throw new IllegalStateException("NO_RUNTIME and WITH_STDLIB can not be used together".toString());
            }
            return withStdlib && !withReflect ? ConfigurationKind.NO_KOTLIN_REFLECT : (withStdlib || withReflect ? ConfigurationKind.ALL : (noRuntime ? ConfigurationKind.JDK_NO_RUNTIME : ConfigurationKind.JDK_ONLY));
        }

        @NotNull
        public final TestJdkKind extractJdkKind(@NotNull RegisteredDirectives registeredDirectives) {
            TestJdkKind testJdkKind;
            Intrinsics.checkNotNullParameter((Object)registeredDirectives, (String)"registeredDirectives");
            boolean fullJdkEnabled = registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getFULL_JDK());
            List<TestJdkKind> jdkKinds = registeredDirectives.get(JvmEnvironmentConfigurationDirectives.INSTANCE.getJDK_KIND());
            if (fullJdkEnabled) {
                if (!((Collection)jdkKinds).isEmpty()) {
                    throw new IllegalStateException("FULL_JDK and JDK_KIND can not be used together".toString());
                }
                return TestJdkKind.FULL_JDK;
            }
            switch (jdkKinds.size()) {
                case 0: {
                    testJdkKind = TestJdkKind.MOCK_JDK;
                    break;
                }
                case 1: {
                    testJdkKind = (TestJdkKind)((Object)CollectionsKt.single(jdkKinds));
                    break;
                }
                default: {
                    throw new IllegalStateException(("Too many jdk kinds passed: " + StringUtilsKt.joinToArrayString((Iterable)jdkKinds)).toString());
                }
            }
            return testJdkKind;
        }

        @NotNull
        public final List<File> getLibraryFilesExceptRealRuntime(@NotNull TestServices testServices, @NotNull ConfigurationKind configurationKind, @NotNull RegisteredDirectives directives) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)((Object)configurationKind), (String)"configurationKind");
            Intrinsics.checkNotNullParameter((Object)directives, (String)"directives");
            KotlinStandardLibrariesPathProvider provider = KotlinStandardLibrariesPathProviderKt.getStandardLibrariesPathProvider(testServices);
            List files = new ArrayList();
            if (configurationKind.getWithRuntime()) {
                files.add(provider.kotlinTestJarForTests());
            } else if (configurationKind.getWithMockRuntime()) {
                files.add(provider.minimalRuntimeJarForTests());
                files.add(provider.scriptRuntimeJarForTests());
            }
            if (configurationKind.getWithReflection()) {
                files.add(provider.reflectJarForTests());
            }
            files.add(provider.getAnnotationsJar());
            if (directives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getSTDLIB_JDK8())) {
                files.add(provider.runtimeJarForTestsWithJdk8());
            }
            return files;
        }

        @Nullable
        public final File getJdkHome(@NotNull TestJdkKind jdkKindTestJdkKind) {
            File file;
            Intrinsics.checkNotNullParameter((Object)((Object)jdkKindTestJdkKind), (String)"jdkKindTestJdkKind");
            switch (WhenMappings.$EnumSwitchMapping$0[jdkKindTestJdkKind.ordinal()]) {
                case 1: {
                    file = null;
                    break;
                }
                case 2: {
                    file = null;
                    break;
                }
                case 3: {
                    String string = System.getenv("JDK_16");
                    if (string == null) {
                        throw new IllegalStateException("Environment variable JDK_16 is not set".toString());
                    }
                    file = new File(string);
                    break;
                }
                case 4: {
                    file = KtTestUtil.getJdk11Home();
                    break;
                }
                case 5: {
                    file = KtTestUtil.getJdk17Home();
                    break;
                }
                case 6: {
                    file = KtTestUtil.getJdk21Home();
                    break;
                }
                case 7: {
                    if (JavaVersion.current().compareTo(JavaVersion.compose((int)9)) >= 0) {
                        file = new File(System.getProperty("java.home"));
                        break;
                    }
                    file = null;
                    break;
                }
                case 8: {
                    file = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return file;
        }

        @Nullable
        public final File getJdkClasspathRoot(@NotNull TestJdkKind jdkKind) {
            File file;
            Intrinsics.checkNotNullParameter((Object)((Object)jdkKind), (String)"jdkKind");
            switch (WhenMappings.$EnumSwitchMapping$0[jdkKind.ordinal()]) {
                case 1: {
                    file = KtTestUtil.findMockJdkRtJar();
                    break;
                }
                case 2: {
                    file = KtTestUtil.findMockJdkRtModified();
                    break;
                }
                case 8: {
                    file = KtTestUtil.findAndroidApiJar();
                    break;
                }
                case 3: {
                    file = null;
                    break;
                }
                case 4: {
                    file = null;
                    break;
                }
                case 5: {
                    file = null;
                    break;
                }
                case 6: {
                    file = null;
                    break;
                }
                case 7: {
                    file = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return file;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TestJdkKind.values().length];
                try {
                    nArray[TestJdkKind.MOCK_JDK.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.MODIFIED_MOCK_JDK.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.FULL_JDK_6.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.FULL_JDK_11.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.FULL_JDK_17.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.FULL_JDK_21.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.FULL_JDK.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.ANDROID_API.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TestJdkKind.values().length];
            try {
                nArray[TestJdkKind.MOCK_JDK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.MODIFIED_MOCK_JDK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.ANDROID_API.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.FULL_JDK_6.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.FULL_JDK_11.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.FULL_JDK_17.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.FULL_JDK_21.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.FULL_JDK.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

