/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtInMemoryTextSourceFile;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.SourceFileProvider;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.util.AbstractArrayMapOwner;
import org.jetbrains.kotlin.util.ArrayMapAccessor;
import org.jetbrains.kotlin.util.TypeRegistry;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0007\u001a\u00020\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e\u001a6\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0010*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\n\u001a$\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00160\u0010*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012\u001a\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001e*\u00020\u00012\u0006\u0010%\u001a\u00020\u001f\"\u001f\u0010\u0000\u001a\u00020\u0001*\u00020\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0017\u001a\u00020\u000e*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u0015\u0010\u0019\u001a\u00020\u000e*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018\"\u0015\u0010\u001a\u001a\u00020\u000e*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\"\u0015\u0010\u001b\u001a\u00020\u000e*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0018\"\u0015\u0010\u001c\u001a\u00020\u000e*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018\"\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001e*\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\"\u0015\u0010\"\u001a\u00020\u000e*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0018\u00a8\u0006&"}, d2={"sourceFileProvider", "Lorg/jetbrains/kotlin/test/services/SourceFileProvider;", "Lorg/jetbrains/kotlin/test/services/TestServices;", "getSourceFileProvider", "(Lorg/jetbrains/kotlin/test/services/TestServices;)Lorg/jetbrains/kotlin/test/services/SourceFileProvider;", "sourceFileProvider$delegate", "Lorg/jetbrains/kotlin/util/ArrayMapAccessor;", "getKtFileForSourceFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "testFile", "Lorg/jetbrains/kotlin/test/model/TestFile;", "project", "Lcom/intellij/openapi/project/Project;", "findViaVfs", "", "getKtFilesForSourceFiles", "", "testFiles", "", "toLightTreeShortName", "", "getKtSourceFilesForSourceFiles", "Lorg/jetbrains/kotlin/KtSourceFile;", "isKtFile", "(Lorg/jetbrains/kotlin/test/model/TestFile;)Z", "isKtsFile", "isJavaFile", "isJsFile", "isMjsFile", "javaFiles", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "getJavaFiles", "(Lorg/jetbrains/kotlin/test/model/TestModule;)Ljava/util/List;", "isExternalAnnotation", "getRealJavaFiles", "Ljava/io/File;", "module", "test-infrastructure_test"})
@SourceDebugExtension(value={"SMAP\nSourceFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceFileProvider.kt\norg/jetbrains/kotlin/test/services/SourceFileProviderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 TestServices.kt\norg/jetbrains/kotlin/test/services/TestServices$Companion\n*L\n1#1,140:1\n1#2:141\n1#2:152\n1#2:165\n1611#3,9:142\n1863#3:151\n1864#3:153\n1620#3:154\n1611#3,9:155\n1863#3:164\n1864#3:166\n1620#3:167\n774#3:168\n865#3,2:169\n1557#3:171\n1628#3,3:172\n34#4:175\n*S KotlinDebug\n*F\n+ 1 SourceFileProvider.kt\norg/jetbrains/kotlin/test/services/SourceFileProviderKt\n*L\n97#1:152\n108#1:165\n97#1:142,9\n97#1:151\n97#1:153\n97#1:154\n108#1:155,9\n108#1:164\n108#1:166\n108#1:167\n132#1:168\n132#1:169,2\n138#1:171\n138#1:172,3\n39#1:175\n*E\n"})
public final class SourceFileProviderKt {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final ArrayMapAccessor sourceFileProvider$delegate;

    @NotNull
    public static final SourceFileProvider getSourceFileProvider(@NotNull TestServices $this$sourceFileProvider) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$sourceFileProvider), (String)"<this>");
        return (SourceFileProvider)sourceFileProvider$delegate.getValue((AbstractArrayMapOwner)$this$sourceFileProvider, $$delegatedProperties[0]);
    }

    @NotNull
    public static final KtFile getKtFileForSourceFile(@NotNull SourceFileProvider $this$getKtFileForSourceFile, @NotNull TestFile testFile, @NotNull Project project, boolean findViaVfs) {
        Intrinsics.checkNotNullParameter((Object)$this$getKtFileForSourceFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (findViaVfs) {
            File realFile = $this$getKtFileForSourceFile.getOrCreateRealFileForSourceFile(testFile);
            VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(realFile.getPath());
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(it);
                KtFile ktFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
                if (ktFile != null) {
                    it = ktFile;
                    boolean bl2 = false;
                    return it;
                }
            }
        }
        KtFile ktFile = KtTestUtil.createFile(testFile.getName(), $this$getKtFileForSourceFile.getContentOfSourceFile(testFile), project);
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"createFile(...)");
        return ktFile;
    }

    public static /* synthetic */ KtFile getKtFileForSourceFile$default(SourceFileProvider sourceFileProvider, TestFile testFile, Project project, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return SourceFileProviderKt.getKtFileForSourceFile(sourceFileProvider, testFile, project, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<TestFile, KtFile> getKtFilesForSourceFiles(@NotNull SourceFileProvider $this$getKtFilesForSourceFiles, @NotNull Collection<TestFile> testFiles, @NotNull Project project, boolean findViaVfs) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getKtFilesForSourceFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$mapNotNull$iv = testFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TestFile it = (TestFile)element$iv$iv;
            boolean bl2 = false;
            if ((!SourceFileProviderKt.isKtFile(it) ? null : TuplesKt.to((Object)it, (Object)SourceFileProviderKt.getKtFileForSourceFile($this$getKtFilesForSourceFiles, it, project, findViaVfs))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    public static /* synthetic */ Map getKtFilesForSourceFiles$default(SourceFileProvider sourceFileProvider, Collection collection, Project project, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return SourceFileProviderKt.getKtFilesForSourceFiles(sourceFileProvider, collection, project, bl);
    }

    @NotNull
    public static final String toLightTreeShortName(@NotNull TestFile $this$toLightTreeShortName) {
        Intrinsics.checkNotNullParameter((Object)$this$toLightTreeShortName, (String)"<this>");
        return StringsKt.substringAfterLast$default((String)StringsKt.substringAfterLast$default((String)$this$toLightTreeShortName.getName(), (char)'/', null, (int)2, null), (char)'\\', null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<TestFile, KtSourceFile> getKtSourceFilesForSourceFiles(@NotNull SourceFileProvider $this$getKtSourceFilesForSourceFiles, @NotNull Collection<TestFile> testFiles) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getKtSourceFilesForSourceFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
        Iterable $this$mapNotNull$iv = testFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TestFile it = (TestFile)element$iv$iv;
            boolean bl2 = false;
            if (!SourceFileProviderKt.isKtFile(it)) {
                pair = null;
            } else {
                String shortName = SourceFileProviderKt.toLightTreeShortName(it);
                KtInMemoryTextSourceFile ktSourceFile = new KtInMemoryTextSourceFile(shortName, '/' + shortName, (CharSequence)$this$getKtSourceFilesForSourceFiles.getContentOfSourceFile(it));
                pair = TuplesKt.to((Object)it, (Object)ktSourceFile);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    public static final boolean isKtFile(@NotNull TestFile $this$isKtFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isKtFile, (String)"<this>");
        return StringsKt.endsWith$default((String)$this$isKtFile.getName(), (String)".kt", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$isKtFile.getName(), (String)".kts", (boolean)false, (int)2, null);
    }

    public static final boolean isKtsFile(@NotNull TestFile $this$isKtsFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isKtsFile, (String)"<this>");
        return StringsKt.endsWith$default((String)$this$isKtsFile.getName(), (String)".kts", (boolean)false, (int)2, null);
    }

    public static final boolean isJavaFile(@NotNull TestFile $this$isJavaFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isJavaFile, (String)"<this>");
        return StringsKt.endsWith$default((String)$this$isJavaFile.getName(), (String)".java", (boolean)false, (int)2, null);
    }

    public static final boolean isJsFile(@NotNull TestFile $this$isJsFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isJsFile, (String)"<this>");
        return StringsKt.endsWith$default((String)$this$isJsFile.getName(), (String)".js", (boolean)false, (int)2, null);
    }

    public static final boolean isMjsFile(@NotNull TestFile $this$isMjsFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isMjsFile, (String)"<this>");
        return StringsKt.endsWith$default((String)$this$isMjsFile.getName(), (String)".mjs", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TestFile> getJavaFiles(@NotNull TestModule $this$javaFiles) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$javaFiles, (String)"<this>");
        Iterable $this$filter$iv = $this$javaFiles.getFiles();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TestFile it = (TestFile)element$iv$iv;
            boolean bl = false;
            if (!SourceFileProviderKt.isJavaFile(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isExternalAnnotation(@NotNull TestFile $this$isExternalAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$isExternalAnnotation, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isExternalAnnotation.getName(), (Object)"annotations.xml");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> getRealJavaFiles(@NotNull SourceFileProvider $this$getRealJavaFiles, @NotNull TestModule module) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getRealJavaFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Iterable $this$map$iv = SourceFileProviderKt.getJavaFiles(module);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TestFile testFile = (TestFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add($this$getRealJavaFiles.getOrCreateRealFileForSourceFile((TestFile)it));
        }
        return (List)destination$iv$iv;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Reflection.getOrCreateKotlinPackage(SourceFileProviderKt.class, (String)"test-infrastructure_test"), "sourceFileProvider", "getSourceFileProvider(Lorg/jetbrains/kotlin/test/services/TestServices;)Lorg/jetbrains/kotlin/test/services/SourceFileProvider;")))};
        $$delegatedProperties = kPropertyArray;
        TestServices.Companion this_$iv = TestServices.Companion;
        boolean $i$f$testServiceAccessor = false;
        sourceFileProvider$delegate = TypeRegistry.generateAccessor$default((TypeRegistry)((TypeRegistry)this_$iv), (KClass)Reflection.getOrCreateKotlinClass(SourceFileProvider.class), null, (int)2, null);
    }
}

