/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic;

import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.serialization.KotlinFileSerializedData;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibSingleFileMetadataSerializer;
import org.jetbrains.kotlin.backend.jvm.JvmIrCodegenFactory;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.js.klib.IrForKlibKt;
import org.jetbrains.kotlin.cli.js.klib.TopDownAnalyzerFacadeForJSIR;
import org.jetbrains.kotlin.cli.js.klib.TopDownAnalyzerFacadeForWasm;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.CodegenFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporterFactory;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.KlibMetadataIncrementalSerializer;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsManglerIr;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmIrMangler;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.util.IdSignatureComposer;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.js.config.ErrorTolerancePolicy;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.platform.wasm.WasmTarget;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.JsEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.frontend.classic.ClassicFrontend2IrConverter;
import org.jetbrains.kotlin.test.frontend.classic.ClassicFrontendOutputArtifact;
import org.jetbrains.kotlin.test.model.BackendKinds;
import org.jetbrains.kotlin.test.model.Frontend2BackendConverter;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.LibraryProvider;
import org.jetbrains.kotlin.test.services.LibraryProviderKt;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.JsEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.configuration.WasmEnvironmentConfigurator;
import org.jetbrains.kotlin.wasm.config.WasmConfigurationKeys;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/ClassicFrontend2IrConverter;", "Lorg/jetbrains/kotlin/test/model/Frontend2BackendConverter;", "Lorg/jetbrains/kotlin/test/frontend/classic/ClassicFrontendOutputArtifact;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "additionalServices", "", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "getAdditionalServices", "()Ljava/util/List;", "transform", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "inputArtifact", "transformToJvmIr", "transformToJsIr", "transformToWasmIr", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nClassicFrontend2IrConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicFrontend2IrConverter.kt\norg/jetbrains/kotlin/test/frontend/classic/ClassicFrontend2IrConverter\n+ 2 TestServices.kt\norg/jetbrains/kotlin/test/services/TestServicesKt\n*L\n1#1,183:1\n25#2:184\n*S KotlinDebug\n*F\n+ 1 ClassicFrontend2IrConverter.kt\norg/jetbrains/kotlin/test/frontend/classic/ClassicFrontend2IrConverter\n*L\n49#1:184\n*E\n"})
public final class ClassicFrontend2IrConverter
extends Frontend2BackendConverter<ClassicFrontendOutputArtifact, IrBackendInput> {
    public ClassicFrontend2IrConverter(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, FrontendKinds.ClassicFrontend.INSTANCE, BackendKinds.IrBackend.INSTANCE);
    }

    @Override
    @NotNull
    public List<ServiceRegistrationData> getAdditionalServices() {
        Function1 serviceConstructor$iv = additionalServices.1.INSTANCE;
        boolean $i$f$service = false;
        return CollectionsKt.listOf((Object)new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(LibraryProvider.class), (Function1<? super TestServices, ? extends TestService>)serviceConstructor$iv));
    }

    @Override
    @NotNull
    public IrBackendInput transform(@NotNull TestModule module, @NotNull ClassicFrontendOutputArtifact inputArtifact) {
        IrBackendInput irBackendInput;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)inputArtifact, (String)"inputArtifact");
        TargetBackend targetBackend = module.getTargetBackend();
        switch (targetBackend == null ? -1 : WhenMappings.$EnumSwitchMapping$0[targetBackend.ordinal()]) {
            case 1: 
            case 2: {
                irBackendInput = this.transformToJvmIr(module, inputArtifact);
                break;
            }
            case 3: 
            case 4: {
                irBackendInput = this.transformToJsIr(module, inputArtifact);
                break;
            }
            case 5: {
                irBackendInput = this.transformToWasmIr(module, inputArtifact);
                break;
            }
            default: {
                AssertionsKt.getAssertions(this.getTestServices()).fail((Function0<String>)((Function0)() -> ClassicFrontend2IrConverter.transform$lambda$0(module)));
                throw null;
            }
        }
        return irBackendInput;
    }

    private final IrBackendInput transformToJvmIr(TestModule module, ClassicFrontendOutputArtifact inputArtifact) {
        Map<TestFile, KtFile> psiFiles = inputArtifact.component1();
        AnalysisResult analysisResult = inputArtifact.component2();
        Project project = inputArtifact.component3();
        CompilerConfiguration configuration2 = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.getTestServices()).getCompilerConfiguration(module);
        PhaseConfig phaseConfig = (PhaseConfig)configuration2.get(CLIConfigurationKeys.PHASE_CONFIG);
        JvmIrCodegenFactory codegenFactory = new JvmIrCodegenFactory(configuration2, phaseConfig, null, null, null, null, null, 124, null);
        ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.TEST;
        Intrinsics.checkNotNullExpressionValue((Object)classBuilderFactory, (String)"TEST");
        GenerationState state = new GenerationState.Builder(project, classBuilderFactory, analysisResult.getModuleDescriptor(), analysisResult.getBindingContext(), configuration2).isIrBackend(true).ignoreErrors(module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_ERRORS())).diagnosticReporter((DiagnosticReporter)DiagnosticReporterFactory.createReporter$default((DiagnosticReporterFactory)DiagnosticReporterFactory.INSTANCE, null, (boolean)false, (int)3, null)).build();
        JvmIrCodegenFactory.JvmIrBackendInput conversionResult = codegenFactory.convertToIr(CodegenFactory.IrConversionInput.Companion.fromGenerationStateAndFiles(state, psiFiles.values()));
        List list = CollectionsKt.emptyList();
        IdSignatureComposer idSignatureComposer = conversionResult.getSymbolTable().getSignaturer();
        Intrinsics.checkNotNull((Object)idSignatureComposer);
        return new IrBackendInput.JvmIrBackendInput(state, codegenFactory, conversionResult, list, idSignatureComposer.getMangler(), (KotlinMangler.IrMangler)JvmIrMangler.INSTANCE, null);
    }

    private final IrBackendInput transformToJsIr(TestModule module, ClassicFrontendOutputArtifact inputArtifact) {
        Map<TestFile, KtFile> psiFiles = inputArtifact.component1();
        AnalysisResult analysisResult = inputArtifact.component2();
        Project project = inputArtifact.component3();
        CompilerConfiguration configuration2 = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.getTestServices()).getCompilerConfiguration(module);
        boolean verifySignatures = !module.getDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getSKIP_MANGLE_VERIFICATION());
        List sourceFiles = CollectionsKt.toList((Iterable)psiFiles.values());
        Object object = KlibKt.getIncrementalDataProvider((CompilerConfiguration)configuration2);
        if (object == null || (object = KlibKt.getSerializedDataByPsiFiles((IncrementalDataProvider)object, (List)sourceFiles)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object icData = object;
        Pair pair = IrForKlibKt.generateIrForKlibSerialization((Project)project, (List)sourceFiles, (CompilerConfiguration)configuration2, (AnalysisResult)analysisResult, (Collection)KlibKt.sortDependencies(JsEnvironmentConfigurator.Companion.getAllDependenciesMappingFor(module, this.getTestServices())), (List)icData, (IrFactory)((IrFactory)IrFactoryImpl.INSTANCE), (boolean)verifySignatures, arg_0 -> ClassicFrontend2IrConverter.transformToJsIr$lambda$1(this, arg_0));
        IrModuleFragment moduleFragment = (IrModuleFragment)pair.component1();
        IrPluginContext pluginContext = (IrPluginContext)pair.component2();
        ErrorTolerancePolicy errorTolerancePolicy = (ErrorTolerancePolicy)configuration2.get(JSConfigurationKeys.ERROR_TOLERANCE_POLICY);
        if (errorTolerancePolicy == null) {
            errorTolerancePolicy = ErrorTolerancePolicy.Companion.getDEFAULT();
        }
        ErrorTolerancePolicy errorPolicy = errorTolerancePolicy;
        boolean hasErrors = TopDownAnalyzerFacadeForJSIR.INSTANCE.checkForErrors((Collection)sourceFiles, analysisResult.getBindingContext(), errorPolicy);
        KlibMetadataIncrementalSerializer metadataSerializer = new KlibMetadataIncrementalSerializer(sourceFiles, configuration2, project, analysisResult.getBindingContext(), moduleFragment.getDescriptor(), hasErrors);
        BaseDiagnosticsCollector baseDiagnosticsCollector = DiagnosticReporterFactory.createReporter$default((DiagnosticReporterFactory)DiagnosticReporterFactory.INSTANCE, null, (boolean)false, (int)3, null);
        ReferenceSymbolTable referenceSymbolTable = pluginContext.getSymbolTable();
        Intrinsics.checkNotNull((Object)referenceSymbolTable, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.SymbolTable");
        IdSignatureComposer idSignatureComposer = ((SymbolTable)referenceSymbolTable).getSignaturer();
        Intrinsics.checkNotNull((Object)idSignatureComposer);
        return new IrBackendInput.JsIrBackendInput(moduleFragment, pluginContext, (List<KotlinFileSerializedData>)icData, baseDiagnosticsCollector, hasErrors, idSignatureComposer.getMangler(), (KotlinMangler.IrMangler)JsManglerIr.INSTANCE, null, (KlibSingleFileMetadataSerializer)metadataSerializer);
    }

    private final IrBackendInput transformToWasmIr(TestModule module, ClassicFrontendOutputArtifact inputArtifact) {
        Map<TestFile, KtFile> psiFiles = inputArtifact.component1();
        AnalysisResult analysisResult = inputArtifact.component2();
        Project project = inputArtifact.component3();
        CompilerConfiguration configuration2 = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.getTestServices()).getCompilerConfiguration(module);
        boolean verifySignatures = !module.getDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getSKIP_MANGLE_VERIFICATION());
        List sourceFiles = CollectionsKt.toList((Iterable)psiFiles.values());
        Object object = KlibKt.getIncrementalDataProvider((CompilerConfiguration)configuration2);
        if (object == null || (object = KlibKt.getSerializedDataByPsiFiles((IncrementalDataProvider)object, (List)sourceFiles)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object icData = object;
        Pair pair = IrForKlibKt.generateIrForKlibSerialization((Project)project, (List)sourceFiles, (CompilerConfiguration)configuration2, (AnalysisResult)analysisResult, (Collection)KlibKt.sortDependencies(WasmEnvironmentConfigurator.Companion.getAllDependenciesMappingFor(module, this.getTestServices())), (List)icData, (IrFactory)((IrFactory)IrFactoryImpl.INSTANCE), (boolean)verifySignatures, arg_0 -> ClassicFrontend2IrConverter.transformToWasmIr$lambda$2(this, arg_0));
        IrModuleFragment moduleFragment = (IrModuleFragment)pair.component1();
        IrPluginContext pluginContext = (IrPluginContext)pair.component2();
        ErrorTolerancePolicy errorTolerancePolicy = (ErrorTolerancePolicy)configuration2.get(JSConfigurationKeys.ERROR_TOLERANCE_POLICY);
        if (errorTolerancePolicy == null) {
            errorTolerancePolicy = ErrorTolerancePolicy.Companion.getDEFAULT();
        }
        ErrorTolerancePolicy errorPolicy = errorTolerancePolicy;
        TopDownAnalyzerFacadeForWasm analyzerFacade = TopDownAnalyzerFacadeForWasm.Companion.facadeFor((WasmTarget)configuration2.get(WasmConfigurationKeys.WASM_TARGET));
        boolean hasErrors = analyzerFacade.checkForErrors((Collection)sourceFiles, analysisResult.getBindingContext(), errorPolicy);
        KlibMetadataIncrementalSerializer metadataSerializer = new KlibMetadataIncrementalSerializer(sourceFiles, configuration2, project, analysisResult.getBindingContext(), moduleFragment.getDescriptor(), hasErrors);
        BaseDiagnosticsCollector baseDiagnosticsCollector = DiagnosticReporterFactory.createReporter$default((DiagnosticReporterFactory)DiagnosticReporterFactory.INSTANCE, null, (boolean)false, (int)3, null);
        ReferenceSymbolTable referenceSymbolTable = pluginContext.getSymbolTable();
        Intrinsics.checkNotNull((Object)referenceSymbolTable, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.SymbolTable");
        IdSignatureComposer idSignatureComposer = ((SymbolTable)referenceSymbolTable).getSignaturer();
        Intrinsics.checkNotNull((Object)idSignatureComposer);
        return new IrBackendInput.WasmBackendInput(moduleFragment, pluginContext, (List<KotlinFileSerializedData>)icData, baseDiagnosticsCollector, hasErrors, idSignatureComposer.getMangler(), (KotlinMangler.IrMangler)JsManglerIr.INSTANCE, null, (KlibSingleFileMetadataSerializer)metadataSerializer);
    }

    private static final String transform$lambda$0(TestModule $module) {
        return "Target backend " + (Object)((Object)$module.getTargetBackend()) + " not supported for transformation into IR";
    }

    private static final ModuleDescriptor transformToJsIr$lambda$1(ClassicFrontend2IrConverter this$0, KotlinLibrary it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LibraryProviderKt.getLibraryProvider(this$0.getTestServices()).getDescriptorByCompiledLibrary(it);
    }

    private static final ModuleDescriptor transformToWasmIr$lambda$2(ClassicFrontend2IrConverter this$0, KotlinLibrary it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LibraryProviderKt.getLibraryProvider(this$0.getTestServices()).getDescriptorByCompiledLibrary(it);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TargetBackend.values().length];
            try {
                nArray[TargetBackend.JVM_IR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetBackend.JVM_IR_SERIALIZE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetBackend.JS_IR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetBackend.JS_IR_ES6.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetBackend.WASM.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

