/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CodegenTestUtil;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.codegen.TestUtilsKt;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.backend.BlackBoxCodegenSuppressorKt;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.backend.handlers.JvmBoxRunnerKt;
import org.jetbrains.kotlin.test.clientserver.TestProxy;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.ModulesKt;
import org.jetbrains.kotlin.test.model.SourceFileInfo;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManagerKt;
import org.jetbrains.kotlin.test.services.jvm.JvmBoxMainClassProvider;
import org.jetbrains.kotlin.test.services.jvm.JvmBoxMainClassProviderKt;
import org.jetbrains.kotlin.test.services.sourceProviders.MainFunctionForBlackBoxTestsSourceProvider;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 :2\u00020\u0001:\u0001:B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J8\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J0\u0010\u0019\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J0\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u001cH\u0002J(\u0010!\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\f\u001a\u00020\r2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001f0)H\u0014J,\u0010,\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002J&\u0010.\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u00102\u001a\u0002032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u000e\u00104\u001a\u0004\u0018\u00010\u001f*\u000205H\u0002J\u0018\u00106\u001a\u0006\u0012\u0002\b\u00030\u001b*\u0002072\u0006\u00108\u001a\u00020\u001fH\u0002J\u0012\u00109\u001a\u0004\u0018\u00010\u001c*\u0006\u0012\u0002\b\u00030\u001bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010/\u001a\u00020**\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/JvmBoxRunner;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "boxMethodFound", "", "processAfterAllModules", "", "someAssertionWasFailed", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "callBoxMethodAndCheckResultWithCleanup", "fileInfo", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "classFileFactory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "classLoader", "Ljava/net/URLClassLoader;", "unexpectedBehaviour", "reportProblems", "findClassAndMethodToExecute", "Lkotlin/Pair;", "Ljava/lang/Class;", "Ljava/lang/reflect/Method;", "callBoxMethodAndCheckResult", "runBoxInCurrentProcess", "", "method", "runSeparateJvmInstance", "jdkKind", "Lorg/jetbrains/kotlin/test/TestJdkKind;", "launchSeparateJvmProcess", "Ljava/lang/Process;", "javaExe", "Ljava/io/File;", "classPath", "", "Ljava/net/URL;", "mainClassAndArguments", "invokeBoxInSeparateProcess", "clazz", "extractClassPath", "url", "getUrl", "(Ljava/io/File;)Ljava/net/URL;", "createAndVerifyClassLoader", "Lorg/jetbrains/kotlin/codegen/GeneratedClassLoader;", "getFacadeFqName", "Lorg/jetbrains/kotlin/psi/KtFile;", "getGeneratedClass", "Ljava/lang/ClassLoader;", "className", "getBoxMethodOrNull", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nJvmBoxRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmBoxRunner.kt\norg/jetbrains/kotlin/test/backend/handlers/JvmBoxRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,377:1\n1#2:378\n295#3,2:379\n226#4:381\n226#4:382\n226#4:383\n*S KotlinDebug\n*F\n+ 1 JvmBoxRunner.kt\norg/jetbrains/kotlin/test/backend/handlers/JvmBoxRunner\n*L\n208#1:379,2\n248#1:381\n250#1:382\n306#1:383\n*E\n"})
public class JvmBoxRunner
extends JvmBinaryArtifactHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean boxMethodFound;
    private static final String BOX_IN_SEPARATE_PROCESS_PORT = System.getProperty("kotlin.test.box.in.separate.process.port");
    @NotNull
    private static final String DEFAULT_EXPECTED_RESULT = "OK";
    @NotNull
    private static final String OUTPUT_EXTENSION = "box.txt";

    public JvmBoxRunner(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, 2, null);
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        if (!this.boxMethodFound) {
            this.getAssertions().fail((Function0<String>)((Function0)JvmBoxRunner::processAfterAllModules$lambda$0));
            throw null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.Jvm info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Collection<SourceFileInfo> collection = info.getFileInfos();
        if (collection.isEmpty()) {
            boolean bl = false;
            return;
        }
        Collection<SourceFileInfo> fileInfos = collection;
        boolean reportProblems = !BlackBoxCodegenSuppressorKt.getCodegenSuppressionChecker(this.getTestServices()).failuresInModuleAreIgnored(module);
        GeneratedClassLoader classLoader = this.createAndVerifyClassLoader(module, info.getClassFileFactory(), reportProblems);
        try {
            for (SourceFileInfo fileInfo : fileInfos) {
                if (!MainFunctionForBlackBoxTestsSourceProvider.Companion.fileContainsBoxMethod(fileInfo.getSourceFile())) continue;
                this.boxMethodFound = true;
                this.callBoxMethodAndCheckResultWithCleanup(fileInfo.getInfo(), module, info.getClassFileFactory(), (URLClassLoader)classLoader, false, reportProblems);
                return;
            }
        }
        finally {
            classLoader.dispose();
        }
    }

    private final void callBoxMethodAndCheckResultWithCleanup(JvmFileClassInfo fileInfo, TestModule module, ClassFileFactory classFileFactory, URLClassLoader classLoader, boolean unexpectedBehaviour, boolean reportProblems) {
        try {
            this.callBoxMethodAndCheckResult(fileInfo, module, classFileFactory, classLoader, unexpectedBehaviour);
        }
        catch (Throwable e) {
            if (reportProblems) {
                try {
                    String string = classFileFactory.createText();
                    System.out.println((Object)string);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private final Pair<Class<?>, Method> findClassAndMethodToExecute(JvmFileClassInfo fileInfo, URLClassLoader classLoader, ClassFileFactory classFileFactory) {
        Class<?> clazz;
        String string = fileInfo.getFacadeClassFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String className = string;
        try {
            clazz = this.getGeneratedClass(classLoader, className);
        }
        catch (LinkageError e) {
            throw new AssertionError("Failed to load class '" + className + "':\n" + classFileFactory.createText(), e);
        }
        Class<?> clazz2 = clazz;
        Method method = this.getBoxMethodOrNull(clazz2);
        if (method == null) {
            throw new IllegalStateException("box method not found".toString());
        }
        Method method2 = method;
        return TuplesKt.to(clazz2, (Object)method2);
    }

    private final void callBoxMethodAndCheckResult(JvmFileClassInfo fileInfo, TestModule module, ClassFileFactory classFileFactory, URLClassLoader classLoader, boolean unexpectedBehaviour) {
        String result;
        String string;
        if (BOX_IN_SEPARATE_PROCESS_PORT != null) {
            string = this.invokeBoxInSeparateProcess(module, classFileFactory, classLoader, (Class)this.findClassAndMethodToExecute(fileInfo, classLoader, classFileFactory).getFirst());
        } else {
            TestJdkKind jdkKind;
            TestJdkKind testJdkKind = jdkKind = DirectiveKt.singleOrZeroValue(module.getDirectives(), JvmEnvironmentConfigurationDirectives.INSTANCE.getJDK_KIND());
            boolean bl = testJdkKind != null ? testJdkKind.getRequiresSeparateProcess() : false;
            if (bl || module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getREQUIRES_SEPARATE_PROCESS())) {
                TestJdkKind testJdkKind2 = jdkKind;
                if (testJdkKind2 == null) {
                    testJdkKind2 = TestJdkKind.FULL_JDK;
                }
                string = this.runSeparateJvmInstance(module, testJdkKind2, classLoader, classFileFactory);
            } else {
                string = result = this.runBoxInCurrentProcess(classLoader, (Method)this.findClassAndMethodToExecute(fileInfo, classLoader, classFileFactory).getSecond());
            }
        }
        if (unexpectedBehaviour) {
            TestCase.assertNotSame((Object)DEFAULT_EXPECTED_RESULT, (Object)result);
        } else {
            File originalFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
            File outputFile = FileUtilsKt.withExtension(originalFile, OUTPUT_EXTENSION);
            if (outputFile.exists()) {
                Assertions.assertEqualsToFile$default(this.getAssertions(), outputFile, result, null, 4, null);
            } else {
                Assertions.assertEquals$default(this.getAssertions(), DEFAULT_EXPECTED_RESULT, result, null, 4, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String runBoxInCurrentProcess(URLClassLoader classLoader, Method method) {
        String string;
        ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
        if (savedClassLoader != classLoader) {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        try {
            Object object = method.invoke(null, new Object[0]);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            string = (String)object;
        }
        finally {
            if (savedClassLoader != classLoader) {
                Thread.currentThread().setContextClassLoader(savedClassLoader);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String runSeparateJvmInstance(TestModule module, TestJdkKind jdkKind, URLClassLoader classLoader, ClassFileFactory classFileFactory) {
        String string;
        Object[] $this$firstOrNull$iv;
        File file;
        File file2;
        switch (WhenMappings.$EnumSwitchMapping$0[jdkKind.ordinal()]) {
            case 1: {
                file2 = KtTestUtil.getJdk8Home();
                break;
            }
            case 2: {
                file2 = KtTestUtil.getJdk11Home();
                break;
            }
            case 3: {
                file2 = KtTestUtil.getJdk17Home();
                break;
            }
            case 4: {
                file2 = KtTestUtil.getJdk21Home();
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported JDK kind: " + (Object)((Object)jdkKind)).toString());
            }
        }
        File file3 = file2;
        Intrinsics.checkNotNull((Object)file3);
        File jdkHome = file3;
        File p0 = file = new File(jdkHome, "bin/java.exe");
        boolean bl = false;
        File file4 = p0.exists() ? file : null;
        if (file4 == null) {
            File p02 = p0 = new File(jdkHome, "bin/java");
            boolean bl2 = false;
            file4 = p02.exists() ? p0 : null;
            if (file4 == null) {
                throw new IllegalStateException(("Can't find 'java' executable in " + jdkHome).toString());
            }
        }
        File javaExe = file4;
        List<URL> classPath = this.extractClassPath(module, classLoader, classFileFactory);
        Object object = JvmBoxMainClassProviderKt.getJvmBoxMainClassProvider(this.getTestServices());
        if (object == null || (object = ((JvmBoxMainClassProvider)object).getMainClassNameAndAdditionalArguments(module)) == null) {
            Object v3;
            block18: {
                JvmBoxRunner $this$runSeparateJvmInstance_u24lambda_u244 = this;
                boolean bl3 = false;
                $this$firstOrNull$iv = (String[])module.getFiles();
                boolean $i$f$firstOrNull = false;
                for (Object charset : $this$firstOrNull$iv) {
                    TestFile it = (TestFile)charset;
                    boolean bl4 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"Generated_Box_Main.kt") && it.isAdditional())) continue;
                    v3 = charset;
                    break block18;
                }
                v3 = null;
            }
            TestFile testFile = v3;
            if (testFile == null) {
                throw new IllegalStateException("No file with main function was generated. Please check TODO source provider".toString());
            }
            TestFile mainFile = testFile;
            $this$firstOrNull$iv = new String[]{MainFunctionForBlackBoxTestsSourceProvider.Companion.detectPackage(mainFile), ModulesKt.getNameWithoutExtension(mainFile) + "Kt"};
            String mainFqName = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])$this$firstOrNull$iv), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            object = CollectionsKt.listOf((Object)mainFqName);
        }
        Object mainClassAndArguments = object;
        Process process = this.launchSeparateJvmProcess(javaExe, module, classPath, (List<String>)mainClassAndArguments);
        process.waitFor(3L, TimeUnit.MINUTES);
        try {
            String string2;
            if (process.exitValue() == 0) {
                string2 = DEFAULT_EXPECTED_RESULT;
            } else {
                StringBuilder stringBuilder;
                StringBuilder $this$runSeparateJvmInstance_u24lambda_u247 = stringBuilder = new StringBuilder();
                boolean bl5 = false;
                $this$firstOrNull$iv = new InputStream[]{process.getInputStream(), process.getErrorStream()};
                for (InputStream stream : CollectionsKt.listOfNotNull((Object[])$this$firstOrNull$iv)) {
                    InputStream inputStream = stream;
                    Charset charset = Charsets.UTF_8;
                    Reader reader = new InputStreamReader(inputStream, charset);
                    int n = 8192;
                    (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).lines().forEach(arg_0 -> JvmBoxRunner.runSeparateJvmInstance$lambda$7$lambda$6(arg_0 -> JvmBoxRunner.runSeparateJvmInstance$lambda$7$lambda$5($this$runSeparateJvmInstance_u24lambda_u247, arg_0), arg_0));
                }
                if (((CharSequence)$this$runSeparateJvmInstance_u24lambda_u247).length() == 0) {
                    StringBuilder stringBuilder2 = $this$runSeparateJvmInstance_u24lambda_u247.append("External process completed with error. Check the build log");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
                }
                String string3 = stringBuilder.toString();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            }
            string = string2;
        }
        finally {
            process.getOutputStream().flush();
        }
        return string;
    }

    @NotNull
    protected Process launchSeparateJvmProcess(@NotNull File javaExe, @NotNull TestModule module, @NotNull List<URL> classPath, @NotNull List<String> mainClassAndArguments) {
        String string;
        String string2;
        String string3;
        Object[] objectArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)javaExe, (String)"javaExe");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(classPath, (String)"classPath");
        Intrinsics.checkNotNullParameter(mainClassAndArguments, (String)"mainClassAndArguments");
        Object[] objectArray2 = new String[6];
        objectArray2[0] = javaExe.getAbsolutePath();
        Object[] objectArray3 = objectArray2;
        int n2 = 1;
        boolean condition$iv = module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getATTACH_DEBUGGER());
        boolean $i$f$runIf = false;
        if (condition$iv) {
            n = n2;
            objectArray = objectArray3;
            boolean bl = false;
            string3 = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005";
            objectArray3 = objectArray;
            n2 = n;
            string2 = string3;
        } else {
            string2 = null;
        }
        objectArray3[n2] = string2;
        objectArray2[2] = "-ea";
        Object[] objectArray4 = objectArray2;
        int n3 = 3;
        condition$iv = module.getDirectives().contains(LanguageSettingsDirectives.INSTANCE.getENABLE_JVM_PREVIEW());
        $i$f$runIf = false;
        if (condition$iv) {
            n = n3;
            objectArray = objectArray4;
            boolean bl = false;
            string3 = "--enable-preview";
            objectArray4 = objectArray;
            n3 = n;
            string = string3;
        } else {
            string = null;
        }
        objectArray4[n3] = string;
        objectArray2[4] = "-classpath";
        Iterable iterable = classPath;
        String string4 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"pathSeparator");
        objectArray2[5] = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string4, null, null, (int)0, null, JvmBoxRunner::launchSeparateJvmProcess$lambda$10, (int)30, null);
        List command = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])objectArray2), (Iterable)mainClassAndArguments);
        Process process = new ProcessBuilder(command).start();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"start(...)");
        return process;
    }

    private final String invokeBoxInSeparateProcess(TestModule module, ClassFileFactory classFileFactory, URLClassLoader classLoader, Class<?> clazz) {
        List<URL> classPath = this.extractClassPath(module, classLoader, classFileFactory);
        Integer n = Integer.valueOf(BOX_IN_SEPARATE_PROCESS_PORT);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"valueOf(...)");
        int n2 = ((Number)n).intValue();
        String string = clazz.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
        TestProxy proxy = new TestProxy(n2, string, classPath);
        return proxy.runTest();
    }

    private final List<URL> extractClassPath(TestModule module, URLClassLoader classLoader, ClassFileFactory classFileFactory) {
        List list;
        List $this$extractClassPath_u24lambda_u2411 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$extractClassPath_u24lambda_u2411.addAll((Collection)TestUtilsKt.extractUrls(classLoader));
        if (classLoader instanceof GeneratedClassLoader) {
            URL javaPath;
            File file = CompiledClassesManagerKt.getCompiledClassesManager(this.getTestServices()).getCompiledJavaDirForModule(module);
            URL uRL = javaPath = file != null ? this.getUrl(file) : null;
            if (javaPath != null) {
                $this$extractClassPath_u24lambda_u2411.add(0, javaPath);
            }
            $this$extractClassPath_u24lambda_u2411.add(0, this.getUrl(CompiledClassesManagerKt.getCompiledClassesManager(this.getTestServices()).getCompiledKotlinDirForModule(module, classFileFactory)));
        }
        return CollectionsKt.build((List)list);
    }

    private final URL getUrl(File $this$url) {
        URL uRL = $this$url.toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    private final GeneratedClassLoader createAndVerifyClassLoader(TestModule module, ClassFileFactory classFileFactory, boolean reportProblems) {
        GeneratedClassLoader classLoader = JvmBoxRunnerKt.generatedTestClassLoader(this.getTestServices(), module, classFileFactory);
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getREQUIRES_SEPARATE_PROCESS())) {
            boolean verificationSucceeded;
            TestJdkKind testJdkKind = DirectiveKt.singleOrZeroValue(module.getDirectives(), JvmEnvironmentConfigurationDirectives.INSTANCE.getJDK_KIND());
            if (!(testJdkKind != null ? testJdkKind.getRequiresSeparateProcess() : false) && !(verificationSucceeded = CodegenTestUtil.verifyAllFilesWithAsm(classFileFactory, (ClassLoader)classLoader, reportProblems))) {
                this.getAssertions().fail((Function0<String>)((Function0)JvmBoxRunner::createAndVerifyClassLoader$lambda$12));
                throw null;
            }
        }
        return classLoader;
    }

    private final String getFacadeFqName(KtFile $this$getFacadeFqName) {
        String string;
        boolean condition$iv = !((Collection)CodegenUtil.getMemberDeclarationsToGenerate((KtFile)$this$getFacadeFqName)).isEmpty();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            string = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)$this$getFacadeFqName).getFacadeClassFqName().asString();
        } else {
            string = null;
        }
        return string;
    }

    private final Class<?> getGeneratedClass(ClassLoader $this$getGeneratedClass, String className) {
        try {
            Class<?> clazz = $this$getGeneratedClass.loadClass(className);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(...)");
            return clazz;
        }
        catch (ClassNotFoundException e) {
            this.getAssertions().fail((Function0<String>)((Function0)() -> JvmBoxRunner.getGeneratedClass$lambda$14(className)));
            throw null;
        }
    }

    private final Method getBoxMethodOrNull(Class<?> $this$getBoxMethodOrNull) {
        Method method;
        try {
            method = $this$getBoxMethodOrNull.getMethod("box", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return method;
    }

    private static final String processAfterAllModules$lambda$0() {
        return "Can't find box methods";
    }

    private static final Unit runSeparateJvmInstance$lambda$7$lambda$5(StringBuilder $this_buildString, String it) {
        StringBuilder stringBuilder = $this_buildString.append(it);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        return Unit.INSTANCE;
    }

    private static final void runSeparateJvmInstance$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final CharSequence launchSeparateJvmProcess$lambda$10(URL it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = new File(it.toURI()).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    private static final String createAndVerifyClassLoader$lambda$12() {
        return "Verification failed: see exceptions above";
    }

    private static final String getGeneratedClass$lambda$14(String $className) {
        return "No class file was generated for: " + $className;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/JvmBoxRunner$Companion;", "", "<init>", "()V", "BOX_IN_SEPARATE_PROCESS_PORT", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "DEFAULT_EXPECTED_RESULT", "OUTPUT_EXTENSION", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TestJdkKind.values().length];
            try {
                nArray[TestJdkKind.FULL_JDK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.FULL_JDK_11.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.FULL_JDK_17.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.FULL_JDK_21.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

