/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.jvm;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFileCollection;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.output.OutputUtilsKt;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.test.model.ArtifactKinds;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\n2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/test/services/jvm/CompiledClassesManager;", "Lorg/jetbrains/kotlin/test/services/TestService;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "compiledKotlinCache", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Ljava/io/File;", "compiledJavaCache", "specifiedFrontendKind", "Lorg/jetbrains/kotlin/test/model/FrontendKind;", "getSpecifiedFrontendKind", "()Lorg/jetbrains/kotlin/test/model/FrontendKind;", "setSpecifiedFrontendKind", "(Lorg/jetbrains/kotlin/test/model/FrontendKind;)V", "getCompiledKotlinDirForModule", "module", "classFileFactory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "getCompiledJavaDirForModule", "getOrCreateCompiledJavaDirForModule", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nCompiledClassesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompiledClassesManager.kt\norg/jetbrains/kotlin/test/services/jvm/CompiledClassesManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,59:1\n381#2,7:60\n381#2,7:67\n*S KotlinDebug\n*F\n+ 1 CompiledClassesManager.kt\norg/jetbrains/kotlin/test/services/jvm/CompiledClassesManager\n*L\n25#1:60,7\n53#1:67,7\n*E\n"})
public final class CompiledClassesManager
implements TestService {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final Map<TestModule, File> compiledKotlinCache;
    @NotNull
    private final Map<TestModule, File> compiledJavaCache;
    @NotNull
    private FrontendKind<?> specifiedFrontendKind;

    public CompiledClassesManager(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
        this.compiledKotlinCache = new LinkedHashMap();
        this.compiledJavaCache = new LinkedHashMap();
        this.specifiedFrontendKind = FrontendKind.NoFrontend.INSTANCE;
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    @NotNull
    public final FrontendKind<?> getSpecifiedFrontendKind() {
        return this.specifiedFrontendKind;
    }

    public final void setSpecifiedFrontendKind(@NotNull FrontendKind<?> frontendKind) {
        Intrinsics.checkNotNullParameter(frontendKind, (String)"<set-?>");
        this.specifiedFrontendKind = frontendKind;
    }

    @NotNull
    public final File getCompiledKotlinDirForModule(@NotNull TestModule module, @Nullable ClassFileFactory classFileFactory) {
        File file;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map<TestModule, File> $this$getOrPut$iv = this.compiledKotlinCache;
        boolean $i$f$getOrPut = false;
        File value$iv = $this$getOrPut$iv.get(module);
        if (value$iv == null) {
            boolean bl = false;
            File outputDir = TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.testServices, "module_" + module.getName() + "_kotlin-classes");
            ClassFileFactory classFileFactory2 = classFileFactory;
            if (classFileFactory2 == null) {
                if (Intrinsics.areEqual(module.getBinaryKind(), (Object)ArtifactKinds.JvmFromK1AndK2.INSTANCE)) {
                    if (!(Intrinsics.areEqual(this.specifiedFrontendKind, (Object)FrontendKinds.FIR.INSTANCE) || Intrinsics.areEqual(this.specifiedFrontendKind, (Object)FrontendKinds.ClassicFrontend.INSTANCE))) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    BinaryArtifacts.JvmFromK1AndK2 k1AndK2Artifact = (BinaryArtifacts.JvmFromK1AndK2)DependencyProviderKt.getDependencyProvider(this.testServices).getArtifact(module, ArtifactKinds.JvmFromK1AndK2.INSTANCE);
                    classFileFactory2 = Intrinsics.areEqual(this.specifiedFrontendKind, (Object)FrontendKinds.FIR.INSTANCE) ? k1AndK2Artifact.getFromK2().getClassFileFactory() : k1AndK2Artifact.getFromK1().getClassFileFactory();
                } else {
                    classFileFactory2 = ((BinaryArtifacts.Jvm)DependencyProviderKt.getDependencyProvider(this.testServices).getArtifact(module, ArtifactKinds.Jvm.INSTANCE)).getClassFileFactory();
                }
            }
            ClassFileFactory classFileFactory3 = classFileFactory2;
            List list = classFileFactory3.getCurrentOutput();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCurrentOutput(...)");
            SimpleOutputFileCollection outputFileCollection = new SimpleOutputFileCollection(list);
            Object object = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.testServices).getCompilerConfiguration(module).getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getNotNull(...)");
            MessageCollector messageCollector2 = (MessageCollector)object;
            OutputUtilsKt.writeAll((OutputFileCollection)((OutputFileCollection)outputFileCollection), (File)outputDir, (MessageCollector)messageCollector2, (boolean)false);
            File answer$iv = outputDir;
            $this$getOrPut$iv.put(module, answer$iv);
            file = answer$iv;
        } else {
            file = value$iv;
        }
        return file;
    }

    public static /* synthetic */ File getCompiledKotlinDirForModule$default(CompiledClassesManager compiledClassesManager, TestModule testModule, ClassFileFactory classFileFactory, int n, Object object) {
        if ((n & 2) != 0) {
            classFileFactory = null;
        }
        return compiledClassesManager.getCompiledKotlinDirForModule(testModule, classFileFactory);
    }

    @Nullable
    public final File getCompiledJavaDirForModule(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.compiledJavaCache.get(module);
    }

    @NotNull
    public final File getOrCreateCompiledJavaDirForModule(@NotNull TestModule module) {
        File file;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map<TestModule, File> $this$getOrPut$iv = this.compiledJavaCache;
        boolean $i$f$getOrPut = false;
        File value$iv = $this$getOrPut$iv.get(module);
        if (value$iv == null) {
            boolean bl = false;
            File answer$iv = TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.testServices, "module_" + module.getName() + "_java-classes");
            $this$getOrPut$iv.put(module, answer$iv);
            file = answer$iv;
        } else {
            file = value$iv;
        }
        return file;
    }
}

