/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.configuration;

import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.TranslationMode;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.ErrorTolerancePolicy;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.resolve.TargetEnvironment;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.KotlinJavaScriptLibraryParts;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.directives.ConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.JsEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DirectiveToConfigurationKeyExtractor;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.KotlinStandardLibrariesPathProvider;
import org.jetbrains.kotlin.test.services.KotlinStandardLibrariesPathProviderKt;
import org.jetbrains.kotlin.test.services.RuntimeClasspathProvider;
import org.jetbrains.kotlin.test.services.RuntimeClasspathProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManager;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.KlibBasedEnvironmentConfiguratorUtils;
import org.jetbrains.kotlin.test.util.StringUtilsKt;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u000b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/JsEnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "provideAdditionalAnalysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "directives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "provideConfigurationKeys", "", "Lorg/jetbrains/kotlin/test/services/DirectiveToConfigurationKeyExtractor;", "configureCompilerConfiguration", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nJsEnvironmentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/JsEnvironmentConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1557#2:254\n1628#2,3:255\n1557#2:258\n1628#2,3:259\n1557#2:262\n1628#2,3:263\n1557#2:266\n1628#2,3:267\n1368#2:270\n1454#2,2:271\n1557#2:273\n1628#2,3:274\n1456#2,3:277\n*S KotlinDebug\n*F\n+ 1 JsEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/JsEnvironmentConfigurator\n*L\n205#1:254\n205#1:255,3\n206#1:258\n206#1:259,3\n207#1:262\n207#1:263,3\n234#1:266\n234#1:267,3\n70#1:270\n70#1:271,2\n71#1:273\n71#1:274,3\n70#1:277,3\n*E\n"})
public final class JsEnvironmentConfigurator
extends EnvironmentConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TEST_DATA_DIR_PATH = "js/js.translator/testData";
    @NotNull
    public static final String OLD_MODULE_SUFFIX = "_old";
    @NotNull
    private static final Map<TranslationMode, String> outputDirByMode;
    @NotNull
    private static final String MINIFICATION_OUTPUT_DIR_NAME = "minOutputDir";
    @NotNull
    private static final Lazy<List<JsModuleDescriptor<KotlinJavaScriptLibraryParts>>> METADATA_CACHE$delegate;

    public JsEnvironmentConfigurator(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)JsEnvironmentConfigurationDirectives.INSTANCE);
    }

    @Override
    @NotNull
    public Map<AnalysisFlag<?>, Object> provideAdditionalAnalysisFlags(@NotNull RegisteredDirectives directives, @NotNull LanguageVersion languageVersion) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)directives, (String)"directives");
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        Map it = map = MapsKt.toMutableMap(super.provideAdditionalAnalysisFlags(directives, languageVersion));
        boolean bl = false;
        it.put(AnalysisFlags.getAllowFullyQualifiedNameInKClass(), false);
        return map;
    }

    @Override
    public void provideConfigurationKeys(@NotNull DirectiveToConfigurationKeyExtractor $this$provideConfigurationKeys) {
        Intrinsics.checkNotNullParameter((Object)$this$provideConfigurationKeys, (String)"<this>");
        SimpleDirective simpleDirective = JsEnvironmentConfigurationDirectives.INSTANCE.getPROPERTY_LAZY_INITIALIZATION();
        CompilerConfigurationKey compilerConfigurationKey = JSConfigurationKeys.PROPERTY_LAZY_INITIALIZATION;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey, (String)"PROPERTY_LAZY_INITIALIZATION");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective, compilerConfigurationKey, false, 4, null);
        SimpleDirective simpleDirective2 = JsEnvironmentConfigurationDirectives.INSTANCE.getGENERATE_INLINE_ANONYMOUS_FUNCTIONS();
        CompilerConfigurationKey compilerConfigurationKey2 = JSConfigurationKeys.GENERATE_INLINE_ANONYMOUS_FUNCTIONS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey2, (String)"GENERATE_INLINE_ANONYMOUS_FUNCTIONS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective2, compilerConfigurationKey2, false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureCompilerConfiguration(@NotNull CompilerConfiguration configuration2, @NotNull TestModule module) {
        void $this$mapTo$iv$iv;
        List list;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        Collection collection;
        void $this$mapTo$iv$iv4;
        ModuleKind moduleKind;
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!JsPlatforms.INSTANCE.getAllJsPlatforms().contains(module.getTargetPlatform())) {
            return;
        }
        RegisteredDirectives registeredDirectives = module.getDirectives();
        List<ModuleKind> moduleKinds = registeredDirectives.get(JsEnvironmentConfigurationDirectives.INSTANCE.getMODULE_KIND());
        switch (moduleKinds.size()) {
            case 0: {
                moduleKind = (ModuleKind)CollectionsKt.singleOrNull(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().get(JsEnvironmentConfigurationDirectives.INSTANCE.getMODULE_KIND()));
                if (moduleKind != null) break;
                if (registeredDirectives.contains(JsEnvironmentConfigurationDirectives.INSTANCE.getES_MODULES())) {
                    moduleKind = ModuleKind.ES;
                    break;
                }
                moduleKind = ModuleKind.PLAIN;
                break;
            }
            case 1: {
                moduleKind = (ModuleKind)CollectionsKt.single(moduleKinds);
                break;
            }
            default: {
                throw new IllegalStateException(("Too many module kinds passed " + StringUtilsKt.joinToArrayString((Iterable)moduleKinds)).toString());
            }
        }
        ModuleKind moduleKind2 = moduleKind;
        configuration2.put(JSConfigurationKeys.MODULE_KIND, (Object)moduleKind2);
        boolean noInline = registeredDirectives.contains(JsEnvironmentConfigurationDirectives.INSTANCE.getNO_INLINE());
        configuration2.put(CommonConfigurationKeys.DISABLE_INLINE, (Object)noInline);
        Iterable $this$map$iv = module.getRegularDependencies();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            void it;
            DependencyDescription dependencyDescription = (DependencyDescription)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(org.jetbrains.kotlin.test.services.configuration.JsEnvironmentConfigurator$Companion.getJsModuleArtifactPath$default(Companion, this.getTestServices(), it.getModuleName(), null, 4, null) + ".meta.js");
        }
        List dependencies = (List)destination$iv$iv;
        Iterable $this$map$iv2 = this.allTransitiveDependencies(module);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            DependencyDescription bl = (DependencyDescription)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(org.jetbrains.kotlin.test.services.configuration.JsEnvironmentConfigurator$Companion.getJsModuleArtifactPath$default(Companion, this.getTestServices(), it.getModuleName(), null, 4, null) + ".meta.js");
        }
        List allDependencies = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = module.getFriendDependencies();
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            DependencyDescription bl2 = (DependencyDescription)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(org.jetbrains.kotlin.test.services.configuration.JsEnvironmentConfigurator$Companion.getJsModuleArtifactPath$default(Companion, this.getTestServices(), it.getModuleName(), null, 4, null) + ".meta.js");
        }
        List friends = (List)destination$iv$iv3;
        TargetBackend targetBackend = module.getTargetBackend();
        switch (targetBackend == null ? -1 : WhenMappings.$EnumSwitchMapping$0[targetBackend.ordinal()]) {
            case -1: {
                List list2 = JsConfig.JS_STDLIB;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"JS_STDLIB");
                Collection collection2 = list2;
                List list3 = JsConfig.JS_KOTLIN_TEST;
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"JS_KOTLIN_TEST");
                list = CollectionsKt.plus((Collection)collection2, (Iterable)list3);
                break;
            }
            case 1: 
            case 2: {
                list = CollectionsKt.plus((Collection)dependencies, (Iterable)friends);
                break;
            }
            case 3: {
                List list4 = JsConfig.JS_STDLIB;
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"JS_STDLIB");
                Collection collection3 = list4;
                List list5 = JsConfig.JS_KOTLIN_TEST;
                Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"JS_KOTLIN_TEST");
                list = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection3, (Iterable)list5), (Iterable)dependencies), (Iterable)friends);
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported target backend: " + (Object)((Object)module.getTargetBackend())).toString());
            }
        }
        List libraries = list;
        configuration2.put(JSConfigurationKeys.LIBRARIES, (Object)libraries);
        configuration2.put(JSConfigurationKeys.TRANSITIVE_LIBRARIES, (Object)allDependencies);
        configuration2.put(JSConfigurationKeys.FRIEND_PATHS, (Object)friends);
        configuration2.put(CommonConfigurationKeys.MODULE_NAME, (Object)StringsKt.removeSuffix((String)module.getName(), (CharSequence)OLD_MODULE_SUFFIX));
        configuration2.put(JSConfigurationKeys.TARGET, (Object)EcmaVersion.es5);
        ErrorTolerancePolicy errorTolerancePolicy = (ErrorTolerancePolicy)CollectionsKt.singleOrNull(registeredDirectives.get(JsEnvironmentConfigurationDirectives.INSTANCE.getERROR_POLICY()));
        if (errorTolerancePolicy == null) {
            errorTolerancePolicy = ErrorTolerancePolicy.Companion.getDEFAULT();
        }
        ErrorTolerancePolicy errorIgnorancePolicy = errorTolerancePolicy;
        configuration2.put(JSConfigurationKeys.ERROR_TOLERANCE_POLICY, (Object)errorIgnorancePolicy);
        if (errorIgnorancePolicy.getAllowErrors()) {
            configuration2.put(JSConfigurationKeys.DEVELOPER_MODE, (Object)true);
        }
        if (errorIgnorancePolicy != ErrorTolerancePolicy.Companion.getDEFAULT()) {
            configuration2.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, (Object)MessageCollector.Companion.getNONE());
        }
        boolean multiModule = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules().size() > 1;
        configuration2.put(JSConfigurationKeys.META_INFO, (Object)multiModule);
        Iterable $this$map$iv4 = module.getFiles();
        boolean $i$f$map4 = false;
        Iterable item$iv$iv = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            TestFile testFile = (TestFile)item$iv$iv2;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(it.getOriginalFile().getParent());
        }
        List sourceDirs = CollectionsKt.distinct((Iterable)((List)destination$iv$iv4));
        configuration2.put(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, (Object)sourceDirs);
        configuration2.put(JSConfigurationKeys.SOURCE_MAP, (Object)true);
        SourceMapSourceEmbedding sourceMapSourceEmbedding = (SourceMapSourceEmbedding)CollectionsKt.singleOrNull(registeredDirectives.get(JsEnvironmentConfigurationDirectives.INSTANCE.getSOURCE_MAP_EMBED_SOURCES()));
        if (sourceMapSourceEmbedding == null) {
            sourceMapSourceEmbedding = SourceMapSourceEmbedding.NEVER;
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding2 = sourceMapSourceEmbedding;
        configuration2.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, (Object)sourceMapSourceEmbedding2);
        configuration2.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, (Object)registeredDirectives.contains(JsEnvironmentConfigurationDirectives.INSTANCE.getTYPED_ARRAYS()));
        configuration2.put(JSConfigurationKeys.GENERATE_POLYFILLS, (Object)true);
        configuration2.put(JSConfigurationKeys.GENERATE_REGION_COMMENTS, (Object)true);
        String string = new File(".").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        configuration2.put(JSConfigurationKeys.FILE_PATHS_PREFIX_MAP, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)StringsKt.removeSuffix((String)string, (CharSequence)"."), (Object)"")));
    }

    /*
     * WARNING - void declaration
     */
    private static final List METADATA_CACHE_delegate$lambda$7() {
        void var3_3;
        void $this$flatMapTo$iv$iv;
        List list = JsConfig.JS_STDLIB;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"JS_STDLIB");
        Collection collection = list;
        List list2 = JsConfig.JS_KOTLIN_TEST;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"JS_KOTLIN_TEST");
        Iterable $this$flatMap$iv = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            String path = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)path);
            Iterable $this$map$iv = KotlinJavascriptMetadataUtils.loadMetadata((String)path);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void metadata;
                KotlinJavascriptMetadata kotlinJavascriptMetadata = (KotlinJavascriptMetadata)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                KotlinJavaScriptLibraryParts parts = KotlinJavascriptSerializationUtil.readModuleAsProto((byte[])metadata.getBody(), (JsMetadataVersion)metadata.getVersion());
                collection2.add(new JsModuleDescriptor(metadata.getModuleName(), parts.getKind(), parts.getImportedModules(), (Object)parts));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)var3_3;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TranslationMode.FULL_DEV, (Object)"out"), TuplesKt.to((Object)TranslationMode.FULL_PROD_MINIMIZED_NAMES, (Object)"outMin"), TuplesKt.to((Object)TranslationMode.PER_MODULE_DEV, (Object)"outPm"), TuplesKt.to((Object)TranslationMode.PER_MODULE_PROD_MINIMIZED_NAMES, (Object)"outPmMin"), TuplesKt.to((Object)TranslationMode.PER_FILE_DEV, (Object)"outPf"), TuplesKt.to((Object)TranslationMode.PER_FILE_PROD_MINIMIZED_NAMES, (Object)"outPfMin")};
        outputDirByMode = MapsKt.mapOf((Pair[])pairArray);
        METADATA_CACHE$delegate = LazyKt.lazy(JsEnvironmentConfigurator::METADATA_CACHE_delegate$lambda$7);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u00015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\tJ \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\tJ\u0016\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\tJ\u0018\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\tJ\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010$\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020 J \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010.\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010/\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u00101\u001a\u0002022\u0006\u0010\u001f\u001a\u00020 J\n\u00103\u001a\u00020\"*\u00020 J\u000e\u00104\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R'\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/JsEnvironmentConfigurator$Companion;", "Lorg/jetbrains/kotlin/test/services/configuration/KlibBasedEnvironmentConfiguratorUtils;", "<init>", "()V", "TEST_DATA_DIR_PATH", "", "OLD_MODULE_SUFFIX", "outputDirByMode", "", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/TranslationMode;", "MINIFICATION_OUTPUT_DIR_NAME", "METADATA_CACHE", "", "Lorg/jetbrains/kotlin/serialization/js/JsModuleDescriptor;", "Lorg/jetbrains/kotlin/serialization/js/KotlinJavaScriptLibraryParts;", "getMETADATA_CACHE", "()Ljava/util/List;", "METADATA_CACHE$delegate", "Lkotlin/Lazy;", "getJsModuleArtifactPath", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "moduleName", "translationMode", "getRecompiledJsModuleArtifactPath", "getJsModuleArtifactName", "getJsArtifactsOutputDir", "Ljava/io/File;", "getJsArtifactsRecompiledOutputDir", "getMinificationJsArtifactsOutputDir", "getPrefixPostfixFile", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "prefix", "", "getPrefixFile", "getPostfixFile", "createJsConfig", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "compilerEnvironment", "Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "getMainModule", "isMainModule", "getMainModuleName", "getRuntimePathsForModule", "getMainCallParametersForModule", "Lorg/jetbrains/kotlin/js/facade/MainCallParameters;", "hasFilesToRecompile", "incrementalEnabled", "ExceptionThrowingReporter", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nJsEnvironmentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/JsEnvironmentConfigurator$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1#2:254\n669#3,11:255\n1368#3:266\n1454#3,5:267\n1628#3,3:272\n1755#3,3:275\n1755#3,3:278\n*S KotlinDebug\n*F\n+ 1 JsEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/JsEnvironmentConfigurator$Companion\n*L\n126#1:255,11\n150#1:266\n150#1:267,5\n151#1:272,3\n166#1:275,3\n171#1:278,3\n*E\n"})
    public static final class Companion
    implements KlibBasedEnvironmentConfiguratorUtils {
        private Companion() {
        }

        private final List<JsModuleDescriptor<KotlinJavaScriptLibraryParts>> getMETADATA_CACHE() {
            Lazy lazy = METADATA_CACHE$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public final String getJsModuleArtifactPath(@NotNull TestServices testServices, @NotNull String moduleName, @NotNull TranslationMode translationMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)translationMode, (String)"translationMode");
            return this.getJsArtifactsOutputDir(testServices, translationMode).getAbsolutePath() + File.separator + this.getJsModuleArtifactName(testServices, moduleName);
        }

        public static /* synthetic */ String getJsModuleArtifactPath$default(Companion companion, TestServices testServices, String string, TranslationMode translationMode, int n, Object object) {
            if ((n & 4) != 0) {
                translationMode = TranslationMode.FULL_DEV;
            }
            return companion.getJsModuleArtifactPath(testServices, string, translationMode);
        }

        @NotNull
        public final String getRecompiledJsModuleArtifactPath(@NotNull TestServices testServices, @NotNull String moduleName, @NotNull TranslationMode translationMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)translationMode, (String)"translationMode");
            return this.getJsArtifactsRecompiledOutputDir(testServices, translationMode).getAbsolutePath() + File.separator + this.getJsModuleArtifactName(testServices, moduleName);
        }

        public static /* synthetic */ String getRecompiledJsModuleArtifactPath$default(Companion companion, TestServices testServices, String string, TranslationMode translationMode, int n, Object object) {
            if ((n & 4) != 0) {
                translationMode = TranslationMode.FULL_DEV;
            }
            return companion.getRecompiledJsModuleArtifactPath(testServices, string, translationMode);
        }

        @NotNull
        public final String getJsModuleArtifactName(@NotNull TestServices testServices, @NotNull String moduleName) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            return this.getKlibArtifactSimpleName(testServices, moduleName) + "_v5";
        }

        @NotNull
        public final File getJsArtifactsOutputDir(@NotNull TestServices testServices, @NotNull TranslationMode translationMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)translationMode, (String)"translationMode");
            TemporaryDirectoryManager temporaryDirectoryManager = TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(testServices);
            Object v = outputDirByMode.get(translationMode);
            Intrinsics.checkNotNull(v);
            return temporaryDirectoryManager.getOrCreateTempDirectory((String)v);
        }

        public static /* synthetic */ File getJsArtifactsOutputDir$default(Companion companion, TestServices testServices, TranslationMode translationMode, int n, Object object) {
            if ((n & 2) != 0) {
                translationMode = TranslationMode.FULL_DEV;
            }
            return companion.getJsArtifactsOutputDir(testServices, translationMode);
        }

        @NotNull
        public final File getJsArtifactsRecompiledOutputDir(@NotNull TestServices testServices, @NotNull TranslationMode translationMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)translationMode, (String)"translationMode");
            TemporaryDirectoryManager temporaryDirectoryManager = TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(testServices);
            StringBuilder stringBuilder = new StringBuilder();
            Object v = outputDirByMode.get(translationMode);
            Intrinsics.checkNotNull(v);
            return temporaryDirectoryManager.getOrCreateTempDirectory(stringBuilder.append((String)v).append("-recompiled").toString());
        }

        public static /* synthetic */ File getJsArtifactsRecompiledOutputDir$default(Companion companion, TestServices testServices, TranslationMode translationMode, int n, Object object) {
            if ((n & 2) != 0) {
                translationMode = TranslationMode.FULL_DEV;
            }
            return companion.getJsArtifactsRecompiledOutputDir(testServices, translationMode);
        }

        @NotNull
        public final File getMinificationJsArtifactsOutputDir(@NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            return TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(testServices).getOrCreateTempDirectory(JsEnvironmentConfigurator.MINIFICATION_OUTPUT_DIR_NAME);
        }

        private final File getPrefixPostfixFile(TestModule module, boolean prefix) {
            File file;
            String suffix = prefix ? ".prefix" : ".postfix";
            File originalFile = ((TestFile)CollectionsKt.first(module.getFiles())).getOriginalFile();
            File file2 = originalFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
            File it = file = FilesKt.resolve((File)file2, (String)(originalFile.getName() + suffix));
            boolean bl = false;
            return it.exists() ? file : null;
        }

        @Nullable
        public final File getPrefixFile(@NotNull TestModule module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return this.getPrefixPostfixFile(module, true);
        }

        @Nullable
        public final File getPostfixFile(@NotNull TestModule module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return this.getPrefixPostfixFile(module, false);
        }

        @NotNull
        public final JsConfig createJsConfig(@NotNull Project project, @NotNull CompilerConfiguration configuration2, @NotNull TargetEnvironment compilerEnvironment) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)compilerEnvironment, (String)"compilerEnvironment");
            List<JsModuleDescriptor<KotlinJavaScriptLibraryParts>> list = this.getMETADATA_CACHE();
            List list2 = JsConfig.JS_STDLIB;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"JS_STDLIB");
            Collection collection = list2;
            List list3 = JsConfig.JS_KOTLIN_TEST;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"JS_KOTLIN_TEST");
            return new JsConfig(project, configuration2, compilerEnvironment, list, CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)list3)));
        }

        public static /* synthetic */ JsConfig createJsConfig$default(Companion companion, Project project, CompilerConfiguration compilerConfiguration, TargetEnvironment targetEnvironment, int n, Object object) {
            if ((n & 4) != 0) {
                targetEnvironment = (TargetEnvironment)CompilerEnvironment.INSTANCE;
            }
            return companion.createJsConfig(project, compilerConfiguration, targetEnvironment);
        }

        @NotNull
        public final TestModule getMainModule(@NotNull TestServices testServices) {
            TestModule testModule;
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            List<TestModule> modules = TestModuleStructureKt.getModuleStructure(testServices).getModules();
            boolean inferMainModule = TestModuleStructureKt.getModuleStructure(testServices).getAllDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getINFER_MAIN_MODULE());
            if (inferMainModule) {
                testModule = (TestModule)CollectionsKt.last(modules);
            } else {
                Object v1;
                block5: {
                    Iterable $this$singleOrNull$iv = modules;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        TestModule it = (TestModule)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"main")) continue;
                        if (found$iv) {
                            v1 = null;
                            break block5;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                if ((testModule = (TestModule)v1) == null) {
                    testModule = (TestModule)CollectionsKt.last(modules);
                }
            }
            return testModule;
        }

        public final boolean isMainModule(@NotNull TestModule module, @NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            return Intrinsics.areEqual((Object)module, (Object)this.getMainModule(testServices));
        }

        @NotNull
        public final String getMainModuleName(@NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            return this.getMainModule(testServices).getName();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getRuntimePathsForModule(@NotNull TestModule module, @NotNull TestServices testServices) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            List result = new ArrayList();
            boolean needsFullIrRuntime = module.getDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getKJS_WITH_FULL_RUNTIME()) || module.getDirectives().contains(ConfigurationDirectives.INSTANCE.getWITH_STDLIB());
            KotlinStandardLibrariesPathProvider pathProvider = KotlinStandardLibrariesPathProviderKt.getStandardLibrariesPathProvider(testServices);
            if (needsFullIrRuntime) {
                ((Collection)result).add(pathProvider.fullJsStdlib().getAbsolutePath());
                ((Collection)result).add(pathProvider.kotlinTestJsKLib().getAbsolutePath());
            } else {
                ((Collection)result).add(pathProvider.defaultJsStdlib().getAbsolutePath());
            }
            Iterable $this$flatMap$iv = RuntimeClasspathProviderKt.getRuntimeClasspathProviders(testServices);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                RuntimeClasspathProvider it = (RuntimeClasspathProvider)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.runtimeClassPaths(module);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List runtimeClasspaths = (List)destination$iv$iv;
            Iterable $this$mapTo$iv = runtimeClasspaths;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                File $i$f$flatMapTo2 = (File)item$iv;
                Collection collection = result;
                boolean bl = false;
                collection.add(it.getAbsolutePath());
            }
            return result;
        }

        @NotNull
        public final MainCallParameters getMainCallParametersForModule(@NotNull TestModule module) {
            MainCallParameters mainCallParameters;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            if (module.getDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getCALL_MAIN())) {
                MainCallParameters mainCallParameters2 = MainCallParameters.mainWithArguments((List)CollectionsKt.emptyList());
                mainCallParameters = mainCallParameters2;
                Intrinsics.checkNotNullExpressionValue((Object)mainCallParameters2, (String)"mainWithArguments(...)");
            } else if (module.getDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getMAIN_ARGS())) {
                MainCallParameters mainCallParameters3 = MainCallParameters.mainWithArguments((List)((List)CollectionsKt.single(module.getDirectives().get(JsEnvironmentConfigurationDirectives.INSTANCE.getMAIN_ARGS()))));
                Intrinsics.checkNotNull((Object)mainCallParameters3);
                mainCallParameters = mainCallParameters3;
            } else {
                MainCallParameters mainCallParameters4 = MainCallParameters.noCall();
                mainCallParameters = mainCallParameters4;
                Intrinsics.checkNotNullExpressionValue((Object)mainCallParameters4, (String)"noCall(...)");
            }
            return mainCallParameters;
        }

        public final boolean hasFilesToRecompile(@NotNull TestModule $this$hasFilesToRecompile) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$hasFilesToRecompile, (String)"<this>");
                Iterable $this$any$iv = $this$hasFilesToRecompile.getFiles();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TestFile it = (TestFile)element$iv;
                        boolean bl2 = false;
                        if (!it.getDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getRECOMPILE())) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean incrementalEnabled(@NotNull TestServices testServices) {
            TestModule it;
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            if (TestModuleStructureKt.getModuleStructure(testServices).getAllDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getSKIP_IR_INCREMENTAL_CHECKS())) return false;
            Iterable $this$any$iv = TestModuleStructureKt.getModuleStructure(testServices).getModules();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (TestModule)element$iv;
                boolean bl = false;
            } while (!Companion.hasFilesToRecompile(it));
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/JsEnvironmentConfigurator$Companion$ExceptionThrowingReporter;", "Lorg/jetbrains/kotlin/js/config/JsConfig$Reporter;", "<init>", "()V", "error", "", "message", "", "tests-common-new_test"})
        public static final class ExceptionThrowingReporter
        extends JsConfig.Reporter {
            @NotNull
            public static final ExceptionThrowingReporter INSTANCE = new ExceptionThrowingReporter();

            private ExceptionThrowingReporter() {
            }

            public void error(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                throw new AssertionError((Object)("Error message reported: " + message));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TargetBackend.values().length];
            try {
                nArray[TargetBackend.JS_IR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetBackend.JS_IR_ES6.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetBackend.JS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

