/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectivesImpl;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.directives.model.StringDirective;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0003!\"#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ+\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\b\b\u0000\u0010\u001c*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\u001c0\u00102\u0006\u0010\u001d\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser;", "", "container", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "<init>", "(Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;Lorg/jetbrains/kotlin/test/Assertions;)V", "simpleDirectives", "", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "stringValueDirectives", "", "Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", "", "valueDirectives", "Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;", "parse", "", "line", "addParsedDirective", "", "parsedDirective", "Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$ParsedDirective;", "convertToRegisteredDirective", "rawDirective", "Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$RawDirective;", "extractValue", "T", "name", "(Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;Ljava/lang/String;)Ljava/lang/Object;", "build", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "Companion", "RawDirective", "ParsedDirective", "test-infrastructure_test"})
@SourceDebugExtension(value={"SMAP\nRegisteredDirectivesParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegisteredDirectivesParser.kt\norg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n381#2,7:103\n381#2,7:110\n1557#3:117\n1628#3,3:118\n*S KotlinDebug\n*F\n+ 1 RegisteredDirectivesParser.kt\norg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser\n*L\n50#1:103,7\n54#1:110,7\n88#1:117\n88#1:118,3\n*E\n"})
public final class RegisteredDirectivesParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DirectivesContainer container;
    @NotNull
    private final Assertions assertions;
    @NotNull
    private final List<SimpleDirective> simpleDirectives;
    @NotNull
    private final Map<StringDirective, List<String>> stringValueDirectives;
    @NotNull
    private final Map<ValueDirective<?>, List<Object>> valueDirectives;
    @NotNull
    private static final Regex DIRECTIVE_PATTERN = new Regex("^//\\s*[!]?([A-Z0-9_]+)(:[ \\t]*(.*))? *$");
    @NotNull
    private static final Regex SPACES_PATTERN = new Regex("[,]?[ \\t]+");
    private static final int NAME_GROUP = 1;
    private static final int VALUES_GROUP = 3;

    public RegisteredDirectivesParser(@NotNull DirectivesContainer container, @NotNull Assertions assertions) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        this.container = container;
        this.assertions = assertions;
        this.simpleDirectives = new ArrayList();
        this.stringValueDirectives = new LinkedHashMap();
        this.valueDirectives = new LinkedHashMap();
    }

    public final boolean parse(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        RawDirective rawDirective = Companion.parseDirective(line);
        if (rawDirective == null) {
            return false;
        }
        RawDirective rawDirective2 = rawDirective;
        ParsedDirective parsedDirective = this.convertToRegisteredDirective(rawDirective2);
        if (parsedDirective == null) {
            return false;
        }
        ParsedDirective parsedDirective2 = parsedDirective;
        this.addParsedDirective(parsedDirective2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void addParsedDirective(@NotNull ParsedDirective parsedDirective) {
        Intrinsics.checkNotNullParameter((Object)parsedDirective, (String)"parsedDirective");
        Directive directive = parsedDirective.component1();
        List<?> values = parsedDirective.component2();
        Directive directive2 = directive;
        if (directive2 instanceof SimpleDirective) {
            ((Collection)this.simpleDirectives).add(directive);
        } else if (directive2 instanceof StringDirective) {
            Object object;
            void $this$getOrPut$iv;
            Map<StringDirective, List<String>> map = this.stringValueDirectives;
            Directive key$iv = directive;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List list = (List)object;
            Collection collection = list;
            Intrinsics.checkNotNull(values, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
            CollectionsKt.addAll((Collection)collection, (Iterable)values);
        } else if (directive2 instanceof ValueDirective) {
            List list;
            Map<ValueDirective<?>, List<Object>> $this$getOrPut$iv = this.valueDirectives;
            Directive key$iv = directive;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put((ValueDirective<?>)key$iv, answer$iv);
                list = answer$iv;
            } else {
                list = value$iv;
            }
            List list2 = list;
            Intrinsics.checkNotNull(values, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any>");
            list2.addAll((Collection<Object>)values);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final ParsedDirective convertToRegisteredDirective(@NotNull RawDirective rawDirective) {
        List list;
        Intrinsics.checkNotNullParameter((Object)rawDirective, (String)"rawDirective");
        String name = rawDirective.component1();
        List rawValues = rawDirective.component2();
        String rawValueString = rawDirective.component3();
        Directive directive = this.container.get(name);
        if (directive == null) {
            return null;
        }
        Directive directive2 = directive;
        Directive directive3 = directive2;
        if (directive3 instanceof SimpleDirective) {
            if (rawValues != null) {
                this.assertions.fail((Function0<String>)((Function0)() -> RegisteredDirectivesParser.convertToRegisteredDirective$lambda$1(directive2, rawValues)));
                throw null;
            }
            list = CollectionsKt.emptyList();
        } else if (directive3 instanceof StringDirective) {
            boolean bl = ((StringDirective)directive2).getMultiLine();
            if (bl) {
                list = CollectionsKt.listOfNotNull((Object)rawValueString);
            } else {
                if (bl) throw new NoWhenBranchMatchedException();
                list = rawValues;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
            }
        } else {
            void $this$mapTo$iv$iv;
            if (!(directive3 instanceof ValueDirective)) throw new NoWhenBranchMatchedException();
            if (rawValues == null) {
                this.assertions.fail((Function0<String>)((Function0)() -> RegisteredDirectivesParser.convertToRegisteredDirective$lambda$2(directive2)));
                throw null;
            }
            Iterable $this$map$iv = rawValues;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object t = this.extractValue((ValueDirective)directive2, (String)it);
                if (t == null) {
                    this.assertions.fail((Function0<String>)((Function0)() -> RegisteredDirectivesParser.convertToRegisteredDirective$lambda$4$lambda$3((String)it, directive2)));
                    throw null;
                }
                collection.add(t);
            }
            list = (List)destination$iv$iv;
        }
        List values = list;
        return new ParsedDirective(directive2, values);
    }

    private final <T> T extractValue(ValueDirective<T> $this$extractValue, String name) {
        return (T)$this$extractValue.getParser().invoke((Object)name);
    }

    @NotNull
    public final RegisteredDirectives build() {
        return new RegisteredDirectivesImpl(this.simpleDirectives, this.stringValueDirectives, this.valueDirectives);
    }

    private static final String convertToRegisteredDirective$lambda$1(Directive $directive, List $rawValues) {
        Intrinsics.checkNotNullParameter((Object)$directive, (String)"$directive");
        return "Directive " + $directive + " should have no arguments, but " + CollectionsKt.joinToString$default((Iterable)$rawValues, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " are passed";
    }

    private static final String convertToRegisteredDirective$lambda$2(Directive $directive) {
        Intrinsics.checkNotNullParameter((Object)$directive, (String)"$directive");
        return "Directive " + $directive + " must have at least one value";
    }

    private static final String convertToRegisteredDirective$lambda$4$lambda$3(String $it, Directive $directive) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$directive, (String)"$directive");
        return $it + " is not valid value for " + $directive;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$Companion;", "", "<init>", "()V", "DIRECTIVE_PATTERN", "Lkotlin/text/Regex;", "SPACES_PATTERN", "NAME_GROUP", "", "VALUES_GROUP", "parseDirective", "Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$RawDirective;", "line", "", "test-infrastructure_test"})
    @SourceDebugExtension(value={"SMAP\nRegisteredDirectivesParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegisteredDirectivesParser.kt\norg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n774#2:103\n865#2,2:104\n1#3:106\n*S KotlinDebug\n*F\n+ 1 RegisteredDirectivesParser.kt\norg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$Companion\n*L\n22#1:103\n22#1:104,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Nullable
        public final RawDirective parseDirective(@NotNull String line) {
            List list;
            String rawValue;
            String name;
            block5: {
                List list2;
                Iterator iterator;
                Collection destination$iv$iv;
                block4: {
                    block3: {
                        void $this$filterTo$iv$iv;
                        int n;
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        Object object = DIRECTIVE_PATTERN.matchEntire((CharSequence)line);
                        if (object == null || (object = object.getGroupValues()) == null) {
                            return null;
                        }
                        Object object2 = object;
                        String string = (String)CollectionsKt.getOrNull((List)object2, (int)1);
                        if (string == null) {
                            return null;
                        }
                        name = string;
                        rawValue = (String)CollectionsKt.getOrNull((List)object2, (int)3);
                        Object object3 = rawValue;
                        if (object3 == null) break block3;
                        CharSequence charSequence = (CharSequence)object3;
                        Regex regex = SPACES_PATTERN;
                        object3 = regex.split(charSequence, n = 0);
                        if (object3 == null) break block3;
                        Iterable iterable = (Iterable)object3;
                        boolean bl = false;
                        Iterable iterable2 = iterable;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        iterator = $this$filterTo$iv$iv.iterator();
                        break block4;
                    }
                    list = null;
                    break block5;
                }
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list3 = list2 = (List)destination$iv$iv;
                boolean bl = false;
                list = !((Collection)list3).isEmpty() ? list2 : null;
            }
            List values = list;
            return new RawDirective(name, values, rawValue);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$ParsedDirective;", "", "directive", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "values", "", "<init>", "(Lorg/jetbrains/kotlin/test/directives/model/Directive;Ljava/util/List;)V", "getDirective", "()Lorg/jetbrains/kotlin/test/directives/model/Directive;", "getValues", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "test-infrastructure_test"})
    public static final class ParsedDirective {
        @NotNull
        private final Directive directive;
        @NotNull
        private final List<?> values;

        public ParsedDirective(@NotNull Directive directive, @NotNull List<?> values) {
            Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            this.directive = directive;
            this.values = values;
        }

        @NotNull
        public final Directive getDirective() {
            return this.directive;
        }

        @NotNull
        public final List<?> getValues() {
            return this.values;
        }

        @NotNull
        public final Directive component1() {
            return this.directive;
        }

        @NotNull
        public final List<?> component2() {
            return this.values;
        }

        @NotNull
        public final ParsedDirective copy(@NotNull Directive directive, @NotNull List<?> values) {
            Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new ParsedDirective(directive, values);
        }

        public static /* synthetic */ ParsedDirective copy$default(ParsedDirective parsedDirective, Directive directive, List list, int n, Object object) {
            if ((n & 1) != 0) {
                directive = parsedDirective.directive;
            }
            if ((n & 2) != 0) {
                list = parsedDirective.values;
            }
            return parsedDirective.copy(directive, list);
        }

        @NotNull
        public String toString() {
            return "ParsedDirective(directive=" + this.directive + ", values=" + this.values + ')';
        }

        public int hashCode() {
            int result = this.directive.hashCode();
            result = result * 31 + ((Object)this.values).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedDirective)) {
                return false;
            }
            ParsedDirective parsedDirective = (ParsedDirective)other;
            if (!Intrinsics.areEqual((Object)this.directive, (Object)parsedDirective.directive)) {
                return false;
            }
            return Intrinsics.areEqual(this.values, parsedDirective.values);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$RawDirective;", "", "name", "", "values", "", "rawValue", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getValues", "()Ljava/util/List;", "getRawValue", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "test-infrastructure_test"})
    public static final class RawDirective {
        @NotNull
        private final String name;
        @Nullable
        private final List<String> values;
        @Nullable
        private final String rawValue;

        public RawDirective(@NotNull String name, @Nullable List<String> values, @Nullable String rawValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.values = values;
            this.rawValue = rawValue;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final List<String> getValues() {
            return this.values;
        }

        @Nullable
        public final String getRawValue() {
            return this.rawValue;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final List<String> component2() {
            return this.values;
        }

        @Nullable
        public final String component3() {
            return this.rawValue;
        }

        @NotNull
        public final RawDirective copy(@NotNull String name, @Nullable List<String> values, @Nullable String rawValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new RawDirective(name, values, rawValue);
        }

        public static /* synthetic */ RawDirective copy$default(RawDirective rawDirective, String string, List list, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = rawDirective.name;
            }
            if ((n & 2) != 0) {
                list = rawDirective.values;
            }
            if ((n & 4) != 0) {
                string2 = rawDirective.rawValue;
            }
            return rawDirective.copy(string, list, string2);
        }

        @NotNull
        public String toString() {
            return "RawDirective(name=" + this.name + ", values=" + this.values + ", rawValue=" + this.rawValue + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + (this.values == null ? 0 : ((Object)this.values).hashCode());
            result = result * 31 + (this.rawValue == null ? 0 : this.rawValue.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RawDirective)) {
                return false;
            }
            RawDirective rawDirective = (RawDirective)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)rawDirective.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.values, rawDirective.values)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.rawValue, (Object)rawDirective.rawValue);
        }
    }
}

