/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codeMetaInfo.renderConfigurations;

import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codeMetaInfo.model.CodeMetaInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0004J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0004J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/codeMetaInfo/renderConfigurations/AbstractCodeMetaInfoRenderConfiguration;", "", "renderParams", "", "<init>", "(Z)V", "getRenderParams", "()Z", "setRenderParams", "clickOrPressRegex", "Lkotlin/text/Regex;", "asString", "", "codeMetaInfo", "Lorg/jetbrains/kotlin/codeMetaInfo/model/CodeMetaInfo;", "getAdditionalParams", "sanitizeLineMarkerTooltip", "originalText", "sanitizeLineBreaks", "getAttributesString", "test-infrastructure-utils_test"})
public abstract class AbstractCodeMetaInfoRenderConfiguration {
    private boolean renderParams;
    @NotNull
    private final Regex clickOrPressRegex;

    public AbstractCodeMetaInfoRenderConfiguration(boolean renderParams) {
        this.renderParams = renderParams;
        this.clickOrPressRegex = new Regex("(Click or press|Press).*(to navigate)");
    }

    public /* synthetic */ AbstractCodeMetaInfoRenderConfiguration(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public final boolean getRenderParams() {
        return this.renderParams;
    }

    public final void setRenderParams(boolean bl) {
        this.renderParams = bl;
    }

    @NotNull
    public String asString(@NotNull CodeMetaInfo codeMetaInfo) {
        Intrinsics.checkNotNullParameter((Object)codeMetaInfo, (String)"codeMetaInfo");
        return codeMetaInfo.getTag() + this.getAttributesString(codeMetaInfo);
    }

    @NotNull
    public String getAdditionalParams(@NotNull CodeMetaInfo codeMetaInfo) {
        Intrinsics.checkNotNullParameter((Object)codeMetaInfo, (String)"codeMetaInfo");
        return "";
    }

    @NotNull
    protected final String sanitizeLineMarkerTooltip(@Nullable String originalText) {
        if (originalText == null) {
            return "null";
        }
        String string = StringUtil.removeHtmlTags((String)originalText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeHtmlTags(...)");
        CharSequence charSequence = StringsKt.replace$default((String)string, (String)"\u00a0", (String)"", (boolean)false, (int)4, null);
        Regex regex = this.clickOrPressRegex;
        String string2 = "$1 ... $2";
        String noHtmlTags = ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string2))).toString();
        return this.sanitizeLineBreaks(noHtmlTags);
    }

    @NotNull
    protected final String sanitizeLineBreaks(@NotNull String originalText) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        String sanitizedText = originalText;
        sanitizedText = StringUtil.replace((String)sanitizedText, (String)"\r\n", (String)" ");
        sanitizedText = StringUtil.replace((String)sanitizedText, (String)"\n", (String)" ");
        sanitizedText = StringUtil.replace((String)sanitizedText, (String)"\r", (String)" ");
        return sanitizedText;
    }

    @NotNull
    protected final String getAttributesString(@NotNull CodeMetaInfo codeMetaInfo) {
        Intrinsics.checkNotNullParameter((Object)codeMetaInfo, (String)"codeMetaInfo");
        if (codeMetaInfo.getAttributes().isEmpty()) {
            return "";
        }
        return '{' + CollectionsKt.joinToString$default((Iterable)codeMetaInfo.getAttributes(), (CharSequence)";", null, null, (int)0, null, null, (int)62, null) + '}';
    }

    public AbstractCodeMetaInfoRenderConfiguration() {
        this(false, 1, null);
    }
}

