/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.configuration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.TargetSupportException;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0006\u0010\u0003\u001a\u00020\u0001\u00a8\u0006\u0004"}, d2={"hostOsArch", "", "hostOs", "hostArch", "tests-common-new_test"})
public final class NativeEnvironmentConfiguratorKt {
    private static final String hostOsArch() {
        return NativeEnvironmentConfiguratorKt.hostOs() + '_' + NativeEnvironmentConfiguratorKt.hostArch();
    }

    private static final String hostOs() {
        String string;
        String javaOsName = System.getProperty("os.name");
        if (Intrinsics.areEqual((Object)javaOsName, (Object)"Mac OS X")) {
            string = "macos";
        } else if (Intrinsics.areEqual((Object)javaOsName, (Object)"Linux")) {
            string = "linux";
        } else {
            Intrinsics.checkNotNull((Object)javaOsName);
            if (StringsKt.startsWith$default((String)javaOsName, (String)"Windows", (boolean)false, (int)2, null)) {
                string = "mingw";
            } else {
                throw new TargetSupportException("Unknown operating system: " + javaOsName, null, 2, null);
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final String hostArch() {
        String arch = System.getProperty("os.arch");
        if (arch == null) throw new TargetSupportException("Unknown hardware platform: " + arch, null, 2, null);
        int n = -1;
        switch (arch.hashCode()) {
            case -1221096139: {
                if (arch.equals("aarch64")) {
                    n = 1;
                }
                break;
            }
            case -806050265: {
                if (arch.equals("x86_64")) {
                    n = 2;
                }
                break;
            }
            case 93084186: {
                if (arch.equals("arm64")) {
                    n = 3;
                }
                break;
            }
            case 92926582: {
                if (arch.equals("amd64")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                return "x64";
            }
            case 4: {
                return "x64";
            }
            case 3: {
                return "arm64";
            }
            case 1: {
                return "arm64";
            }
            default: {
                throw new TargetSupportException("Unknown hardware platform: " + arch, null, 2, null);
            }
        }
    }

    public static final /* synthetic */ String access$hostOsArch() {
        return NativeEnvironmentConfiguratorKt.hostOsArch();
    }
}

