/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.backend.handlers.DebugRunner;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.LocalNullValue;
import org.jetbrains.kotlin.test.utils.LocalPrimitive;
import org.jetbrains.kotlin.test.utils.LocalReference;
import org.jetbrains.kotlin.test.utils.LocalValue;
import org.jetbrains.kotlin.test.utils.LocalVariableRecord;
import org.jetbrains.kotlin.test.utils.SteppingTestLoggedData;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J-\u0010\u0011\u001a\u00020\r2\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0015j\b\u0012\u0004\u0012\u00020\u0014`\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner;", "Lorg/jetbrains/kotlin/test/backend/handlers/DebugRunner;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "toRecord", "Lorg/jetbrains/kotlin/test/utils/LocalVariableRecord;", "frame", "Lcom/sun/jdi/StackFrame;", "variable", "Lcom/sun/jdi/LocalVariable;", "waitUntil", "", "condition", "Lkotlin/Function0;", "", "storeStep", "loggedItems", "Lkotlin/collections/ArrayList;", "Lorg/jetbrains/kotlin/test/utils/SteppingTestLoggedData;", "Ljava/util/ArrayList;", "event", "Lcom/sun/jdi/event/Event;", "(Ljava/util/ArrayList;Lcom/sun/jdi/event/Event;)V", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nDebugRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugRunner.kt\norg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,246:1\n1547#2:247\n1618#2,3:248\n*S KotlinDebug\n*F\n+ 1 DebugRunner.kt\norg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner\n*L\n232#1:247\n232#1:248,3\n*E\n"})
public final class LocalVariableDebugRunner
extends DebugRunner {
    public LocalVariableDebugRunner(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    private final LocalVariableRecord toRecord(StackFrame frame, LocalVariable variable) {
        LocalValue localValue;
        Value value = frame.getValue(variable);
        if (value == null) {
            localValue = LocalNullValue.INSTANCE;
        } else if (value instanceof ObjectReference && !Intrinsics.areEqual((Object)((ObjectReference)value).referenceType().name(), (Object)"java.lang.String")) {
            String string = String.valueOf(((ObjectReference)value).uniqueID());
            String string2 = ((ObjectReference)value).referenceType().name();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
            localValue = new LocalReference(string, string2);
        } else {
            String string = value.toString();
            String string3 = value.type().name();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name(...)");
            localValue = new LocalPrimitive(string, string3);
        }
        LocalValue valueRecord = localValue;
        String string = variable.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        return new LocalVariableRecord(string, variable.typeName(), valueRecord);
    }

    private final void waitUntil(Function0<Boolean> condition) {
        while (!((Boolean)condition.invoke()).booleanValue()) {
            Thread.sleep(10L);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void storeStep(@NotNull ArrayList<SteppingTestLoggedData> loggedItems, @NotNull Event event) {
        List list;
        Intrinsics.checkNotNullParameter(loggedItems, (String)"loggedItems");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LocatableEvent locatableEvent = (LocatableEvent)event;
        this.waitUntil((Function0<Boolean>)((Function0)new Function0<Boolean>(locatableEvent){
            final /* synthetic */ LocatableEvent $locatableEvent;
            {
                this.$locatableEvent = $locatableEvent;
                super(0);
            }

            public final Boolean invoke() {
                return this.$locatableEvent.thread().isSuspended();
            }
        }));
        Location location = locatableEvent.location();
        if (location.method().isSynthetic()) {
            return;
        }
        StackFrame frame = locatableEvent.thread().frame(0);
        try {
            void $this$mapTo$iv$iv;
            List<LocalVariable> list2 = frame.visibleVariables();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"visibleVariables(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void variable;
                LocalVariable localVariable = (LocalVariable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)frame);
                Intrinsics.checkNotNull((Object)variable);
                collection.add(this.toRecord(frame, (LocalVariable)variable));
            }
            list = (List)destination$iv$iv;
        }
        catch (AbsentInformationException e) {
            list = CollectionsKt.emptyList();
        }
        List visibleVars = list;
        int n = location.lineNumber();
        Intrinsics.checkNotNull((Object)location);
        loggedItems.add(new SteppingTestLoggedData(n, false, this.formatAsExpectation(location, visibleVars)));
    }
}

