/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.intellij.rt.execution.junit.FileComparisonFailure;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.fir.backend.FirMangler;
import org.jetbrains.kotlin.fir.backend.FirMetadataSource;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.ObsoleteDescriptorBasedAPI;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrMetadataSourceOwner;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.overrides.IrVisibilityUtilKt;
import org.jetbrains.kotlin.ir.symbols.IrFileSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.BodyPrintingStrategy;
import org.jetbrains.kotlin.ir.util.CustomKotlinLikeDumpStrategy;
import org.jetbrains.kotlin.ir.util.FakeOverridesStrategy;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.KotlinLikeDumpOptions;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.load.java.lazy.descriptors.JavaDescriptorUtilKt;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.backend.BlackBoxCodegenSuppressor;
import org.jetbrains.kotlin.test.backend.BlackBoxCodegenSuppressorKt;
import org.jetbrains.kotlin.test.backend.handlers.AbstractIrHandler;
import org.jetbrains.kotlin.test.backend.handlers.CheckBlock;
import org.jetbrains.kotlin.test.backend.handlers.ComputedBy;
import org.jetbrains.kotlin.test.backend.handlers.ComputedMangledName;
import org.jetbrains.kotlin.test.backend.handlers.ComputedSignature;
import org.jetbrains.kotlin.test.backend.handlers.IrMangledNameAndSignatureDumpHandlerKt;
import org.jetbrains.kotlin.test.backend.handlers.IrPrettyKotlinDumpHandlerKt;
import org.jetbrains.kotlin.test.backend.handlers.IrTextDumpHandler;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;
import org.jetbrains.kotlin.test.model.BackendKind;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0002#$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R+\u0010\u0013\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u00150\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0012\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrMangledNameAndSignatureDumpHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/AbstractIrHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "artifactKind", "Lorg/jetbrains/kotlin/test/model/BackendKind;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lorg/jetbrains/kotlin/test/model/BackendKind;)V", "computeDumpExtension", "", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "expectedFile", "Ljava/io/File;", "getExpectedFile", "()Ljava/io/File;", "expectedFile$delegate", "Lkotlin/Lazy;", "checkBlockGroupIterator", "", "Lorg/jetbrains/kotlin/test/backend/handlers/CheckBlockGroup;", "", "Lorg/jetbrains/kotlin/test/backend/handlers/CheckBlock;", "getCheckBlockGroupIterator", "()Ljava/util/Iterator;", "checkBlockGroupIterator$delegate", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "processAfterAllModules", "someAssertionWasFailed", "", "Companion", "DumpStrategy", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nIrMangledNameAndSignatureDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrMangledNameAndSignatureDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrMangledNameAndSignatureDumpHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BlackBoxCodegenSuppressor.kt\norg/jetbrains/kotlin/test/backend/BlackBoxCodegenSuppressor$SuppressionChecker\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,653:1\n1#2:654\n1#2:681\n141#3,8:655\n81#3,4:663\n85#3:671\n86#3,2:674\n153#3:676\n149#3,4:677\n154#3:682\n89#3:683\n157#3,2:684\n1547#4:667\n1618#4,3:668\n288#4,2:672\n*S KotlinDebug\n*F\n+ 1 IrMangledNameAndSignatureDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrMangledNameAndSignatureDumpHandler\n*L\n171#1:681\n171#1:655,8\n171#1:663,4\n171#1:671\n171#1:674,2\n171#1:676\n171#1:677,4\n171#1:682\n171#1:683\n171#1:684,2\n171#1:667\n171#1:668,3\n171#1:672,2\n*E\n"})
public final class IrMangledNameAndSignatureDumpHandler
extends AbstractIrHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiModuleInfoDumper dumper;
    @NotNull
    private final Lazy expectedFile$delegate;
    @NotNull
    private final Lazy checkBlockGroupIterator$delegate;
    @NotNull
    public static final String DUMP_EXTENSION = "sig.kt.txt";

    public IrMangledNameAndSignatureDumpHandler(@NotNull TestServices testServices, @NotNull BackendKind<IrBackendInput> artifactKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(artifactKind, (String)"artifactKind");
        super(testServices, artifactKind, false, false, 12, null);
        this.dumper = new MultiModuleInfoDumper("// MODULE: %s");
        this.expectedFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(testServices, this){
            final /* synthetic */ TestServices $testServices;
            final /* synthetic */ IrMangledNameAndSignatureDumpHandler this$0;
            {
                this.$testServices = $testServices;
                this.this$0 = $receiver;
                super(0);
            }

            public final File invoke() {
                return FileUtilsKt.withExtension((File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.$testServices).getOriginalTestDataFiles()), IrMangledNameAndSignatureDumpHandler.access$computeDumpExtension(this.this$0));
            }
        }));
        this.checkBlockGroupIterator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Iterator<? extends List<? extends CheckBlock>>>(this){
            final /* synthetic */ IrMangledNameAndSignatureDumpHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Iterator<List<CheckBlock>> invoke() {
                List list;
                try {
                    list = IrMangledNameAndSignatureDumpHandlerKt.access$parseAllCheckBlocks(FilesKt.readText$default((File)IrMangledNameAndSignatureDumpHandler.access$getExpectedFile(this.this$0), null, (int)1, null));
                }
                catch (FileNotFoundException e) {
                    list = CollectionsKt.emptyList();
                }
                return list.iterator();
            }
        }));
    }

    private final String computeDumpExtension() {
        return Intrinsics.areEqual(DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getDefaultFrontend(), (Object)FrontendKinds.ClassicFrontend.INSTANCE) || !TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(CodegenTestDirectives.INSTANCE.getSEPARATE_SIGNATURE_DUMP_FOR_K2()) ? DUMP_EXTENSION : "fir.sig.kt.txt";
    }

    private final File getExpectedFile() {
        Lazy lazy = this.expectedFile$delegate;
        return (File)lazy.getValue();
    }

    private final Iterator<List<CheckBlock>> getCheckBlockGroupIterator() {
        Lazy lazy = this.checkBlockGroupIterator$delegate;
        return (Iterator)lazy.getValue();
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull IrBackendInput info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_SIGNATURES())) {
            return;
        }
        IrPrettyKotlinDumpHandlerKt.dumpModuleKotlinLike(module, TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules(), info, this.dumper, new KotlinLikeDumpOptions((CustomKotlinLikeDumpStrategy)new DumpStrategy(module, info.getIrMangler(), info.getDescriptorMangler(), info.getFirMangler(), info.getIrModuleFragment().getIrBuiltins()), false, false, false, false, null, FakeOverridesStrategy.ALL_EXCEPT_ANY, BodyPrintingStrategy.NO_BODIES, false, true, true, false, 2358, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        block11: {
            Throwable throwable;
            ValueDirective<TargetBackend> valueDirective2;
            if (this.dumper.isEmpty()) {
                return;
            }
            FrontendKind<?> frontendKind = DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getDefaultFrontend();
            ValueDirective<TargetBackend> it = valueDirective2 = CodegenTestDirectives.INSTANCE.getMUTE_SIGNATURE_COMPARISON_K2();
            boolean bl = false;
            List muteDirectives = CollectionsKt.listOfNotNull(Intrinsics.areEqual(frontendKind, (Object)FrontendKinds.FIR.INSTANCE) ? valueDirective2 : null);
            BlackBoxCodegenSuppressor.SuppressionChecker this_$iv = BlackBoxCodegenSuppressorKt.getCodegenSuppressionChecker(this.getTestServices());
            boolean $i$f$checkMuted = false;
            try {
                boolean bl2 = false;
                Assertions.assertEqualsToFile$default(this.getAssertions(), this.getExpectedFile(), this.dumper.generateResultingDump(), null, 4, null);
                throwable = null;
            }
            catch (Throwable e$iv) {
                Throwable throwable2 = e$iv;
                if (!(throwable2 instanceof FileComparisonFailure)) {
                    throwable2 = null;
                }
                Throwable throwable3 = (Throwable)((Object)((FileComparisonFailure)((Object)throwable2)));
                if (throwable3 == null) {
                    throw e$iv;
                }
                throwable = throwable3;
            }
            Throwable expectedError$iv = throwable;
            BlackBoxCodegenSuppressor.SuppressionChecker this_$iv$iv = this_$iv;
            boolean $i$f$processAllDirectives = false;
            List<TestModule> modules$iv$iv = TestModuleStructureKt.getModuleStructure(this_$iv$iv.getTestServices()).getModules();
            for (ValueDirective ignoreDirective$iv$iv : muteDirectives) {
                void suppressionResult$iv;
                BlackBoxCodegenSuppressor.SuppressionChecker.SuppressionResult suppressionResult$iv$iv;
                Object v2;
                block10: {
                    void $this$firstOrNull$iv$iv$iv;
                    void $this$mapTo$iv$iv$iv$iv;
                    Iterable $this$map$iv$iv$iv;
                    Iterable iterable = modules$iv$iv;
                    boolean $i$f$map = false;
                    Iterator iterator = $this$map$iv$iv$iv;
                    Collection destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
                        void it$iv$iv;
                        TestModule testModule = (TestModule)item$iv$iv$iv$iv;
                        Collection collection = destination$iv$iv$iv$iv;
                        boolean bl3 = false;
                        collection.add(this_$iv$iv.failuresInModuleAreIgnored((TestModule)it$iv$iv, ignoreDirective$iv$iv));
                    }
                    $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                        BlackBoxCodegenSuppressor.SuppressionChecker.SuppressionResult it$iv$iv = (BlackBoxCodegenSuppressor.SuppressionChecker.SuppressionResult)element$iv$iv$iv;
                        boolean bl4 = false;
                        if (!it$iv$iv.getTestMuted()) continue;
                        v2 = element$iv$iv$iv;
                        break block10;
                    }
                    v2 = null;
                }
                BlackBoxCodegenSuppressor.SuppressionChecker.SuppressionResult suppressionResult = v2;
                if (suppressionResult == null) continue;
                BlackBoxCodegenSuppressor.SuppressionChecker.SuppressionResult suppressionResult2 = suppressionResult$iv$iv = suppressionResult;
                ValueDirective ignoreDirective$iv = ignoreDirective$iv$iv;
                boolean bl5 = false;
                AssertionError assertionError = this_$iv.processMutedTest(expectedError$iv != null, ignoreDirective$iv, (BlackBoxCodegenSuppressor.SuppressionChecker.SuppressionResult)suppressionResult$iv);
                if (assertionError != null) {
                    AssertionError it$iv = assertionError;
                    boolean bl6 = false;
                    throw it$iv;
                }
                break block11;
            }
            Throwable throwable4 = expectedError$iv;
            if (throwable4 != null) {
                Throwable it$iv = throwable4;
                boolean bl7 = false;
                throw it$iv;
            }
        }
    }

    public static final /* synthetic */ String access$computeDumpExtension(IrMangledNameAndSignatureDumpHandler $this) {
        return $this.computeDumpExtension();
    }

    public static final /* synthetic */ File access$getExpectedFile(IrMangledNameAndSignatureDumpHandler $this) {
        return $this.getExpectedFile();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrMangledNameAndSignatureDumpHandler$Companion;", "", "<init>", "()V", "DUMP_EXTENSION", "", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\f\u0010'\u001a\u00020(*\u00020)H\u0002J\u0014\u0010*\u001a\u00020(*\u00020)2\u0006\u0010+\u001a\u00020\u001eH\u0002J\"\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u001e2\u0006\u00100\u001a\u00020)H\u0016J\u0018\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u0002032\u0006\u0010/\u001a\u000204H\u0016J\u0018\u00105\u001a\u0002062\u0006\u0010+\u001a\u00020\u001e2\u0006\u00107\u001a\u000206H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\u00020\u001d*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001fR\u0018\u0010 \u001a\u00020\u001d*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001fR\u001e\u0010!\u001a\u00020\u001d*\u00020\u001e8BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010#\u001a\u0004\b$\u0010\u001fR\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrMangledNameAndSignatureDumpHandler$DumpStrategy;", "Lorg/jetbrains/kotlin/ir/util/CustomKotlinLikeDumpStrategy;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "irMangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "descriptorMangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;", "firMangler", "Lorg/jetbrains/kotlin/fir/backend/FirMangler;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "<init>", "(Lorg/jetbrains/kotlin/test/backend/handlers/IrMangledNameAndSignatureDumpHandler;Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;Lorg/jetbrains/kotlin/fir/backend/FirMangler;Lorg/jetbrains/kotlin/ir/IrBuiltIns;)V", "getModule", "()Lorg/jetbrains/kotlin/test/model/TestModule;", "getIrMangler", "()Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "getDescriptorMangler", "()Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;", "getFirMangler", "()Lorg/jetbrains/kotlin/fir/backend/FirMangler;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "targetBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "getTargetBackend", "()Lorg/jetbrains/kotlin/test/TargetBackend;", "isFunctionWithNonUnitReturnType", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Z", "isMainFunction", "potentiallyHasDifferentMangledNamesDependingOnBackend", "getPotentiallyHasDifferentMangledNamesDependingOnBackend$annotations", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "getPotentiallyHasDifferentMangledNamesDependingOnBackend", "signatureComposer", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "printCheckMarkerForNewDeclaration", "", "Lorg/jetbrains/kotlin/utils/Printer;", "printSignatureAndMangledName", "declaration", "willPrintElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "container", "printer", "shouldPrintAnnotation", "annotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "transformModifiersForDeclaration", "Lorg/jetbrains/kotlin/ir/util/CustomKotlinLikeDumpStrategy$Modifiers;", "modifiers", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nIrMangledNameAndSignatureDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrMangledNameAndSignatureDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrMangledNameAndSignatureDumpHandler$DumpStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,653:1\n1#2:654\n1724#3,3:655\n1745#3,3:660\n1247#4,2:658\n*S KotlinDebug\n*F\n+ 1 IrMangledNameAndSignatureDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrMangledNameAndSignatureDumpHandler$DumpStrategy\n*L\n311#1:655,3\n255#1:660,3\n346#1:658,2\n*E\n"})
    private final class DumpStrategy
    implements CustomKotlinLikeDumpStrategy {
        @NotNull
        private final TestModule module;
        @NotNull
        private final KotlinMangler.IrMangler irMangler;
        @Nullable
        private final KotlinMangler.DescriptorMangler descriptorMangler;
        @Nullable
        private final FirMangler firMangler;
        @NotNull
        private final IrBuiltIns irBuiltIns;
        @NotNull
        private final PublicIdSignatureComputer signatureComposer;

        public DumpStrategy(@NotNull TestModule module, @Nullable KotlinMangler.IrMangler irMangler, @Nullable KotlinMangler.DescriptorMangler descriptorMangler, @NotNull FirMangler firMangler, IrBuiltIns irBuiltIns) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)irMangler, (String)"irMangler");
            Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
            this.module = module;
            this.irMangler = irMangler;
            this.descriptorMangler = descriptorMangler;
            this.firMangler = firMangler;
            this.irBuiltIns = irBuiltIns;
            this.signatureComposer = new PublicIdSignatureComputer(this.irMangler);
        }

        @NotNull
        public final TestModule getModule() {
            return this.module;
        }

        @NotNull
        public final KotlinMangler.IrMangler getIrMangler() {
            return this.irMangler;
        }

        @Nullable
        public final KotlinMangler.DescriptorMangler getDescriptorMangler() {
            return this.descriptorMangler;
        }

        @Nullable
        public final FirMangler getFirMangler() {
            return this.firMangler;
        }

        @NotNull
        public final IrBuiltIns getIrBuiltIns() {
            return this.irBuiltIns;
        }

        private final TargetBackend getTargetBackend() {
            TargetBackend targetBackend = this.module.getTargetBackend();
            Intrinsics.checkNotNull((Object)((Object)targetBackend));
            return targetBackend;
        }

        private final boolean isFunctionWithNonUnitReturnType(IrDeclaration $this$isFunctionWithNonUnitReturnType) {
            return $this$isFunctionWithNonUnitReturnType instanceof IrSimpleFunction && !IrTypePredicatesKt.isUnit((IrType)((IrSimpleFunction)$this$isFunctionWithNonUnitReturnType).getReturnType());
        }

        private final boolean isMainFunction(IrDeclaration $this$isMainFunction) {
            return IrUtilsKt.isTopLevel((IrDeclaration)$this$isMainFunction) && $this$isMainFunction instanceof IrSimpleFunction && Intrinsics.areEqual((Object)((IrSimpleFunction)$this$isMainFunction).getName().asString(), (Object)"main");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean getPotentiallyHasDifferentMangledNamesDependingOnBackend(IrDeclaration $this$potentiallyHasDifferentMangledNamesDependingOnBackend) {
            boolean bl;
            if (this.isMainFunction($this$potentiallyHasDifferentMangledNamesDependingOnBackend)) return true;
            if (this.isFunctionWithNonUnitReturnType($this$potentiallyHasDifferentMangledNamesDependingOnBackend)) return true;
            DeclarationDescriptor declarationDescriptor = $this$potentiallyHasDifferentMangledNamesDependingOnBackend.getSymbol().getDescriptor();
            PropertyDescriptor propertyDescriptor = declarationDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)declarationDescriptor : null;
            if (propertyDescriptor != null) {
                if (JavaDescriptorUtilKt.isJavaField((PropertyDescriptor)propertyDescriptor)) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            IrDeclarationParent it = $this$potentiallyHasDifferentMangledNamesDependingOnBackend.getParent();
            boolean bl2 = false;
            if (!(it instanceof IrDeclaration)) return false;
            if (!this.getPotentiallyHasDifferentMangledNamesDependingOnBackend((IrDeclaration)it)) return false;
            return true;
        }

        @ObsoleteDescriptorBasedAPI
        private static /* synthetic */ void getPotentiallyHasDifferentMangledNamesDependingOnBackend$annotations(IrDeclaration irDeclaration) {
        }

        private final void printCheckMarkerForNewDeclaration(Printer $this$printCheckMarkerForNewDeclaration) {
            List list;
            switch (WhenMappings.$EnumSwitchMapping$0[this.getTargetBackend().ordinal()]) {
                case 1: 
                case 2: {
                    TargetBackend[] targetBackendArray = new TargetBackend[]{TargetBackend.JS_IR, TargetBackend.NATIVE};
                    list = CollectionsKt.listOf((Object[])targetBackendArray);
                    break;
                }
                default: {
                    list = CollectionsKt.listOf((Object)((Object)this.getTargetBackend()));
                }
            }
            IrMangledNameAndSignatureDumpHandlerKt.access$printlnCheckMarker($this$printCheckMarkerForNewDeclaration, list);
        }

        private final void printSignatureAndMangledName(Printer $this$printSignatureAndMangledName, IrDeclaration declaration) {
            IrSymbol symbol2 = declaration.getSymbol();
            IrDeclarationWithVisibility irDeclarationWithVisibility = declaration instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)declaration : null;
            boolean canDumpMangledNameAndSignaturesComputedByFrontend = !(irDeclarationWithVisibility != null ? IrVisibilityUtilKt.isEffectivelyPrivate((IrDeclarationWithVisibility)irDeclarationWithVisibility) : false);
            List signatures = new ArrayList();
            List fullMangledNames = new ArrayList();
            List signatureMangledNames = new ArrayList();
            IrFile irFile = IrUtilsKt.getFileOrNull((IrDeclaration)declaration);
            IdSignature signatureComputedFromIr2 = (IdSignature)this.signatureComposer.inFile((IrFileSymbol)(irFile != null ? irFile.getSymbol() : null), (Function0)new Function0<IdSignature>(this, declaration, (List<ComputedSignature>)signatures){
                final /* synthetic */ DumpStrategy this$0;
                final /* synthetic */ IrDeclaration $declaration;
                final /* synthetic */ List<ComputedSignature> $signatures;
                {
                    this.this$0 = $receiver;
                    this.$declaration = $declaration;
                    this.$signatures = $signatures;
                    super(0);
                }

                public final IdSignature invoke() {
                    IdSignature idSignature = DumpStrategy.access$getSignatureComposer$p(this.this$0).computeSignature(this.$declaration);
                    List<ComputedSignature> list = this.$signatures;
                    IdSignature it = idSignature;
                    boolean bl = false;
                    IrMangledNameAndSignatureDumpHandlerKt.access$addSignatureTo(list, it, ComputedBy.IR, true);
                    return idSignature;
                }
            });
            IrMangledNameAndSignatureDumpHandlerKt.access$addFullMangledNameTo(this.irMangler, fullMangledNames, declaration);
            IrMangledNameAndSignatureDumpHandlerKt.access$addSignatureMangledNameTo((KotlinMangler)this.irMangler, signatureMangledNames, declaration, ComputedBy.IR);
            if (canDumpMangledNameAndSignaturesComputedByFrontend) {
                FirDeclaration firDeclaration;
                IrMangledNameAndSignatureDumpHandlerKt.access$addSignatureTo(signatures, symbol2.getSignature(), ComputedBy.FE, true);
                IrMangledNameAndSignatureDumpHandlerKt.access$addSignatureTo(signatures, symbol2.getPrivateSignature(), ComputedBy.FE, false);
                IrMetadataSourceOwner irMetadataSourceOwner = declaration instanceof IrMetadataSourceOwner ? (IrMetadataSourceOwner)declaration : null;
                MetadataSource metadataSource = irMetadataSourceOwner != null ? irMetadataSourceOwner.getMetadata() : null;
                FirMetadataSource firMetadataSource = metadataSource instanceof FirMetadataSource ? (FirMetadataSource)metadataSource : null;
                Object object = firDeclaration = firMetadataSource != null ? firMetadataSource.getFir() : null;
                if (firDeclaration != null) {
                    FirMangler firMangler = this.firMangler;
                    if (firMangler != null) {
                        IrMangledNameAndSignatureDumpHandlerKt.access$addSignatureMangledNameTo((KotlinMangler)firMangler, signatureMangledNames, firDeclaration, ComputedBy.FE);
                    }
                } else {
                    KotlinMangler.DescriptorMangler descriptorMangler = this.descriptorMangler;
                    if (descriptorMangler != null) {
                        IrMangledNameAndSignatureDumpHandlerKt.access$addSignatureMangledNameTo((KotlinMangler)descriptorMangler, signatureMangledNames, symbol2.getDescriptor(), ComputedBy.FE);
                    }
                }
            }
            boolean printedActualMangledNameAndSignature = false;
            if (IrMangledNameAndSignatureDumpHandler.this.getCheckBlockGroupIterator().hasNext()) {
                List checkBlockGroupForDeclaration = (List)IrMangledNameAndSignatureDumpHandler.this.getCheckBlockGroupIterator().next();
                for (CheckBlock checkBlock : checkBlockGroupForDeclaration) {
                    IrMangledNameAndSignatureDumpHandlerKt.access$printlnCheckMarker($this$printSignatureAndMangledName, checkBlock.getBackends());
                    if (checkBlock.getBackends().isEmpty() || checkBlock.getBackends().contains((Object)TargetBackend.ANY) || checkBlock.getBackends().contains((Object)this.getTargetBackend())) {
                        DumpStrategy.printSignatureAndMangledName$printActualMangledNamesAndSignatures($this$printSignatureAndMangledName, fullMangledNames, canDumpMangledNameAndSignaturesComputedByFrontend, signatureMangledNames, signatures, signatureComputedFromIr2);
                        printedActualMangledNameAndSignature = true;
                        continue;
                    }
                    checkBlock.getExpectations().forEach(p0 -> {
                        Object[] objectArray = new Object[]{p0};
                        $this$printSignatureAndMangledName.println(objectArray);
                    });
                }
                if (!printedActualMangledNameAndSignature) {
                    this.printCheckMarkerForNewDeclaration($this$printSignatureAndMangledName);
                    DumpStrategy.printSignatureAndMangledName$printActualMangledNamesAndSignatures($this$printSignatureAndMangledName, fullMangledNames, canDumpMangledNameAndSignaturesComputedByFrontend, signatureMangledNames, signatures, signatureComputedFromIr2);
                }
            } else {
                if (this.getPotentiallyHasDifferentMangledNamesDependingOnBackend(declaration)) {
                    this.printCheckMarkerForNewDeclaration($this$printSignatureAndMangledName);
                } else {
                    IrMangledNameAndSignatureDumpHandlerKt.access$printlnCheckMarker($this$printSignatureAndMangledName, CollectionsKt.emptyList());
                }
                DumpStrategy.printSignatureAndMangledName$printActualMangledNamesAndSignatures($this$printSignatureAndMangledName, fullMangledNames, canDumpMangledNameAndSignaturesComputedByFrontend, signatureMangledNames, signatures, signatureComputedFromIr2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public boolean willPrintElement(@NotNull IrElement element, @Nullable IrDeclaration container, @NotNull Printer printer) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
            if (!(element instanceof IrDeclaration)) {
                return true;
            }
            if (element instanceof IrAnonymousInitializer) {
                return false;
            }
            if (element instanceof IrField && ((IrField)element).getOrigin().isSynthetic()) {
                return false;
            }
            if (element instanceof IrProperty && ((IrProperty)element).isFakeOverride()) {
                boolean bl;
                block10: {
                    void $this$all$iv;
                    Iterable iterable = IrFakeOverrideUtilsKt.collectRealOverrides$default((IrOverridableDeclaration)((IrOverridableDeclaration)element), null, null, (int)3, null);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            IrProperty it = (IrProperty)element$iv;
                            boolean bl2 = false;
                            if (Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB()) && it.getBackingField() != null) continue;
                            bl = false;
                            break block10;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return false;
                }
            }
            if (element instanceof IrSimpleFunction && ((IrSimpleFunction)element).isFakeOverride() && (IrUtilsKt.isStatic((IrFunction)((IrFunction)element)) || JvmIrUtilsKt.hasPlatformDependent((IrFunction)((IrFunction)element)))) {
                return false;
            }
            if (IrTextDumpHandler.Companion.isHiddenDeclaration((IrDeclaration)element, this.irBuiltIns)) {
                return false;
            }
            this.printSignatureAndMangledName(printer, (IrDeclaration)element);
            return true;
        }

        public boolean shouldPrintAnnotation(@NotNull IrConstructorCall annotation, @NotNull IrAnnotationContainer container) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            return !IrMangledNameAndSignatureDumpHandlerKt.access$getEXCLUDED_ANNOTATIONS$p().contains(AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)AdditionalIrUtilsKt.getConstructedClass((IrConstructor)((IrConstructor)annotation.getSymbol().getOwner())))));
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public CustomKotlinLikeDumpStrategy.Modifiers transformModifiersForDeclaration(@NotNull IrDeclaration declaration, @NotNull CustomKotlinLikeDumpStrategy.Modifiers modifiers) {
            block7: {
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
                        v0 = modifiers;
                        if (!(declaration instanceof IrClass) || !((IrClass)declaration).isInner()) ** GOTO lbl-1000
                        var5_3 = declaration.getParent();
                        var9_4 = v0;
                        $i$a$-let-IrMangledNameAndSignatureDumpHandler$DumpStrategy$transformModifiersForDeclaration$1 = false;
                        var10_7 = it instanceof IrClass != false && IrUtilsKt.isEnumEntry((IrClass)((IrClass)it)) != false;
                        v0 = var9_4;
                        if (var10_7) {
                            v1 = DescriptorVisibilities.LOCAL;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = modifiers.getVisibility();
                        }
                        var3_9 = v1;
                        Intrinsics.checkNotNull((Object)var3_9);
                        v2 = var3_9;
                        v3 = false;
                        v4 = null;
                        if (!(declaration instanceof IrPossiblyExternalDeclaration)) break block6;
                        if (((IrPossiblyExternalDeclaration)declaration).isExternal()) ** GOTO lbl-1000
                        var3_9 = IrUtilsKt.getParents((IrDeclaration)declaration);
                        var12_10 = v4;
                        var11_11 = v3;
                        var10_8 = v2;
                        var9_4 = v0;
                        $i$f$any = false;
                        for (E element$iv : $this$any$iv) {
                            it = (IrDeclarationParent)element$iv;
                            $i$a$-any-IrMangledNameAndSignatureDumpHandler$DumpStrategy$transformModifiersForDeclaration$2 = false;
                            if (!(it instanceof IrPossiblyExternalDeclaration != false && ((IrPossiblyExternalDeclaration)it).isExternal() != false)) continue;
                            v5 = true;
                            break block5;
                        }
                        v5 = false;
                    }
                    var13_15 = v5;
                    v0 = var9_4;
                    v2 = var10_8;
                    v3 = var11_11;
                    v4 = var12_10;
                    if (var13_15) lbl-1000:
                    // 2 sources

                    {
                        v6 = true;
                    } else {
                        v6 = false;
                    }
                    break block7;
                }
                v6 = modifiers.isExternal();
            }
            return CustomKotlinLikeDumpStrategy.Modifiers.copy$default((CustomKotlinLikeDumpStrategy.Modifiers)v0, (DescriptorVisibility)v2, (boolean)v3, v4, (boolean)v6, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)0x7FFFF6, null);
        }

        public void didPrintElement(@NotNull IrElement element, @Nullable IrDeclaration container, @NotNull Printer printer) {
            CustomKotlinLikeDumpStrategy.DefaultImpls.didPrintElement((CustomKotlinLikeDumpStrategy)this, (IrElement)element, (IrDeclaration)container, (Printer)printer);
        }

        private static final void printSignatureAndMangledName$printActualMangledNamesAndSignatures(Printer $this_printSignatureAndMangledName, List<ComputedMangledName> fullMangledNames, boolean canDumpMangledNameAndSignaturesComputedByFrontend, List<ComputedMangledName> signatureMangledNames, List<ComputedSignature> signatures, IdSignature signatureComputedFromIr2) {
            IrMangledNameAndSignatureDumpHandlerKt.access$printMangledNames($this_printSignatureAndMangledName, fullMangledNames, "Mangled name");
            if (canDumpMangledNameAndSignaturesComputedByFrontend) {
                boolean bl;
                block6: {
                    Iterable $this$any$iv = signatureMangledNames;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ComputedMangledName it = (ComputedMangledName)element$iv;
                            boolean bl2 = false;
                            String string = it.getValue();
                            IdSignature.CommonSignature commonSignature = signatureComputedFromIr2.asPublic();
                            String string2 = commonSignature != null ? commonSignature.getDescription() : null;
                            if (string2 == null) {
                                string2 = "";
                            }
                            if (!(!Intrinsics.areEqual((Object)string, (Object)string2))) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    IrMangledNameAndSignatureDumpHandlerKt.access$printMangledNames($this_printSignatureAndMangledName, signatureMangledNames, "Mangled name for the signature");
                }
            }
            IrMangledNameAndSignatureDumpHandlerKt.access$printSignatures($this_printSignatureAndMangledName, signatures);
        }

        public static final /* synthetic */ PublicIdSignatureComputer access$getSignatureComposer$p(DumpStrategy $this) {
            return $this.signatureComposer;
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=50)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TargetBackend.values().length];
                try {
                    nArray[TargetBackend.JS_IR.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TargetBackend.NATIVE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

