/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.compiler;

import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.DeclarationDescriptorVisitorEmptyBodies;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

public class ExpectedLoadErrorsUtil {
    public static final String ANNOTATION_CLASS_NAME = "org.jetbrains.kotlin.jvm.compiler.annotation.ExpectLoadError";

    public static void checkForLoadErrors(@NotNull PackageViewDescriptor packageFromJava, @NotNull BindingContext bindingContext, @NotNull Assertions assertions) {
        if (packageFromJava == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(0);
        }
        if (bindingContext == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(1);
        }
        if (assertions == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(2);
        }
        Map<SourceElement, List<String>> expectedErrors = ExpectedLoadErrorsUtil.getExpectedLoadErrors(packageFromJava);
        Map<SourceElement, List<String>> actualErrors = ExpectedLoadErrorsUtil.getActualLoadErrors(bindingContext);
        for (SourceElement source : ContainerUtil.union(expectedErrors.keySet(), actualErrors.keySet())) {
            List<String> actual = actualErrors.get(source);
            List<String> expected2 = expectedErrors.get(source);
            assertions.assertNotNull(expected2, (Function0<String>)((Function0)() -> "Unexpected load error(s):\n" + actual + "\ncontainer:" + source));
            assertions.assertNotNull(actual, (Function0<String>)((Function0)() -> "Missing load error(s):\n" + expected2 + "\ncontainer:" + source));
            assertions.assertSameElements(actual, expected2, (Function0<String>)((Function0)() -> "Unexpected/missing load error(s)\ncontainer:" + source));
        }
    }

    private static Map<SourceElement, List<String>> getExpectedLoadErrors(@NotNull PackageViewDescriptor packageFromJava) {
        if (packageFromJava == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(3);
        }
        final HashMap<SourceElement, List<String>> map = new HashMap<SourceElement, List<String>>();
        packageFromJava.acceptVoid((DeclarationDescriptorVisitor)new DeclarationDescriptorVisitorEmptyBodies<Void, Void>(){

            public Void visitPackageViewDescriptor(PackageViewDescriptor descriptor, Void data) {
                return this.visitDeclarationRecursively((DeclarationDescriptor)descriptor, descriptor.getMemberScope());
            }

            public Void visitClassDescriptor(ClassDescriptor descriptor, Void data) {
                return this.visitDeclarationRecursively((DeclarationDescriptor)descriptor, descriptor.getDefaultType().getMemberScope());
            }

            public Void visitFunctionDescriptor(FunctionDescriptor descriptor, Void data) {
                return this.visitDeclaration((DeclarationDescriptor)descriptor);
            }

            public Void visitPropertyDescriptor(PropertyDescriptor descriptor, Void data) {
                return this.visitDeclaration((DeclarationDescriptor)descriptor);
            }

            private Void visitDeclaration(@NotNull DeclarationDescriptor descriptor) {
                AnnotationDescriptor annotation;
                if (descriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((annotation = descriptor.getAnnotations().findAnnotation(new FqName(ExpectedLoadErrorsUtil.ANNOTATION_CLASS_NAME))) == null) {
                    return null;
                }
                ConstantValue argument = (ConstantValue)annotation.getAllValueArguments().values().iterator().next();
                String error = (String)argument.getValue();
                List<String> errors = Arrays.asList(error.split("\\|"));
                ExpectedLoadErrorsUtil.putError(map, descriptor, errors);
                return null;
            }

            private Void visitDeclarationRecursively(@NotNull DeclarationDescriptor descriptor, @NotNull MemberScope memberScope) {
                if (descriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (memberScope == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (DeclarationDescriptor member : DescriptorUtils.getAllDescriptors((MemberScope)memberScope)) {
                    member.acceptVoid((DeclarationDescriptorVisitor)this);
                }
                return this.visitDeclaration(descriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "memberScope";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/jvm/compiler/ExpectedLoadErrorsUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDeclaration";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDeclarationRecursively";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return map;
    }

    private static Map<SourceElement, List<String>> getActualLoadErrors(@NotNull BindingContext bindingContext) {
        if (bindingContext == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(4);
        }
        HashMap<SourceElement, List<String>> result = new HashMap<SourceElement, List<String>>();
        Collection descriptors = bindingContext.getKeys(JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS);
        for (DeclarationDescriptor descriptor : descriptors) {
            List errors = (List)bindingContext.get((ReadOnlySlice)JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS, (Object)descriptor);
            if (errors == null) continue;
            ExpectedLoadErrorsUtil.putError(result, descriptor, errors);
        }
        return result;
    }

    private static void putError(@NotNull Map<SourceElement, List<String>> result, @NotNull DeclarationDescriptor descriptor, @NotNull List<String> errors) {
        if (result == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(6);
        }
        if (errors == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(7);
        }
        assert (descriptor.getOriginal() instanceof DeclarationDescriptorWithSource) : "Signature errors should be reported only on declarations with source, but " + descriptor + " found";
        result.put(((DeclarationDescriptorWithSource)descriptor.getOriginal()).getSource(), errors);
    }

    private ExpectedLoadErrorsUtil() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFromJava";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/jvm/compiler/ExpectedLoadErrorsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForLoadErrors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpectedLoadErrors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getActualLoadErrors";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "putError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

