/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FirIdenticalCheckerHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H&J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H&J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u000bJ \u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u000bJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/test/utils/FirIdenticalCheckerHelper;", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "getClassicFileToCompare", "Ljava/io/File;", "testDataFile", "getFirFileToCompare", "firAndClassicContentsAreEquals", "", "trimLines", "contentsAreEquals", "classicFile", "firFile", "readContent", "", "file", "addDirectiveToClassicFileAndAssert", "", "deleteFirFile", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nFirIdenticalCheckerHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirIdenticalCheckerHelper.kt\norg/jetbrains/kotlin/test/utils/FirIdenticalCheckerHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public abstract class FirIdenticalCheckerHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestServices testServices;
    private static final boolean isTeamCityBuild = System.getenv("TEAMCITY_VERSION") != null;

    public FirIdenticalCheckerHelper(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
    }

    @Nullable
    public abstract File getClassicFileToCompare(@NotNull File var1);

    @Nullable
    public abstract File getFirFileToCompare(@NotNull File var1);

    public final boolean firAndClassicContentsAreEquals(@NotNull File testDataFile, boolean trimLines) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        File file = this.getClassicFileToCompare(testDataFile);
        if (file == null) {
            return true;
        }
        File classicFile = file;
        File file2 = this.getFirFileToCompare(testDataFile);
        if (file2 == null) {
            return true;
        }
        File firFile = file2;
        return this.contentsAreEquals(classicFile, firFile, trimLines);
    }

    public static /* synthetic */ boolean firAndClassicContentsAreEquals$default(FirIdenticalCheckerHelper firIdenticalCheckerHelper, File file, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: firAndClassicContentsAreEquals");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return firIdenticalCheckerHelper.firAndClassicContentsAreEquals(file, bl);
    }

    public final boolean contentsAreEquals(@NotNull File classicFile, @NotNull File firFile, boolean trimLines) {
        Intrinsics.checkNotNullParameter((Object)classicFile, (String)"classicFile");
        Intrinsics.checkNotNullParameter((Object)firFile, (String)"firFile");
        String classicFileContent = this.readContent(classicFile, trimLines);
        String firFileContent = this.readContent(firFile, trimLines);
        return Intrinsics.areEqual((Object)classicFileContent, (Object)firFileContent);
    }

    public static /* synthetic */ boolean contentsAreEquals$default(FirIdenticalCheckerHelper firIdenticalCheckerHelper, File file, File file2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: contentsAreEquals");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return firIdenticalCheckerHelper.contentsAreEquals(file, file2, bl);
    }

    @NotNull
    public final String readContent(@NotNull File file, boolean trimLines) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return trimLines ? ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)FilesKt.readLines$default((File)file, null, (int)1, null), (CharSequence)"\n", null, null, (int)0, null, (Function1)readContent.1.INSTANCE, (int)30, null))).toString() : FilesKt.readText$default((File)file, null, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDirectiveToClassicFileAndAssert(@NotNull File testDataFile) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        if (!isTeamCityBuild) {
            String classicFileContent = FilesKt.readText$default((File)testDataFile, null, (int)1, null);
            Object object = testDataFile;
            Object object2 = Charsets.UTF_8;
            object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object2);
            object2 = null;
            try {
                OutputStreamWriter it = (OutputStreamWriter)object;
                boolean bl = false;
                Appendable appendable = ((Appendable)it).append("// " + FirDiagnosticsDirectives.INSTANCE.getFIR_IDENTICAL().getName());
                Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
                Writer writer = it.append(classicFileContent);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        String message = isTeamCityBuild ? "Please remove .fir.txt dump and add // FIR_IDENTICAL to test source" : "Deleted .fir.txt dump, added // FIR_IDENTICAL to test source";
        AssertionsKt.getAssertions(this.testServices).fail((Function0<String>)((Function0)new Function0<String>(message){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(0);
            }

            public final String invoke() {
                return StringsKt.trimIndent((String)("\n                    Dumps via FIR & via old FE are the same. \n                    " + this.$message + "\n                    Please re-run the test now\n                "));
            }
        }));
        throw null;
    }

    public final void deleteFirFile(@NotNull File testDataFile) {
        block1: {
            File file;
            File file2;
            Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
            if (isTeamCityBuild || (file2 = this.getFirFileToCompare(testDataFile)) == null) break block1;
            File it = file = file2;
            boolean bl = false;
            file2 = it.exists() ? file : null;
            if (file2 != null) {
                file2.delete();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/utils/FirIdenticalCheckerHelper$Companion;", "", "<init>", "()V", "isTeamCityBuild", "", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

