/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.model;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.backend.classic.ClassicBackendInput;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.model.BackendKind;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/test/model/BackendKinds;", "", "<init>", "()V", "fromString", "Lorg/jetbrains/kotlin/test/model/BackendKind;", "string", "", "fromTargetBackend", "targetBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "ClassicBackend", "IrBackend", "DeserializedIrBackend", "tests-common-new_test"})
public final class BackendKinds {
    @NotNull
    public static final BackendKinds INSTANCE = new BackendKinds();

    private BackendKinds() {
    }

    @Nullable
    public final BackendKind<?> fromString(@NotNull String string) {
        BackendKind backendKind;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        switch (string) {
            case "ClassicBackend": {
                backendKind = ClassicBackend.INSTANCE;
                break;
            }
            case "IrBackend": {
                backendKind = IrBackend.INSTANCE;
                break;
            }
            case "DeserializedIrBackend": {
                backendKind = DeserializedIrBackend.INSTANCE;
                break;
            }
            default: {
                backendKind = null;
            }
        }
        return backendKind;
    }

    @NotNull
    public final BackendKind<?> fromTargetBackend(@Nullable TargetBackend targetBackend) {
        if (targetBackend == null) {
            return BackendKind.NoBackend.INSTANCE;
        }
        return targetBackend.isIR() ? (BackendKind)IrBackend.INSTANCE : (BackendKind)ClassicBackend.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/test/model/BackendKinds$ClassicBackend;", "Lorg/jetbrains/kotlin/test/model/BackendKind;", "Lorg/jetbrains/kotlin/test/backend/classic/ClassicBackendInput;", "<init>", "()V", "tests-common-new_test"})
    public static final class ClassicBackend
    extends BackendKind<ClassicBackendInput> {
        @NotNull
        public static final ClassicBackend INSTANCE = new ClassicBackend();

        private ClassicBackend() {
            super("ClassicBackend");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/test/model/BackendKinds$DeserializedIrBackend;", "Lorg/jetbrains/kotlin/test/model/BackendKind;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "<init>", "()V", "tests-common-new_test"})
    public static final class DeserializedIrBackend
    extends BackendKind<IrBackendInput> {
        @NotNull
        public static final DeserializedIrBackend INSTANCE = new DeserializedIrBackend();

        private DeserializedIrBackend() {
            super("DeserializedIrBackend");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/test/model/BackendKinds$IrBackend;", "Lorg/jetbrains/kotlin/test/model/BackendKind;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "<init>", "()V", "tests-common-new_test"})
    public static final class IrBackend
    extends BackendKind<IrBackendInput> {
        @NotNull
        public static final IrBackend INSTANCE = new IrBackend();

        private IrBackend() {
            super("IrBackend");
        }
    }
}

