/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.jvm.compiler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.test.KtAssert;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.services.configuration.JvmEnvironmentConfigurator;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010\u0010\u001a\u00020\u0005H\u0007J\b\u0010\u0011\u001a\u00020\u0005H\u0007J\b\u0010\u0012\u001a\u00020\u0005H\u0007R\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/test/jvm/compiler/CoreJrtFsTest;", "", "<init>", "()V", "checkClassVersion", "", "expectedVersion", "", "actualClass", "Lcom/intellij/openapi/vfs/VirtualFile;", "testRootDisposable", "Lcom/intellij/openapi/Disposable;", "getTestRootDisposable", "()Lcom/intellij/openapi/Disposable;", "setTestRootDisposable", "(Lcom/intellij/openapi/Disposable;)V", "createRootDisposable", "disposeRootDisposable", "testClassVersionsInJavaLangOfJdk11", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nCoreJrtFsTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreJrtFsTest.kt\norg/jetbrains/kotlin/test/jvm/compiler/CoreJrtFsTest\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n3774#2:78\n4289#2,2:79\n1853#3,2:81\n*S KotlinDebug\n*F\n+ 1 CoreJrtFsTest.kt\norg/jetbrains/kotlin/test/jvm/compiler/CoreJrtFsTest\n*L\n68#1:78\n68#1:79,2\n70#1:81,2\n*E\n"})
public final class CoreJrtFsTest {
    public Disposable testRootDisposable;

    private final void checkClassVersion(int expectedVersion, VirtualFile actualClass) {
        if (actualClass == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        ClassReader reader = new ClassReader(actualClass.contentsToByteArray());
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 1);
        KtAssert.assertEquals("Expected class version(" + expectedVersion + ") differs in " + actualClass.getPath() + " (" + node.version + ')', expectedVersion, node.version);
    }

    @NotNull
    public final Disposable getTestRootDisposable() {
        Disposable disposable = this.testRootDisposable;
        if (disposable != null) {
            return disposable;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"testRootDisposable");
        return null;
    }

    public final void setTestRootDisposable(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"<set-?>");
        this.testRootDisposable = disposable;
    }

    @BeforeEach
    public final void createRootDisposable() {
        this.setTestRootDisposable(CoreJrtFsTest::createRootDisposable$lambda$0);
    }

    @AfterEach
    public final void disposeRootDisposable() {
        Disposer.dispose((Disposable)this.getTestRootDisposable());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void testClassVersionsInJavaLangOfJdk11() {
        void $this$filterTo$iv$iv;
        CompilerConfiguration configuration2 = new CompilerConfiguration();
        File jdkHome = JvmEnvironmentConfigurator.Companion.getJdkHome(TestJdkKind.FULL_JDK_11);
        if (jdkHome == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        configuration2.put(JVMConfigurationKeys.JDK_HOME, (Object)jdkHome);
        KotlinCoreApplicationEnvironment environment = KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForTests(this.getTestRootDisposable(), configuration2);
        VirtualFileSystem virtualFileSystem = environment.getJrtFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException("No jrt-fs configured".toString());
        }
        VirtualFileSystem jrt = virtualFileSystem;
        VirtualFile root = jrt.findFileByPath(jdkHome + "!/modules/java.base/java/lang/");
        if (root == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        VirtualFile[] virtualFileArray = root.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        Object[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter2 = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getExtension(), (Object)"class")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List children = (List)destination$iv$iv;
        boolean bl = $this$filter$iv = !((Collection)children).isEmpty();
        if (_Assertions.ENABLED && !$this$filter$iv) {
            String $i$f$filter2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$filter2);
        }
        Iterable $this$forEach$iv = children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file = (VirtualFile)element$iv;
            boolean bl2 = false;
            this.checkClassVersion(55, file);
        }
    }

    private static final void createRootDisposable$lambda$0() {
    }
}

