/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.ZipUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler;
import org.jetbrains.kotlin.preloading.ClassPreloadingUtils;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.JvmCompilationUtils;
import org.jetbrains.kotlin.test.KtAssert;
import org.jetbrains.kotlin.test.MockLibraryUtil;
import org.jetbrains.kotlin.test.MockLibraryUtilKt;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jn\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\b\b\u0002\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007Jd\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0013\u001a\u00020\rH\u0007Jv\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\b\b\u0002\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J,\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0014\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u0010J\u0014\u0010\u001e\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u0010J\u0014\u0010\u001f\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u0010J\"\u0010 \u001a\u00020\u001c2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0002JA\u0010#\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010$\u001a\u00020\b2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0%\"\u00020\nH\u0007\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\nJ \u00100\u001a\u0006\u0012\u0002\b\u00030\"2\u0012\u0010!\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030201H\u0002J\b\u00103\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010)\u001a\u0006\u0012\u0002\b\u00030\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0018\u0010,\u001a\u0006\u0012\u0002\b\u00030\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010+R\u0018\u0010.\u001a\u0006\u0012\u0002\b\u00030\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010+\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/test/MockLibraryUtil;", "", "<init>", "()V", "compilerClassLoader", "Ljava/lang/ref/SoftReference;", "Ljava/lang/ClassLoader;", "compileJvmLibraryToJar", "Ljava/io/File;", "sourcesPath", "", "jarName", "addSources", "", "allowKotlinSources", "extraOptions", "", "extraClasspath", "extraModulepath", "useJava11", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "compileJavaFilesLibraryToJar", "compileLibraryToJar", "contentDir", "createJarFile", "dirToAdd", "runJvmCompiler", "", "args", "runJsCompiler", "runMetadataCompiler", "runCompiler", "compilerClass", "Ljava/lang/Class;", "compileKotlin", "outDir", "", "(Ljava/lang/String;Ljava/io/File;Ljava/util/List;[Ljava/lang/String;)V", "compileKotlinModule", "buildFilePath", "compiler2JVMClass", "getCompiler2JVMClass", "()Ljava/lang/Class;", "compiler2JSClass", "getCompiler2JSClass", "compiler2MetadataClass", "getCompiler2MetadataClass", "loadCompilerClass", "Lkotlin/reflect/KClass;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "createCompilerClassLoader", "tests-compiler-utils_test"})
@SourceDebugExtension(value={"SMAP\nMockLibraryUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockLibraryUtil.kt\norg/jetbrains/kotlin/test/MockLibraryUtil\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n37#2,2:236\n37#2,2:239\n1#3:238\n*S KotlinDebug\n*F\n+ 1 MockLibraryUtil.kt\norg/jetbrains/kotlin/test/MockLibraryUtil\n*L\n107#1:236,2\n179#1:239,2\n*E\n"})
public final class MockLibraryUtil {
    @NotNull
    public static final MockLibraryUtil INSTANCE = new MockLibraryUtil();
    @NotNull
    private static SoftReference<ClassLoader> compilerClassLoader = new SoftReference<Object>(null);

    private MockLibraryUtil() {
    }

    @JvmStatic
    @NotNull
    public static final File compileJvmLibraryToJar(@NotNull String sourcesPath, @NotNull String jarName, boolean addSources, boolean allowKotlinSources, @NotNull List<String> extraOptions, @NotNull List<String> extraClasspath, @NotNull List<String> extraModulepath, boolean useJava11, @NotNull Assertions assertions) {
        Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkNotNullParameter((Object)jarName, (String)"jarName");
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        Intrinsics.checkNotNullParameter(extraClasspath, (String)"extraClasspath");
        Intrinsics.checkNotNullParameter(extraModulepath, (String)"extraModulepath");
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        File file = KtTestUtil.tmpDirForReusableFolder("testLibrary-" + jarName);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tmpDirForReusableFolder(...)");
        return MockLibraryUtil.compileLibraryToJar(sourcesPath, file, jarName, addSources, allowKotlinSources, extraOptions, extraClasspath, extraModulepath, useJava11, assertions);
    }

    public static /* synthetic */ File compileJvmLibraryToJar$default(String string, String string2, boolean bl, boolean bl2, List list, List list2, List list3, boolean bl3, Assertions assertions, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        return MockLibraryUtil.compileJvmLibraryToJar(string, string2, bl, bl2, list, list2, list3, bl3, assertions);
    }

    @JvmStatic
    @NotNull
    public static final File compileJavaFilesLibraryToJar(@NotNull String sourcesPath, @NotNull String jarName, boolean addSources, @NotNull List<String> extraOptions, @NotNull List<String> extraClasspath, @NotNull List<String> extraModulepath, @NotNull Assertions assertions, boolean useJava11) {
        Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkNotNullParameter((Object)jarName, (String)"jarName");
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        Intrinsics.checkNotNullParameter(extraClasspath, (String)"extraClasspath");
        Intrinsics.checkNotNullParameter(extraModulepath, (String)"extraModulepath");
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        return MockLibraryUtil.compileJvmLibraryToJar(sourcesPath, jarName, addSources, false, extraOptions, extraClasspath, extraModulepath, useJava11, assertions);
    }

    public static /* synthetic */ File compileJavaFilesLibraryToJar$default(String string, String string2, boolean bl, List list, List list2, List list3, Assertions assertions, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            bl2 = false;
        }
        return MockLibraryUtil.compileJavaFilesLibraryToJar(string, string2, bl, list, list2, list3, assertions, bl2);
    }

    @JvmStatic
    @NotNull
    public static final File compileLibraryToJar(@NotNull String sourcesPath, @NotNull File contentDir, @NotNull String jarName, boolean addSources, boolean allowKotlinSources, @NotNull List<String> extraOptions, @NotNull List<String> extraClasspath, @NotNull List<String> extraModulepath, boolean useJava11, @NotNull Assertions assertions) {
        String string;
        Collection thisCollection$iv;
        Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkNotNullParameter((Object)contentDir, (String)"contentDir");
        Intrinsics.checkNotNullParameter((Object)jarName, (String)"jarName");
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        Intrinsics.checkNotNullParameter(extraClasspath, (String)"extraClasspath");
        Intrinsics.checkNotNullParameter(extraModulepath, (String)"extraModulepath");
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        KtAssert.assertTrue("Module path can be used only for compilation using javac 9 and higher", useJava11 || extraModulepath.isEmpty());
        File classesDir = new File(contentDir, "classes");
        File srcFile = new File(sourcesPath);
        List list = FileUtil.findFilesByMask((Pattern)Pattern.compile(".*\\.kt"), (File)srcFile);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findFilesByMask(...)");
        List kotlinFiles = list;
        if (srcFile.isFile() || !((Collection)kotlinFiles).isEmpty()) {
            KtAssert.assertTrue("Only java files are expected", allowKotlinSources);
            Collection $this$toTypedArray$iv = extraClasspath;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            MockLibraryUtil.compileKotlin(sourcesPath, classesDir, extraOptions, Arrays.copyOf(stringArray, stringArray.length));
        }
        List list2 = FileUtil.findFilesByMask((Pattern)Pattern.compile(".*\\.java"), (File)srcFile);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"findFilesByMask(...)");
        List javaFiles = list2;
        if (!((Collection)javaFiles).isEmpty()) {
            List classpath = new ArrayList();
            ((Collection)classpath).add(MockLibraryUtilKt.getKotlinPathsForDistDirectoryForTests(PathUtil.INSTANCE).getStdlibPath().getPath());
            CollectionsKt.addAll((Collection)classpath, (Iterable)extraClasspath);
            if (classesDir.exists()) {
                ((Collection)classpath).add(classesDir.getPath());
            } else {
                FileUtil.createDirectory((File)classesDir);
            }
            Collection $this$compileLibraryToJar_u24lambda_u240 = thisCollection$iv = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$compileLibraryToJar_u24lambda_u240.add("-classpath");
            Iterable iterable = classpath;
            String string2 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathSeparator");
            $this$compileLibraryToJar_u24lambda_u240.add(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null));
            $this$compileLibraryToJar_u24lambda_u240.add("-d");
            String string3 = classesDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            $this$compileLibraryToJar_u24lambda_u240.add(string3);
            if (useJava11 && !((Collection)extraModulepath).isEmpty()) {
                $this$compileLibraryToJar_u24lambda_u240.add("--module-path");
                Iterable iterable2 = extraModulepath;
                String string4 = File.pathSeparator;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"pathSeparator");
                $this$compileLibraryToJar_u24lambda_u240.add(CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string4, null, null, (int)0, null, null, (int)62, null));
            }
            List options = CollectionsKt.build((List)thisCollection$iv);
            Function2 compile2 = useJava11 ? (Function2)compileLibraryToJar.compile.1.INSTANCE : (Function2)new Function2<Collection<? extends File>, List<? extends String>, Boolean>(assertions){
                final /* synthetic */ Assertions $assertions;
                {
                    this.$assertions = $assertions;
                    super(2);
                }

                public final Boolean invoke(Collection<? extends File> files, List<String> opts) {
                    Intrinsics.checkNotNullParameter(files, (String)"files");
                    Intrinsics.checkNotNullParameter(opts, (String)"opts");
                    return JvmCompilationUtils.compileJavaFiles$default(files, opts, null, this.$assertions, false, 20, null);
                }
            };
            boolean success = (Boolean)compile2.invoke((Object)javaFiles, (Object)options);
            if (!success) {
                throw new AssertionError((Object)"Java files are not compiled successfully");
            }
        }
        String options = string = sourcesPath;
        String string5 = jarName;
        File file = classesDir;
        File file2 = contentDir;
        boolean bl = false;
        boolean bl2 = addSources;
        return MockLibraryUtil.createJarFile(file2, file, string5, bl2 ? string : null);
    }

    public static /* synthetic */ File compileLibraryToJar$default(String string, File file, String string2, boolean bl, boolean bl2, List list, List list2, List list3, boolean bl3, Assertions assertions, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x100) != 0) {
            bl3 = false;
        }
        return MockLibraryUtil.compileLibraryToJar(string, file, string2, bl, bl2, list, list2, list3, bl3, assertions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final File createJarFile(@NotNull File contentDir, @NotNull File dirToAdd, @NotNull String jarName, @Nullable String sourcesPath) {
        Intrinsics.checkNotNullParameter((Object)contentDir, (String)"contentDir");
        Intrinsics.checkNotNullParameter((Object)dirToAdd, (String)"dirToAdd");
        Intrinsics.checkNotNullParameter((Object)jarName, (String)"jarName");
        File jarFile = new File(contentDir, jarName + ".jar");
        Closeable closeable = new ZipOutputStream(new FileOutputStream(jarFile));
        Throwable throwable = null;
        try {
            ZipOutputStream zip = (ZipOutputStream)closeable;
            boolean bl = false;
            ZipUtil.addDirToZipRecursively((ZipOutputStream)zip, (File)jarFile, (File)dirToAdd, (String)"", null, null);
            if (sourcesPath != null) {
                ZipUtil.addDirToZipRecursively((ZipOutputStream)zip, (File)jarFile, (File)new File(sourcesPath), (String)"src", null, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return jarFile;
    }

    public static /* synthetic */ File createJarFile$default(File file, File file2, String string, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        return MockLibraryUtil.createJarFile(file, file2, string, string2);
    }

    public final void runJvmCompiler(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.runCompiler(this.getCompiler2JVMClass(), args);
    }

    public final void runJsCompiler(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.runCompiler(this.getCompiler2JSClass(), args);
    }

    public final void runMetadataCompiler(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.runCompiler(this.getCompiler2MetadataClass(), args);
    }

    private final void runCompiler(Class<?> compilerClass, List<String> args) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Object compiler = compilerClass.newInstance();
        Class[] classArray = new Class[]{PrintStream.class, String[].class};
        Method execMethod = compilerClass.getMethod("exec", classArray);
        Object[] objectArray = new Object[2];
        objectArray[0] = new PrintStream(outStream);
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray[1] = thisCollection$iv.toArray(new String[0]);
        Object object = execMethod.invoke(compiler, objectArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Enum<*>");
        Enum invocationResult = (Enum)object;
        byte[] byArray = outStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] byArray2 = byArray;
        KtAssert.assertEquals(new String(byArray2, Charsets.UTF_8), "OK", invocationResult.name());
    }

    @JvmStatic
    @JvmOverloads
    public static final void compileKotlin(@NotNull String sourcesPath, @NotNull File outDir, @NotNull List<String> extraOptions, String ... extraClasspath) {
        Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkNotNullParameter((Object)outDir, (String)"outDir");
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        Intrinsics.checkNotNullParameter((Object)extraClasspath, (String)"extraClasspath");
        List classpath = new ArrayList();
        if (new File(sourcesPath).isDirectory()) {
            ((Collection)classpath).add(sourcesPath);
        }
        CollectionsKt.addAll((Collection)classpath, (Object[])extraClasspath);
        Object[] objectArray = new String[5];
        objectArray[0] = sourcesPath;
        objectArray[1] = "-d";
        objectArray[2] = outDir.getAbsolutePath();
        objectArray[3] = "-classpath";
        Iterable iterable = classpath;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        objectArray[4] = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
        List args = CollectionsKt.plus((Collection)CollectionsKt.mutableListOf((Object[])objectArray), (Iterable)extraOptions);
        INSTANCE.runJvmCompiler(args);
    }

    public static /* synthetic */ void compileKotlin$default(String string, File file, List list, String[] stringArray, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        MockLibraryUtil.compileKotlin(string, file, list, stringArray);
    }

    public final void compileKotlinModule(@NotNull String buildFilePath) {
        Intrinsics.checkNotNullParameter((Object)buildFilePath, (String)"buildFilePath");
        Object[] objectArray = new String[]{"-no-stdlib", "-Xbuild-file", buildFilePath};
        this.runJvmCompiler(CollectionsKt.listOf((Object[])objectArray));
    }

    private final synchronized Class<?> getCompiler2JVMClass() {
        return this.loadCompilerClass(Reflection.getOrCreateKotlinClass(K2JVMCompiler.class));
    }

    private final synchronized Class<?> getCompiler2JSClass() {
        return this.loadCompilerClass(Reflection.getOrCreateKotlinClass(K2JSCompiler.class));
    }

    private final synchronized Class<?> getCompiler2MetadataClass() {
        return this.loadCompilerClass(Reflection.getOrCreateKotlinClass(K2MetadataCompiler.class));
    }

    private final synchronized Class<?> loadCompilerClass(KClass<? extends CLICompiler<?>> compilerClass) {
        ClassLoader classLoader = compilerClassLoader.get();
        if (classLoader == null) {
            ClassLoader classLoader2;
            ClassLoader classLoader3 = classLoader2 = this.createCompilerClassLoader();
            boolean bl = false;
            compilerClassLoader = new SoftReference<ClassLoader>(classLoader3);
            classLoader = classLoader2;
        }
        ClassLoader classLoader4 = classLoader;
        Class<?> clazz = classLoader4.loadClass(JvmClassMappingKt.getJavaClass(compilerClass).getName());
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(...)");
        return clazz;
    }

    private final synchronized ClassLoader createCompilerClassLoader() {
        ClassLoader classLoader = ClassPreloadingUtils.preloadClasses((Collection)CollectionsKt.listOf((Object)MockLibraryUtilKt.getKotlinPathsForDistDirectoryForTests(PathUtil.INSTANCE).getCompilerPath()), (int)4096, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"preloadClasses(...)");
        return classLoader;
    }

    @JvmStatic
    @JvmOverloads
    public static final void compileKotlin(@NotNull String sourcesPath, @NotNull File outDir, String ... extraClasspath) {
        Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkNotNullParameter((Object)outDir, (String)"outDir");
        Intrinsics.checkNotNullParameter((Object)extraClasspath, (String)"extraClasspath");
        MockLibraryUtil.compileKotlin$default(sourcesPath, outDir, null, extraClasspath, 4, null);
    }
}

