/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.AbstractKtDiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryForDeprecation;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryToRendererMap;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithParameters1Renderer;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithParameters2Renderer;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithParameters3Renderer;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithParameters4Renderer;
import org.junit.Assert;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"verifyMessages", "", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactoryToRendererMap;", "objectWithErrors", "", "messageParameterRegex", "Lkotlin/text/Regex;", "verifyMessageForFactory", "", "", "factory", "Lorg/jetbrains/kotlin/diagnostics/AbstractKtDiagnosticFactory;", "property", "Lkotlin/reflect/KProperty;", "tests-common-new_test"})
public final class FirErrorsDefaultMessagesHelperKt {
    @NotNull
    private static final Regex messageParameterRegex = new Regex("\\{\\d.*?}");

    public static final void verifyMessages(@NotNull KtDiagnosticFactoryToRendererMap $this$verifyMessages, @NotNull Object objectWithErrors) {
        Intrinsics.checkNotNullParameter((Object)$this$verifyMessages, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)objectWithErrors, (String)"objectWithErrors");
        List errors = new ArrayList();
        for (KProperty1 property : KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(objectWithErrors.getClass()))) {
            Object[] objectArray = new Object[]{objectWithErrors};
            Object factory = property.getGetter().call(objectArray);
            if (factory instanceof AbstractKtDiagnosticFactory) {
                CollectionsKt.addAll((Collection)errors, (Iterable)FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory($this$verifyMessages, (AbstractKtDiagnosticFactory)factory, (KProperty)property));
                continue;
            }
            if (!(factory instanceof KtDiagnosticFactoryForDeprecation)) continue;
            CollectionsKt.addAll((Collection)errors, (Iterable)FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory($this$verifyMessages, ((KtDiagnosticFactoryForDeprecation)factory).getWarningFactory(), (KProperty)property));
            CollectionsKt.addAll((Collection)errors, (Iterable)FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory($this$verifyMessages, ((KtDiagnosticFactoryForDeprecation)factory).getErrorFactory(), (KProperty)property));
        }
        if (!((Collection)errors).isEmpty()) {
            Assert.fail((String)CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", (CharSequence)"\n", null, (int)0, null, null, (int)60, null));
        }
    }

    @NotNull
    public static final List<String> verifyMessageForFactory(@NotNull KtDiagnosticFactoryToRendererMap $this$verifyMessageForFactory, @NotNull AbstractKtDiagnosticFactory factory, @NotNull KProperty<?> property) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$verifyMessageForFactory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        List $this$verifyMessageForFactory_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (!$this$verifyMessageForFactory.containsKey(factory)) {
            $this$verifyMessageForFactory_u24lambda_u240.add("No default diagnostic renderer is provided for " + property.getName());
        }
        KtDiagnosticRenderer ktDiagnosticRenderer = $this$verifyMessageForFactory.get(factory);
        Intrinsics.checkNotNull((Object)ktDiagnosticRenderer);
        KtDiagnosticRenderer renderer = ktDiagnosticRenderer;
        Object object = renderer;
        int parameterCount = object instanceof KtDiagnosticWithParameters4Renderer ? 4 : (object instanceof KtDiagnosticWithParameters3Renderer ? 3 : (object instanceof KtDiagnosticWithParameters2Renderer ? 2 : (object instanceof KtDiagnosticWithParameters1Renderer ? 1 : 0)));
        object = Regex.findAll$default((Regex)messageParameterRegex, (CharSequence)renderer.getMessage(), (int)0, (int)2, null).iterator();
        while (object.hasNext()) {
            MatchResult parameter = (MatchResult)object.next();
            String string = parameter.getValue().substring(1, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            int index = Integer.parseInt(string);
            if (index < parameterCount) continue;
            $this$verifyMessageForFactory_u24lambda_u240.add("Message for " + property.getName() + " references wrong parameter {" + index + '}');
        }
        if (parameterCount > 0 && new Regex("(?<!')'(?!')").containsMatchIn((CharSequence)(object = (CharSequence)renderer.getMessage()))) {
            $this$verifyMessageForFactory_u24lambda_u240.add("Renderer for " + property.getName() + " has parameters and contains single quote. Text inside single quotes is not formatted in MessageFormat. Use double quote instead.");
        }
        if (parameterCount == 0 && new Regex("(?<!')''(?!')").containsMatchIn((CharSequence)(object = (CharSequence)renderer.getMessage()))) {
            $this$verifyMessageForFactory_u24lambda_u240.add("Renderer for " + property.getName() + " has no parameters and contains double quote. Single quote should be used.");
        }
        return CollectionsKt.build((List)list);
    }
}

