/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.configuration;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.mock.MockProject;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.ExternalAnnotationsManagerForTests;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/ExternalAnnotationsEnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "legacyRegisterCompilerExtensions", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "tests-common-new_test"})
public final class ExternalAnnotationsEnvironmentConfigurator
extends EnvironmentConfigurator {
    public ExternalAnnotationsEnvironmentConfigurator(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    public void legacyRegisterCompilerExtensions(@NotNull Project project, @NotNull TestModule module, @NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        boolean hasAnnotationFile = false;
        for (TestFile file : module.getFiles()) {
            if (!Intrinsics.areEqual((Object)file.getName(), (Object)"annotations.xml")) continue;
            SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getRealFileForSourceFile(file);
            hasAnnotationFile = true;
        }
        if (!hasAnnotationFile) {
            return;
        }
        ((MockProject)project).getPicoContainer().unregisterComponent((Object)ExternalAnnotationsManager.class.getName());
        MockProject mockProject = (MockProject)project;
        String string = SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getAdditionalFilesDirectory().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        mockProject.registerService(ExternalAnnotationsManager.class, (Object)new ExternalAnnotationsManagerForTests(string, psiManager));
    }
}

