/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.services.SourceFilePreprocessor;
import org.jetbrains.kotlin.test.services.SourceFileProvider;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001eH\u0016J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u001eH\u0016J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u001eH\u0016J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0014\u0010\u0010R\u001b\u0010\u0016\u001a\u00020\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0012\u001a\u0004\b\u0017\u0010\u0010R\u001b\u0010\u0019\u001a\u00020\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0012\u001a\u0004\b\u001a\u0010\u0010R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u000e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/test/services/SourceFileProviderImpl;", "Lorg/jetbrains/kotlin/test/services/SourceFileProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "preprocessors", "", "Lorg/jetbrains/kotlin/test/services/SourceFilePreprocessor;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Ljava/util/List;)V", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "getPreprocessors", "()Ljava/util/List;", "kotlinSourceDirectory", "Ljava/io/File;", "getKotlinSourceDirectory", "()Ljava/io/File;", "kotlinSourceDirectory$delegate", "Lkotlin/Lazy;", "javaSourceDirectory", "getJavaSourceDirectory", "javaSourceDirectory$delegate", "javaBinaryDirectory", "getJavaBinaryDirectory", "javaBinaryDirectory$delegate", "additionalFilesDirectory", "getAdditionalFilesDirectory", "additionalFilesDirectory$delegate", "contentOfFiles", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "", "realFileMap", "getContentOfSourceFile", "testFile", "getRealFileForSourceFile", "getRealFileForBinaryFile", "generateFinalContent", "test-infrastructure_test"})
@SourceDebugExtension(value={"SMAP\nSourceFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceFileProvider.kt\norg/jetbrains/kotlin/test/services/SourceFileProviderImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n372#2,7:150\n372#2,7:157\n372#2,7:164\n1789#3,3:171\n*S KotlinDebug\n*F\n+ 1 SourceFileProvider.kt\norg/jetbrains/kotlin/test/services/SourceFileProviderImpl\n*L\n52#1:150,7\n58#1:157,7\n72#1:164,7\n85#1:171,3\n*E\n"})
public final class SourceFileProviderImpl
extends SourceFileProvider {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final List<SourceFilePreprocessor> preprocessors;
    @NotNull
    private final Lazy kotlinSourceDirectory$delegate;
    @NotNull
    private final Lazy javaSourceDirectory$delegate;
    @NotNull
    private final Lazy javaBinaryDirectory$delegate;
    @NotNull
    private final Lazy additionalFilesDirectory$delegate;
    @NotNull
    private final Map<TestFile, String> contentOfFiles;
    @NotNull
    private final Map<TestFile, File> realFileMap;

    public SourceFileProviderImpl(@NotNull TestServices testServices, @NotNull List<? extends SourceFilePreprocessor> preprocessors) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(preprocessors, (String)"preprocessors");
        this.testServices = testServices;
        this.preprocessors = preprocessors;
        this.kotlinSourceDirectory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ SourceFileProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final File invoke() {
                return TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.this$0.getTestServices(), "kotlin-files");
            }
        }));
        this.javaSourceDirectory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ SourceFileProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final File invoke() {
                return TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.this$0.getTestServices(), "java-files");
            }
        }));
        this.javaBinaryDirectory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ SourceFileProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final File invoke() {
                return TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.this$0.getTestServices(), "java-binary-files");
            }
        }));
        this.additionalFilesDirectory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ SourceFileProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final File invoke() {
                return TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.this$0.getTestServices(), "additional-files");
            }
        }));
        this.contentOfFiles = new LinkedHashMap();
        this.realFileMap = new LinkedHashMap();
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    @Override
    @NotNull
    public List<SourceFilePreprocessor> getPreprocessors() {
        return this.preprocessors;
    }

    @Override
    @NotNull
    public File getKotlinSourceDirectory() {
        Lazy lazy = this.kotlinSourceDirectory$delegate;
        return (File)lazy.getValue();
    }

    @Override
    @NotNull
    public File getJavaSourceDirectory() {
        Lazy lazy = this.javaSourceDirectory$delegate;
        return (File)lazy.getValue();
    }

    @Override
    @NotNull
    public File getJavaBinaryDirectory() {
        Lazy lazy = this.javaBinaryDirectory$delegate;
        return (File)lazy.getValue();
    }

    @Override
    @NotNull
    public File getAdditionalFilesDirectory() {
        Lazy lazy = this.additionalFilesDirectory$delegate;
        return (File)lazy.getValue();
    }

    @Override
    @NotNull
    public String getContentOfSourceFile(@NotNull TestFile testFile) {
        String string;
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        Map<TestFile, String> $this$getOrPut$iv = this.contentOfFiles;
        boolean $i$f$getOrPut = false;
        String value$iv = $this$getOrPut$iv.get(testFile);
        if (value$iv == null) {
            boolean bl = false;
            String answer$iv = this.generateFinalContent(testFile);
            $this$getOrPut$iv.put(testFile, answer$iv);
            string = answer$iv;
        } else {
            string = value$iv;
        }
        return string;
    }

    @Override
    @NotNull
    public File getRealFileForSourceFile(@NotNull TestFile testFile) {
        File file;
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        Map<TestFile, File> $this$getOrPut$iv = this.realFileMap;
        boolean $i$f$getOrPut = false;
        File value$iv = $this$getOrPut$iv.get(testFile);
        if (value$iv == null) {
            File file2;
            boolean bl = false;
            File directory = SourceFileProviderKt.isKtFile(testFile) ? this.getKotlinSourceDirectory() : (SourceFileProviderKt.isJavaFile(testFile) ? this.getJavaSourceDirectory() : this.getAdditionalFilesDirectory());
            File it = file2 = FilesKt.resolve((File)directory, (String)testFile.getRelativePath());
            boolean bl2 = false;
            it.getParentFile().mkdirs();
            FilesKt.writeText$default((File)it, (String)this.getContentOfSourceFile(testFile), null, (int)2, null);
            File answer$iv = file2;
            $this$getOrPut$iv.put(testFile, answer$iv);
            file = answer$iv;
        } else {
            file = value$iv;
        }
        return file;
    }

    @Override
    @NotNull
    public File getRealFileForBinaryFile(@NotNull TestFile testFile) {
        File file;
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        Map<TestFile, File> $this$getOrPut$iv = this.realFileMap;
        boolean $i$f$getOrPut = false;
        File value$iv = $this$getOrPut$iv.get(testFile);
        if (value$iv == null) {
            File file2;
            boolean bl = false;
            if (!SourceFileProviderKt.isJavaFile(testFile)) {
                throw new IllegalStateException(("Unknown file type: " + testFile.getName()).toString());
            }
            File directory = this.getJavaBinaryDirectory();
            File it = file2 = FilesKt.resolve((File)directory, (String)testFile.getRelativePath());
            boolean bl2 = false;
            it.getParentFile().mkdirs();
            FilesKt.writeText$default((File)it, (String)this.getContentOfSourceFile(testFile), null, (int)2, null);
            File answer$iv = file2;
            $this$getOrPut$iv.put(testFile, answer$iv);
            file = answer$iv;
        } else {
            file = value$iv;
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private final String generateFinalContent(TestFile testFile) {
        void $this$fold$iv;
        Iterable iterable = this.getPreprocessors();
        String initial$iv = testFile.getOriginalContent();
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void preprocessor;
            SourceFilePreprocessor sourceFilePreprocessor = (SourceFilePreprocessor)element$iv;
            String content = accumulator$iv;
            boolean bl = false;
            accumulator$iv = preprocessor.process(testFile, content);
        }
        return accumulator$iv;
    }
}

