/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestInfrastructureInternals;
import org.jetbrains.kotlin.test.model.BackendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.ModuleStructureTransformer;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.impl.TestModuleStructureImpl;

@TestInfrastructureInternals
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/test/services/ModuleTransformerForSwitchingBackend;", "Lorg/jetbrains/kotlin/test/services/ModuleStructureTransformer;", "backendForLib", "Lorg/jetbrains/kotlin/test/TargetBackend;", "backendForMain", "<init>", "(Lorg/jetbrains/kotlin/test/TargetBackend;Lorg/jetbrains/kotlin/test/TargetBackend;)V", "getBackendForLib", "()Lorg/jetbrains/kotlin/test/TargetBackend;", "getBackendForMain", "transformModuleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "moduleStructure", "tests-common-new_test"})
public final class ModuleTransformerForSwitchingBackend
extends ModuleStructureTransformer {
    @NotNull
    private final TargetBackend backendForLib;
    @NotNull
    private final TargetBackend backendForMain;

    public ModuleTransformerForSwitchingBackend(@NotNull TargetBackend backendForLib, @NotNull TargetBackend backendForMain) {
        Intrinsics.checkNotNullParameter((Object)((Object)backendForLib), (String)"backendForLib");
        Intrinsics.checkNotNullParameter((Object)((Object)backendForMain), (String)"backendForMain");
        this.backendForLib = backendForLib;
        this.backendForMain = backendForMain;
    }

    @NotNull
    public final TargetBackend getBackendForLib() {
        return this.backendForLib;
    }

    @NotNull
    public final TargetBackend getBackendForMain() {
        return this.backendForMain;
    }

    @Override
    @NotNull
    public TestModuleStructure transformModuleStructure(@NotNull TestModuleStructure moduleStructure) {
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        if (moduleStructure.getModules().size() != 2) {
            throw new IllegalStateException("Test should contain only one module".toString());
        }
        List<TestModule> list = moduleStructure.getModules();
        TestModule first = list.get(0);
        TestModule second = list.get(1);
        Object[] objectArray = new TestModule[]{TestModule.copy$default(first, null, null, this.backendForLib, null, BackendKinds.INSTANCE.fromTargetBackend(this.backendForLib), null, null, null, null, null, 1003, null), TestModule.copy$default(second, null, null, this.backendForMain, null, BackendKinds.INSTANCE.fromTargetBackend(this.backendForMain), null, null, null, null, null, 1003, null)};
        return new TestModuleStructureImpl(CollectionsKt.listOf((Object[])objectArray), moduleStructure.getOriginalTestDataFiles());
    }
}

