/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.test.directives.DiagnosticsDirectives;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/test/services/DiagnosticsService;", "Lorg/jetbrains/kotlin/test/services/TestService;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "conditionsPerModule", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Lorg/jetbrains/kotlin/test/services/DiagnosticsService$DiagnosticConditions;", "shouldRenderDiagnostic", "", "module", "name", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "computeDiagnosticConditionForModule", "Companion", "DiagnosticConditions", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nDiagnosticsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticsService.kt\norg/jetbrains/kotlin/test/services/DiagnosticsService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,73:1\n372#2,7:74\n*S KotlinDebug\n*F\n+ 1 DiagnosticsService.kt\norg/jetbrains/kotlin/test/services/DiagnosticsService\n*L\n31#1:74,7\n*E\n"})
public final class DiagnosticsService
implements TestService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final Map<TestModule, DiagnosticConditions> conditionsPerModule;
    @NotNull
    private static final Map<String, Severity> severityNameMapping;

    public DiagnosticsService(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
        this.conditionsPerModule = new LinkedHashMap();
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    public final boolean shouldRenderDiagnostic(@NotNull TestModule module, @NotNull String name2, @NotNull Severity severity) {
        DiagnosticConditions conditions;
        boolean severityAllowed;
        DiagnosticConditions diagnosticConditions;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Map<TestModule, DiagnosticConditions> $this$getOrPut$iv = this.conditionsPerModule;
        boolean $i$f$getOrPut = false;
        DiagnosticConditions value$iv = $this$getOrPut$iv.get(module);
        if (value$iv == null) {
            boolean bl = false;
            DiagnosticConditions answer$iv = this.computeDiagnosticConditionForModule(module);
            $this$getOrPut$iv.put(module, answer$iv);
            diagnosticConditions = answer$iv;
        } else {
            diagnosticConditions = value$iv;
        }
        return (severityAllowed = (conditions = diagnosticConditions).getSeverityMap().getOrDefault(severity, true).booleanValue()) ? !conditions.getDisabledDiagnostics().contains(name2) || conditions.getAllowedDiagnostics().contains(name2) : conditions.getAllowedDiagnostics().contains(name2);
    }

    private final DiagnosticConditions computeDiagnosticConditionForModule(TestModule module) {
        List<String> diagnosticsInDirective = module.getDirectives().get(DiagnosticsDirectives.INSTANCE.getDIAGNOSTICS());
        Set enabledNames = new LinkedHashSet();
        Set disabledNames = new LinkedHashSet();
        Map severityMap = new LinkedHashMap();
        for (String diagnosticInDirective : diagnosticsInDirective) {
            String name2;
            boolean bl;
            if (StringsKt.startsWith$default((String)diagnosticInDirective, (String)"+", (boolean)false, (int)2, null)) {
                bl = true;
            } else if (StringsKt.startsWith$default((String)diagnosticInDirective, (String)"-", (boolean)false, (int)2, null)) {
                bl = false;
            } else {
                throw new IllegalStateException(("Incorrect diagnostics directive syntax. See reference:\n" + DiagnosticsDirectives.INSTANCE.getDIAGNOSTICS().getDescription()).toString());
            }
            boolean enabled = bl;
            Intrinsics.checkNotNullExpressionValue((Object)diagnosticInDirective.substring(1), (String)"substring(...)");
            Severity severity = severityNameMapping.get(name2);
            if (severity != null) {
                Boolean bl2 = enabled;
                severityMap.put(severity, bl2);
                continue;
            }
            Set collection = enabled ? enabledNames : disabledNames;
            ((Collection)collection).add(name2);
        }
        return new DiagnosticConditions(enabledNames, disabledNames, severityMap);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"infos", (Object)Severity.INFO), TuplesKt.to((Object)"warnings", (Object)Severity.WARNING), TuplesKt.to((Object)"errors", (Object)Severity.ERROR)};
        severityNameMapping = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/test/services/DiagnosticsService$Companion;", "", "<init>", "()V", "severityNameMapping", "", "", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J?\u0010\u0014\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/test/services/DiagnosticsService$DiagnosticConditions;", "", "allowedDiagnostics", "", "", "disabledDiagnostics", "severityMap", "", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "", "<init>", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;)V", "getAllowedDiagnostics", "()Ljava/util/Set;", "getDisabledDiagnostics", "getSeverityMap", "()Ljava/util/Map;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "tests-common-new_test"})
    private static final class DiagnosticConditions {
        @NotNull
        private final Set<String> allowedDiagnostics;
        @NotNull
        private final Set<String> disabledDiagnostics;
        @NotNull
        private final Map<Severity, Boolean> severityMap;

        public DiagnosticConditions(@NotNull Set<String> allowedDiagnostics, @NotNull Set<String> disabledDiagnostics, @NotNull Map<Severity, Boolean> severityMap) {
            Intrinsics.checkNotNullParameter(allowedDiagnostics, (String)"allowedDiagnostics");
            Intrinsics.checkNotNullParameter(disabledDiagnostics, (String)"disabledDiagnostics");
            Intrinsics.checkNotNullParameter(severityMap, (String)"severityMap");
            this.allowedDiagnostics = allowedDiagnostics;
            this.disabledDiagnostics = disabledDiagnostics;
            this.severityMap = severityMap;
        }

        @NotNull
        public final Set<String> getAllowedDiagnostics() {
            return this.allowedDiagnostics;
        }

        @NotNull
        public final Set<String> getDisabledDiagnostics() {
            return this.disabledDiagnostics;
        }

        @NotNull
        public final Map<Severity, Boolean> getSeverityMap() {
            return this.severityMap;
        }

        @NotNull
        public final Set<String> component1() {
            return this.allowedDiagnostics;
        }

        @NotNull
        public final Set<String> component2() {
            return this.disabledDiagnostics;
        }

        @NotNull
        public final Map<Severity, Boolean> component3() {
            return this.severityMap;
        }

        @NotNull
        public final DiagnosticConditions copy(@NotNull Set<String> allowedDiagnostics, @NotNull Set<String> disabledDiagnostics, @NotNull Map<Severity, Boolean> severityMap) {
            Intrinsics.checkNotNullParameter(allowedDiagnostics, (String)"allowedDiagnostics");
            Intrinsics.checkNotNullParameter(disabledDiagnostics, (String)"disabledDiagnostics");
            Intrinsics.checkNotNullParameter(severityMap, (String)"severityMap");
            return new DiagnosticConditions(allowedDiagnostics, disabledDiagnostics, severityMap);
        }

        public static /* synthetic */ DiagnosticConditions copy$default(DiagnosticConditions diagnosticConditions, Set set, Set set2, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                set = diagnosticConditions.allowedDiagnostics;
            }
            if ((n & 2) != 0) {
                set2 = diagnosticConditions.disabledDiagnostics;
            }
            if ((n & 4) != 0) {
                map = diagnosticConditions.severityMap;
            }
            return diagnosticConditions.copy(set, set2, map);
        }

        @NotNull
        public String toString() {
            return "DiagnosticConditions(allowedDiagnostics=" + this.allowedDiagnostics + ", disabledDiagnostics=" + this.disabledDiagnostics + ", severityMap=" + this.severityMap + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.allowedDiagnostics).hashCode();
            result2 = result2 * 31 + ((Object)this.disabledDiagnostics).hashCode();
            result2 = result2 * 31 + ((Object)this.severityMap).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DiagnosticConditions)) {
                return false;
            }
            DiagnosticConditions diagnosticConditions = (DiagnosticConditions)other;
            if (!Intrinsics.areEqual(this.allowedDiagnostics, diagnosticConditions.allowedDiagnostics)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.disabledDiagnostics, diagnosticConditions.disabledDiagnostics)) {
                return false;
            }
            return Intrinsics.areEqual(this.severityMap, diagnosticConditions.severityMap);
        }
    }
}

