/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/ModuleDescriptorProvider;", "Lorg/jetbrains/kotlin/test/services/TestService;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "moduleDescriptorByModule", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getModuleDescriptor", "testModule", "replaceModuleDescriptorForModule", "", "moduleDescriptor", "tests-common-new_test"})
public final class ModuleDescriptorProvider
implements TestService {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final Map<TestModule, ModuleDescriptor> moduleDescriptorByModule;

    public ModuleDescriptorProvider(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
        this.moduleDescriptorByModule = new LinkedHashMap();
    }

    @NotNull
    public final ModuleDescriptor getModuleDescriptor(@NotNull TestModule testModule) {
        Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
        ModuleDescriptor moduleDescriptor2 = this.moduleDescriptorByModule.get(testModule);
        if (moduleDescriptor2 == null) {
            AssertionsKt.getAssertions(this.testServices).fail((Function0<String>)((Function0)new Function0<String>(testModule){
                final /* synthetic */ TestModule $testModule;
                {
                    this.$testModule = $testModule;
                    super(0);
                }

                public final String invoke() {
                    return "Module descriptor for module " + this.$testModule.getName() + " not found";
                }
            }));
            throw null;
        }
        return moduleDescriptor2;
    }

    public final void replaceModuleDescriptorForModule(@NotNull TestModule testModule, @NotNull ModuleDescriptor moduleDescriptor2) {
        Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor2, (String)"moduleDescriptor");
        this.moduleDescriptorByModule.put(testModule, moduleDescriptor2);
    }
}

