/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.ir;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizedResult;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizer;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrTypeSystemContext;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.pipeline.ConvertToIrKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextImpl;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.model.AbstractTestFacade;
import org.jetbrains.kotlin.test.model.BackendKinds;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestArtifactKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/backend/ir/IrActualizerAndPluginsFacade;", "Lorg/jetbrains/kotlin/test/model/AbstractTestFacade;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "transform", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "inputArtifact", "irGenerationExtensions", "", "Lorg/jetbrains/kotlin/backend/common/extensions/IrGenerationExtension;", "inputKind", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "getInputKind", "()Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "outputKind", "getOutputKind", "shouldRunAnalysis", "", "tests-common-new_test"})
public final class IrActualizerAndPluginsFacade
extends AbstractTestFacade<IrBackendInput, IrBackendInput> {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final TestArtifactKind<IrBackendInput> inputKind;
    @NotNull
    private final TestArtifactKind<IrBackendInput> outputKind;

    public IrActualizerAndPluginsFacade(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
        this.inputKind = BackendKinds.IrBackend.INSTANCE;
        this.outputKind = BackendKinds.IrBackend.INSTANCE;
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    @Override
    @NotNull
    public IrBackendInput transform(@NotNull TestModule module, @NotNull IrBackendInput inputArtifact) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)inputArtifact, (String)"inputArtifact");
        if (!Intrinsics.areEqual(module.getFrontendKind(), (Object)FrontendKinds.FIR.INSTANCE)) {
            return inputArtifact;
        }
        if (module.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiPlatformProjects)) {
            IrTypeSystemContext irTypeSystemContext;
            IrBuiltIns builtins = inputArtifact.getIrModuleFragment().getIrBuiltins();
            boolean bl = JvmPlatformKt.isJvm((TargetPlatform)module.getTargetPlatform());
            if (bl) {
                irTypeSystemContext = (IrTypeSystemContext)new JvmIrTypeSystemContext(builtins);
            } else if (!bl) {
                irTypeSystemContext = (IrTypeSystemContext)new IrTypeSystemContextImpl(builtins);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            IrTypeSystemContext typeSystemContext = irTypeSystemContext;
            IrModuleFragment irModuleFragment = inputArtifact.getIrModuleFragment();
            List<IrModuleFragment> list = inputArtifact.getDependentIrModuleFragments();
            DiagnosticReporter diagnosticReporter = (DiagnosticReporter)inputArtifact.getDiagnosticReporter();
            LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.testServices).getCompilerConfiguration(module));
            Fir2IrComponents fir2IrComponents = inputArtifact.getFir2IrComponents();
            Intrinsics.checkNotNull((Object)fir2IrComponents);
            SymbolTable symbolTable = fir2IrComponents.getSymbolTable();
            Fir2IrComponents fir2IrComponents2 = inputArtifact.getFir2IrComponents();
            Intrinsics.checkNotNull((Object)fir2IrComponents2);
            IrActualizedResult result2 = IrActualizer.INSTANCE.actualize(irModuleFragment, list, diagnosticReporter, typeSystemContext, languageVersionSettings, symbolTable, fir2IrComponents2.getFakeOverrideBuilder(), module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getENABLE_IR_FAKE_OVERRIDE_GENERATION()), null);
            inputArtifact.setIrActualizerResult(result2);
        }
        ConvertToIrKt.applyIrGenerationExtensions((IrPluginContext)inputArtifact.getIrPluginContext(), (IrModuleFragment)inputArtifact.getIrModuleFragment(), this.irGenerationExtensions(module, this.testServices));
        return inputArtifact;
    }

    private final Collection<IrGenerationExtension> irGenerationExtensions(TestModule $this$irGenerationExtensions, TestServices testServices) {
        return IrGenerationExtension.Companion.getInstances(CompilerConfigurationProviderKt.getCompilerConfigurationProvider(testServices).getProject($this$irGenerationExtensions));
    }

    @Override
    @NotNull
    public TestArtifactKind<IrBackendInput> getInputKind() {
        return this.inputKind;
    }

    @Override
    @NotNull
    public TestArtifactKind<IrBackendInput> getOutputKind() {
        return this.outputKind;
    }

    @Override
    public boolean shouldRunAnalysis(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return true;
    }
}

