/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeOptions;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.AbstractIrHandler;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirectivesContainer;
import org.jetbrains.kotlin.test.model.BackendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u001fH\u0002J\u0016\u0010&\u001a\u00020\u001f*\u00020\u00182\b\b\u0002\u0010'\u001a\u00020\"H\u0002R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u00060\u0014j\u0002`\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/AbstractIrHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "artifactKind", "Lorg/jetbrains/kotlin/test/model/BackendKind;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lorg/jetbrains/kotlin/test/model/BackendKind;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "baseDumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "buildersForSeparateFileDumps", "", "Ljava/io/File;", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "compareDumpsOfExternalClasses", "findExternalClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "externalClassId", "", "processAfterAllModules", "someAssertionWasFailed", "", "checkOneExpectedFile", "expectedFile", "actualDump", "getDumpExtension", "ignoreFirIdentical", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nIrTextDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTextDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler\n+ 2 HandlerUtils.kt\norg/jetbrains/kotlin/test/backend/handlers/HandlerUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n36#2:137\n37#2,2:140\n1855#3,2:138\n1549#3:142\n1620#3,3:143\n1855#3,2:146\n*S KotlinDebug\n*F\n+ 1 IrTextDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler\n*L\n79#1:137\n79#1:140,2\n79#1:138,2\n102#1:142\n102#1:143,3\n123#1:146,2\n*E\n"})
public final class IrTextDumpHandler
extends AbstractIrHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiModuleInfoDumper baseDumper;
    @NotNull
    private final Map<File, StringBuilder> buildersForSeparateFileDumps;
    @NotNull
    public static final String DUMP_EXTENSION = "ir.txt";

    public IrTextDumpHandler(@NotNull TestServices testServices, @NotNull BackendKind<IrBackendInput> artifactKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(artifactKind, (String)"artifactKind");
        super(testServices, artifactKind, false, false, 12, null);
        this.baseDumper = new MultiModuleInfoDumper(null, 1, null);
        this.buildersForSeparateFileDumps = new LinkedHashMap();
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        Object[] objectArray = new SimpleDirectivesContainer[]{CodegenTestDirectives.INSTANCE, FirDiagnosticsDirectives.INSTANCE};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull IrBackendInput info) {
        String actualDump;
        IrFile irFile;
        TestFile testFile;
        List<Pair<TestFile, IrFile>> testFileToIrFile;
        StringBuilder builder;
        String moduleName;
        boolean bl;
        IrModuleFragment irModuleFragment;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_IR())) {
            return;
        }
        DumpIrTreeOptions dumpOptions = new DumpIrTreeOptions(true, false, false, false, false, false, false, false, false, 422, null);
        IrBackendInput $this$processAllIrModuleFragments$iv = info;
        boolean $i$f$processAllIrModuleFragments = false;
        Iterable $this$forEach$iv$iv = $this$processAllIrModuleFragments$iv.getDependentIrModuleFragments();
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            IrModuleFragment it$iv = (IrModuleFragment)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it$iv.getName().asString(), (String)"asString(...)");
            irModuleFragment = it$iv;
            bl = false;
            builder = this.baseDumper.builderForModule(moduleName);
            testFileToIrFile = Companion.groupWithTestFiles(irModuleFragment.getFiles(), module);
            for (Pair<TestFile, IrFile> pair : testFileToIrFile) {
                testFile = (TestFile)pair.component1();
                irFile = (IrFile)pair.component2();
                Object object = testFile;
                if (object != null && (object = ((TestFile)object).getDirectives()) != null ? ((RegisteredDirectives)object).contains(CodegenTestDirectives.INSTANCE.getEXTERNAL_FILE()) : false) continue;
                actualDump = DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)irFile, (int)0, (DumpIrTreeOptions)dumpOptions);
                if (((CharSequence)actualDump).length() == 0) {
                    actualDump = DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)irFile, (int)-1, (DumpIrTreeOptions)dumpOptions);
                }
                builder.append(actualDump);
            }
        }
        moduleName = module.getName();
        irModuleFragment = $this$processAllIrModuleFragments$iv.getIrModuleFragment();
        bl = false;
        builder = this.baseDumper.builderForModule(moduleName);
        testFileToIrFile = Companion.groupWithTestFiles(irModuleFragment.getFiles(), module);
        for (Pair<TestFile, IrFile> pair : testFileToIrFile) {
            testFile = (TestFile)pair.component1();
            irFile = (IrFile)pair.component2();
            Object object = testFile;
            if (object != null && (object = ((TestFile)object).getDirectives()) != null ? ((RegisteredDirectives)object).contains(CodegenTestDirectives.INSTANCE.getEXTERNAL_FILE()) : false) continue;
            actualDump = DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)irFile, (int)0, (DumpIrTreeOptions)dumpOptions);
            if (((CharSequence)actualDump).length() == 0) {
                actualDump = DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)irFile, (int)-1, (DumpIrTreeOptions)dumpOptions);
            }
            builder.append(actualDump);
        }
        this.compareDumpsOfExternalClasses(module, info);
    }

    /*
     * WARNING - void declaration
     */
    private final void compareDumpsOfExternalClasses(TestModule module, IrBackendInput info) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<String> externalClassIds = module.getDirectives().get(CodegenTestDirectives.INSTANCE.getDUMP_EXTERNAL_CLASS());
        if (externalClassIds.isEmpty()) {
            return;
        }
        File baseFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        Iterable iterable = externalClassIds;
        Assertions assertions = this.getAssertions();
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void externalClassId;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Function0)new Function0<Unit>(this, info, (String)externalClassId, baseFile, module){
                final /* synthetic */ IrTextDumpHandler this$0;
                final /* synthetic */ IrBackendInput $info;
                final /* synthetic */ String $externalClassId;
                final /* synthetic */ File $baseFile;
                final /* synthetic */ TestModule $module;
                {
                    this.this$0 = $receiver;
                    this.$info = $info;
                    this.$externalClassId = $externalClassId;
                    this.$baseFile = $baseFile;
                    this.$module = $module;
                    super(0);
                }

                public final void invoke() {
                    String classDump = DumpIrTreeKt.dump$default((IrElement)((IrElement)IrTextDumpHandler.access$findExternalClass(this.this$0, this.$info.getIrPluginContext(), this.$externalClassId)), null, (int)1, null);
                    String suffix = ".__" + StringsKt.replace$default((String)this.$externalClassId, (String)"/", (String)".", (boolean)false, (int)4, null);
                    File expectedFile2 = FileUtilsKt.withSuffixAndExtension(this.$baseFile, suffix, IrTextDumpHandler.access$getDumpExtension(this.this$0, this.$module, true));
                    Assertions.assertEqualsToFile$default(IrTextDumpHandler.access$getAssertions(this.this$0), expectedFile2, classDump, null, 4, null);
                }
            });
        }
        assertions.assertAll((List)destination$iv$iv);
    }

    private final IrClass findExternalClass(IrPluginContext $this$findExternalClass, String externalClassId) {
        ClassId classId = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)externalClassId, (boolean)false, (int)2, null);
        IrClassSymbol irClassSymbol = $this$findExternalClass.referenceClass(classId);
        if (irClassSymbol == null || (irClassSymbol = (IrClass)irClassSymbol.getOwner()) == null) {
            this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(externalClassId){
                final /* synthetic */ String $externalClassId;
                {
                    this.$externalClassId = $externalClassId;
                    super(0);
                }

                public final String invoke() {
                    return "Can't find a class in external dependencies: " + this.$externalClassId;
                }
            }));
            throw null;
        }
        return irClassSymbol;
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure(this.getTestServices());
        File defaultExpectedFile = FileUtilsKt.withExtension((File)CollectionsKt.first(moduleStructure.getOriginalTestDataFiles()), IrTextDumpHandler.getDumpExtension$default(this, (TestModule)CollectionsKt.first(moduleStructure.getModules()), false, 1, null));
        this.checkOneExpectedFile(defaultExpectedFile, this.baseDumper.generateResultingDump());
        Iterable $this$forEach$iv = this.buildersForSeparateFileDumps.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            File expectedFile2 = (File)entry.getKey();
            StringBuilder dump = (StringBuilder)entry.getValue();
            String string = dump.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.checkOneExpectedFile(expectedFile2, string);
        }
    }

    private final void checkOneExpectedFile(File expectedFile2, String actualDump) {
        if (((CharSequence)actualDump).length() > 0) {
            Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile2, actualDump, null, 4, null);
        }
    }

    private final String getDumpExtension(TestModule $this$getDumpExtension, boolean ignoreFirIdentical) {
        return Companion.computeDumpExtension($this$getDumpExtension, DUMP_EXTENSION, ignoreFirIdentical);
    }

    static /* synthetic */ String getDumpExtension$default(IrTextDumpHandler irTextDumpHandler, TestModule testModule, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return irTextDumpHandler.getDumpExtension(testModule, bl);
    }

    public static final /* synthetic */ IrClass access$findExternalClass(IrTextDumpHandler $this, IrPluginContext $receiver, String externalClassId) {
        return $this.findExternalClass($receiver, externalClassId);
    }

    public static final /* synthetic */ String access$getDumpExtension(IrTextDumpHandler $this, TestModule $receiver, boolean ignoreFirIdentical) {
        return $this.getDumpExtension($receiver, ignoreFirIdentical);
    }

    public static final /* synthetic */ Assertions access$getAssertions(IrTextDumpHandler $this) {
        return $this.getAssertions();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bJ,\u0010\f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\r*\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler$Companion;", "", "<init>", "()V", "DUMP_EXTENSION", "", "computeDumpExtension", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "defaultExtension", "ignoreFirIdentical", "", "groupWithTestFiles", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/test/model/TestFile;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nIrTextDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTextDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1603#2,9:137\n1855#2:146\n288#2,2:147\n1856#2:150\n1612#2:151\n1#3:149\n*S KotlinDebug\n*F\n+ 1 IrTextDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler$Companion\n*L\n53#1:137,9\n53#1:146\n55#1:147,2\n53#1:150\n53#1:151\n53#1:149\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String computeDumpExtension(@NotNull TestModule module, @NotNull String defaultExtension, boolean ignoreFirIdentical) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)defaultExtension, (String)"defaultExtension");
            return Intrinsics.areEqual(module.getFrontendKind(), (Object)FrontendKinds.ClassicFrontend.INSTANCE) || !ignoreFirIdentical && module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getFIR_IDENTICAL()) ? defaultExtension : "fir." + defaultExtension;
        }

        public static /* synthetic */ String computeDumpExtension$default(Companion companion, TestModule testModule, String string, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.computeDumpExtension(testModule, string, bl);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Pair<TestFile, IrFile>> groupWithTestFiles(@NotNull List<? extends IrFile> $this$groupWithTestFiles, @NotNull TestModule module) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$groupWithTestFiles, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Iterable $this$mapNotNull$iv = $this$groupWithTestFiles;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair it$iv$iv;
                Object v0;
                IrFile irFile;
                block2: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    irFile = (IrFile)element$iv$iv;
                    boolean bl2 = false;
                    String name2 = new File(irFile.getFileEntry().getName()).getName();
                    Iterable $this$firstOrNull$iv = module.getFiles();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        TestFile it = (TestFile)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                TestFile testFile = v0;
                if (TuplesKt.to((Object)testFile, (Object)irFile) == null) continue;
                boolean bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

