/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.diagnostics.ConeAmbiguousSuper;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirLoopJump;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeFunctionExpectedError;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirAnalysisHandler;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirResolvedTypesVerifier;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u000b*\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirResolvedTypesVerifier;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "check", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "typeName", "", "ConeTypeStatus", "Visitor", "tests-common-new_test"})
public final class FirResolvedTypesVerifier
extends FirAnalysisHandler {
    public FirResolvedTypesVerifier(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, true, false, 4, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)FirDiagnosticsDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull FirOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Visitor visitor = new Visitor();
        for (FirFile firFile : info.getMainFirFiles().values()) {
            firFile.acceptChildren((FirVisitor)visitor, (Object)firFile);
        }
        boolean ignored = module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getIGNORE_LEAKED_INTERNAL_TYPES());
        try {
            Function0[] function0Array = new Function0[]{new Function0<Unit>(this, visitor){
                final /* synthetic */ FirResolvedTypesVerifier this$0;
                final /* synthetic */ Visitor $visitor;
                {
                    this.this$0 = $receiver;
                    this.$visitor = $visitor;
                    super(0);
                }

                public final void invoke() {
                    FirResolvedTypesVerifier.access$check(this.this$0, this.$visitor.getDetectedImplicitTypesParents(), "implicit");
                }
            }, new Function0<Unit>(this, visitor){
                final /* synthetic */ FirResolvedTypesVerifier this$0;
                final /* synthetic */ Visitor $visitor;
                {
                    this.this$0 = $receiver;
                    this.$visitor = $visitor;
                    super(0);
                }

                public final void invoke() {
                    FirResolvedTypesVerifier.access$check(this.this$0, this.$visitor.getDetectedTypeVariableTypesParents(), "type variable");
                }
            }, new Function0<Unit>(this, visitor){
                final /* synthetic */ FirResolvedTypesVerifier this$0;
                final /* synthetic */ Visitor $visitor;
                {
                    this.this$0 = $receiver;
                    this.$visitor = $visitor;
                    super(0);
                }

                public final void invoke() {
                    FirResolvedTypesVerifier.access$check(this.this$0, this.$visitor.getDetectedStubTypesParents(), "stub");
                }
            }};
            this.getAssertions().assertAll(function0Array);
        }
        catch (AssertionError assertionError) {
            if (ignored) {
                return;
            }
            throw assertionError;
        }
        if (ignored) {
            this.getAssertions().fail((Function0<String>)((Function0)processModule.4.INSTANCE));
            throw null;
        }
    }

    private final void check(Collection<? extends FirElement> $this$check, String typeName) {
        this.getAssertions().assertTrue($this$check.isEmpty(), (Function0<String>)((Function0)new Function0<String>($this$check, typeName){
            final /* synthetic */ Collection<FirElement> $this_check;
            final /* synthetic */ String $typeName;
            {
                this.$this_check = $receiver;
                this.$typeName = $typeName;
                super(0);
            }

            @NotNull
            public final String invoke() {
                StringBuilder stringBuilder;
                Collection<FirElement> collection = this.$this_check;
                String string = this.$typeName;
                StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                int count = collection.size();
                if (count == 1) {
                    StringBuilder stringBuilder2 = $this$invoke_u24lambda_u240.append("One " + string + " type was found:");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
                } else {
                    StringBuilder stringBuilder3 = $this$invoke_u24lambda_u240.append("" + count + ' ' + string + " types were found:");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
                }
                String types2 = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"\n", null, null, (int)0, null, (Function1)check.1.types.1.INSTANCE, (int)30, null);
                $this$invoke_u24lambda_u240.append(types2);
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                return string2;
            }
        }));
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }

    public static final /* synthetic */ void access$check(FirResolvedTypesVerifier $this, Collection $receiver, String typeName) {
        $this.check($receiver, typeName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirResolvedTypesVerifier$ConeTypeStatus;", "", "(Ljava/lang/String;I)V", "TypeVariableFound", "StubFound", "tests-common-new_test"})
    private static final class ConeTypeStatus
    extends Enum<ConeTypeStatus> {
        public static final /* enum */ ConeTypeStatus TypeVariableFound = new ConeTypeStatus();
        public static final /* enum */ ConeTypeStatus StubFound = new ConeTypeStatus();
        private static final /* synthetic */ ConeTypeStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConeTypeStatus[] values() {
            return (ConeTypeStatus[])$VALUES.clone();
        }

        public static ConeTypeStatus valueOf(String value) {
            return Enum.valueOf(ConeTypeStatus.class, value);
        }

        @NotNull
        public static EnumEntries<ConeTypeStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = coneTypeStatusArray = new ConeTypeStatus[]{ConeTypeStatus.TypeVariableFound, ConeTypeStatus.StubFound};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0012\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\"*\u00020#H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirResolvedTypesVerifier$Visitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "(Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirResolvedTypesVerifier;)V", "detectedImplicitTypesParents", "", "getDetectedImplicitTypesParents", "()Ljava/util/Set;", "detectedStubTypesParents", "getDetectedStubTypesParents", "detectedTypeVariableTypesParents", "getDetectedTypeVariableTypesParents", "checkConeType", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirResolvedTypesVerifier$ConeTypeStatus;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkElementWithConeType", "element", "visitElement", "data", "visitErrorTypeRef", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "visitImplicitTypeRef", "implicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirImplicitTypeRef;", "visitLoopJump", "loopJump", "Lorg/jetbrains/kotlin/fir/expressions/FirLoopJump;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "coneTypes", "", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nFirResolvedTypesVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirResolvedTypesVerifier.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/FirResolvedTypesVerifier$Visitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1#2:149\n*E\n"})
    private final class Visitor
    extends FirDefaultVisitor<Unit, FirElement> {
        @NotNull
        private final Set<FirElement> detectedImplicitTypesParents = new LinkedHashSet();
        @NotNull
        private final Set<FirElement> detectedTypeVariableTypesParents = new LinkedHashSet();
        @NotNull
        private final Set<FirElement> detectedStubTypesParents = new LinkedHashSet();

        @NotNull
        public final Set<FirElement> getDetectedImplicitTypesParents() {
            return this.detectedImplicitTypesParents;
        }

        @NotNull
        public final Set<FirElement> getDetectedTypeVariableTypesParents() {
            return this.detectedTypeVariableTypesParents;
        }

        @NotNull
        public final Set<FirElement> getDetectedStubTypesParents() {
            return this.detectedStubTypesParents;
        }

        public void visitElement(@NotNull FirElement element, @NotNull FirElement data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (element instanceof FirDiagnosticHolder) {
                for (ConeKotlinType coneType : this.coneTypes(((FirDiagnosticHolder)element).getDiagnostic())) {
                    this.checkElementWithConeType(element, coneType);
                }
            }
            element.acceptChildren((FirVisitor)this, (Object)element);
        }

        public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull FirElement data) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitElement((FirElement)resolvedTypeRef, data);
                this.checkElementWithConeType((FirElement)resolvedTypeRef, resolvedTypeRef.getType());
                FirTypeRef firTypeRef = resolvedTypeRef.getDelegatedTypeRef();
                if (firTypeRef == null) break block0;
                FirTypeRef it = firTypeRef;
                boolean bl = false;
                this.visitElement((FirElement)it, data);
            }
        }

        public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef, @NotNull FirElement data) {
            Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.visitElement((FirElement)errorTypeRef, data);
            FirTypeRef firTypeRef = errorTypeRef.getDelegatedTypeRef();
            if (firTypeRef != null) {
                FirTypeRef it = firTypeRef;
                boolean bl = false;
                this.visitElement((FirElement)it, data);
            }
            this.checkElementWithConeType((FirElement)errorTypeRef, errorTypeRef.getType());
        }

        public void visitLoopJump(@NotNull FirLoopJump loopJump, @NotNull FirElement data) {
            Intrinsics.checkNotNullParameter((Object)loopJump, (String)"loopJump");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.visitElement((FirElement)loopJump, data);
            if (loopJump.getTarget().getLabeledElement() instanceof FirErrorLoop) {
                this.visitElement((FirElement)loopJump.getTarget().getLabeledElement(), data);
            }
        }

        public void visitImplicitTypeRef(@NotNull FirImplicitTypeRef implicitTypeRef, @NotNull FirElement data) {
            Intrinsics.checkNotNullParameter((Object)implicitTypeRef, (String)"implicitTypeRef");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            ((Collection)this.detectedImplicitTypesParents).add(data);
        }

        private final void checkElementWithConeType(FirElement element, ConeKotlinType type) {
            ConeTypeStatus coneTypeStatus = this.checkConeType(type);
            switch (coneTypeStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[coneTypeStatus.ordinal()]) {
                case 1: {
                    ((Collection)this.detectedTypeVariableTypesParents).add(element);
                    break;
                }
                case 2: {
                    ((Collection)this.detectedStubTypesParents).add(element);
                }
            }
        }

        private final ConeTypeStatus checkConeType(ConeKotlinType type) {
            Ref.BooleanRef typeVariableFound = new Ref.BooleanRef();
            Ref.BooleanRef stubTypeFound = new Ref.BooleanRef();
            ConeTypeUtilsKt.contains((ConeKotlinType)type, (Function1)((Function1)new Function1<ConeKotlinType, Boolean>(typeVariableFound, stubTypeFound){
                final /* synthetic */ Ref.BooleanRef $typeVariableFound;
                final /* synthetic */ Ref.BooleanRef $stubTypeFound;
                {
                    this.$typeVariableFound = $typeVariableFound;
                    this.$stubTypeFound = $stubTypeFound;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ConeKotlinType it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ConeKotlinType coneKotlinType = it;
                    if (coneKotlinType instanceof ConeTypeVariableType) {
                        this.$typeVariableFound.element = true;
                    } else if (coneKotlinType instanceof ConeStubType) {
                        this.$stubTypeFound.element = true;
                    }
                    return false;
                }
            }));
            return stubTypeFound.element ? ConeTypeStatus.StubFound : (typeVariableFound.element ? ConeTypeStatus.TypeVariableFound : null);
        }

        private final List<ConeKotlinType> coneTypes(ConeDiagnostic $this$coneTypes) {
            ConeDiagnostic coneDiagnostic = $this$coneTypes;
            return coneDiagnostic instanceof ConeAmbiguousSuper ? ((ConeAmbiguousSuper)$this$coneTypes).getCandidateTypes() : (coneDiagnostic instanceof ConeFunctionExpectedError ? CollectionsKt.listOf((Object)((ConeFunctionExpectedError)$this$coneTypes).getType()) : CollectionsKt.emptyList());
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ConeTypeStatus.values().length];
                try {
                    nArray[ConeTypeStatus.TypeVariableFound.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConeTypeStatus.StubFound.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

