/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.sourceProviders;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtPsiSourceFile;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AdditionalSourceProvider;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/test/services/sourceProviders/MainFunctionForBlackBoxTestsSourceProvider;", "Lorg/jetbrains/kotlin/test/services/AdditionalSourceProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "generateMainBody", "", "produceAdditionalFiles", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "globalDirectives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nMainFunctionForBlackBoxTestsSourceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainFunctionForBlackBoxTestsSourceProvider.kt\norg/jetbrains/kotlin/test/services/sourceProviders/MainFunctionForBlackBoxTestsSourceProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n288#2,2:99\n*S KotlinDebug\n*F\n+ 1 MainFunctionForBlackBoxTestsSourceProvider.kt\norg/jetbrains/kotlin/test/services/sourceProviders/MainFunctionForBlackBoxTestsSourceProvider\n*L\n76#1:99,2\n*E\n"})
public class MainFunctionForBlackBoxTestsSourceProvider
extends AdditionalSourceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex PACKAGE_REGEXP = new Regex("package ([\\w.]+)");
    @NotNull
    private static final Regex START_BOX_METHOD_REGEX = new Regex("^fun box\\(\\)");
    @NotNull
    private static final Regex MIDDLE_BOX_METHOD_REGEX = new Regex("\\nfun box\\(\\)");
    @NotNull
    private static final Regex START_SUSPEND_BOX_METHOD_REGEX = new Regex("^suspend fun box\\(\\)");
    @NotNull
    private static final Regex MIDDLE_SUSPEND_BOX_METHOD_REGEX = new Regex("\\nsuspend fun box\\(\\)");
    @NotNull
    public static final String BOX_MAIN_FILE_NAME = "Generated_Box_Main.kt";

    public MainFunctionForBlackBoxTestsSourceProvider(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @NotNull
    protected String generateMainBody() {
        return "val res = box()\nif (res != \"OK\") throw AssertionError(res)";
    }

    @Override
    @NotNull
    public List<TestFile> produceAdditionalFiles(@NotNull RegisteredDirectives globalDirectives, @NotNull TestModule module) {
        StringBuilder stringBuilder;
        Object v1;
        Object object;
        block6: {
            Intrinsics.checkNotNullParameter((Object)globalDirectives, (String)"globalDirectives");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getREQUIRES_SEPARATE_PROCESS())) {
                TestJdkKind testJdkKind = DirectiveKt.singleOrZeroValue(module.getDirectives(), JvmEnvironmentConfigurationDirectives.INSTANCE.getJDK_KIND());
                if (!(testJdkKind != null ? testJdkKind.getRequiresSeparateProcess() : false)) {
                    return CollectionsKt.emptyList();
                }
            }
            Iterable $this$firstOrNull$iv = module.getFiles();
            boolean $i$f$firstOrNull = false;
            object = $this$firstOrNull$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                TestFile it = (TestFile)element$iv;
                boolean bl = false;
                if (!Companion.containsBoxMethod(it)) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        TestFile testFile = v1;
        if (testFile == null) {
            return CollectionsKt.emptyList();
        }
        TestFile fileWithBox = testFile;
        String suspendModifier = Companion.containsSuspendBoxMethod(fileWithBox) ? "suspend " : "";
        String mainBody = this.generateMainBody();
        Object $this$produceAdditionalFiles_u24lambda_u242 = object = new StringBuilder();
        boolean bl = false;
        String string = Companion.detectPackage(fileWithBox);
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            StringBuilder stringBuilder2 = ((StringBuilder)$this$produceAdditionalFiles_u24lambda_u242).append("package " + it);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            StringBuilder stringBuilder3 = stringBuilder2.append('\n');
            stringBuilder = stringBuilder3;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        } else {
            stringBuilder = null;
        }
        StringBuilder stringBuilder4 = ((StringBuilder)$this$produceAdditionalFiles_u24lambda_u242).append(StringsKt.trimIndent((String)("\n                    " + suspendModifier + "fun main() {\n                        " + mainBody + "\n                    }\n                ")));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        String string2 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String code = string2;
        File file = FilesKt.resolve((File)TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(this.getTestServices()).getOrCreateTempDirectory("src"), (String)BOX_MAIN_FILE_NAME);
        FilesKt.writeText$default((File)file, (String)code, null, (int)2, null);
        return CollectionsKt.listOf((Object)AdditionalSourceProvider.toTestFile$default(this, file, null, 1, null));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/test/services/sourceProviders/MainFunctionForBlackBoxTestsSourceProvider$Companion;", "", "()V", "BOX_MAIN_FILE_NAME", "", "MIDDLE_BOX_METHOD_REGEX", "Lkotlin/text/Regex;", "MIDDLE_SUSPEND_BOX_METHOD_REGEX", "PACKAGE_REGEXP", "START_BOX_METHOD_REGEX", "START_SUSPEND_BOX_METHOD_REGEX", "containsBoxMethod", "", "fileContent", "file", "Lorg/jetbrains/kotlin/test/model/TestFile;", "containsSuspendBoxMethod", "detectPackage", "fileContainsBoxMethod", "sourceFile", "Lorg/jetbrains/kotlin/KtSourceFile;", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String detectPackage(@NotNull TestFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            MatchResult matchResult = Regex.find$default((Regex)PACKAGE_REGEXP, (CharSequence)file.getOriginalContent(), (int)0, (int)2, null);
            return matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null ? matchResult.getValue() : null;
        }

        public final boolean containsBoxMethod(@NotNull TestFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.containsBoxMethod(file.getOriginalContent());
        }

        public final boolean containsSuspendBoxMethod(@NotNull TestFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.containsBoxMethod(file.getOriginalContent());
        }

        public final boolean fileContainsBoxMethod(@NotNull KtSourceFile sourceFile) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
            if (sourceFile instanceof KtPsiSourceFile) {
                String string = ((KtPsiSourceFile)sourceFile).getPsiFile().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                bl = this.containsBoxMethod(string);
            } else {
                InputStreamReader $this$fileContainsBoxMethod_u24lambda_u240 = new InputStreamReader(sourceFile.getContentsAsStream(), Charsets.UTF_8);
                boolean bl2 = false;
                bl = Companion.containsBoxMethod(TextStreamsKt.readText((Reader)$this$fileContainsBoxMethod_u24lambda_u240));
            }
            return bl;
        }

        public final boolean containsBoxMethod(@NotNull String fileContent) {
            Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
            return START_BOX_METHOD_REGEX.containsMatchIn((CharSequence)fileContent) || MIDDLE_BOX_METHOD_REGEX.containsMatchIn((CharSequence)fileContent) || this.containsSuspendBoxMethod(fileContent);
        }

        public final boolean containsSuspendBoxMethod(@NotNull String fileContent) {
            Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
            return START_SUSPEND_BOX_METHOD_REGEX.containsMatchIn((CharSequence)fileContent) || MIDDLE_SUSPEND_BOX_METHOD_REGEX.containsMatchIn((CharSequence)fileContent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

