/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.platform.JsPlatform;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.platform.jvm.JdkPlatform;
import org.jetbrains.kotlin.platform.konan.NativePlatform;
import org.jetbrains.kotlin.test.util.StringUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/TargetPlatformParser;", "", "()V", "JDK", "", "JS", "JVM", "parseTargetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "declaredPlatforms", "", "tryParseJdkPlatform", "Lorg/jetbrains/kotlin/platform/jvm/JdkPlatform;", "platformString", "tryParseJsPlatform", "Lorg/jetbrains/kotlin/platform/JsPlatform;", "tryParseNativePlatform", "Lorg/jetbrains/kotlin/platform/konan/NativePlatform;", "test-infrastructure_test"})
@SourceDebugExtension(value={"SMAP\nTargetPlatformParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetPlatformParser.kt\norg/jetbrains/kotlin/test/services/impl/TargetPlatformParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,52:1\n1620#2,2:53\n1622#2:56\n1#3:55\n226#4:57\n*S KotlinDebug\n*F\n+ 1 TargetPlatformParser.kt\norg/jetbrains/kotlin/test/services/impl/TargetPlatformParser\n*L\n24#1:53,2\n24#1:56\n44#1:57\n*E\n"})
public final class TargetPlatformParser {
    @NotNull
    public static final TargetPlatformParser INSTANCE = new TargetPlatformParser();
    @NotNull
    private static final String JVM = "JVM";
    @NotNull
    private static final String JDK = "JDK";
    @NotNull
    private static final String JS = "JS";

    private TargetPlatformParser() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TargetPlatform parseTargetPlatform(@NotNull List<String> declaredPlatforms) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(declaredPlatforms, (String)"declaredPlatforms");
        if (declaredPlatforms.isEmpty()) {
            return null;
        }
        Iterable iterable = declaredPlatforms;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            SimplePlatform simplePlatform;
            JdkPlatform it;
            void platformString;
            String string = (String)item$iv;
            void var12_11 = destination$iv;
            boolean bl = false;
            if (INSTANCE.tryParseJdkPlatform((String)platformString) != null) {
                boolean bl2 = false;
                simplePlatform = (SimplePlatform)it;
            } else if (INSTANCE.tryParseJsPlatform((String)platformString) != null) {
                boolean bl3 = false;
                simplePlatform = (SimplePlatform)it;
            } else if (INSTANCE.tryParseNativePlatform((String)platformString) != null) {
                boolean bl4 = false;
                simplePlatform = (SimplePlatform)it;
            } else {
                throw new IllegalStateException(("Unknown platform: " + (String)platformString).toString());
            }
            var12_11.add(simplePlatform);
        }
        Set simplePlatforms = (Set)destination$iv;
        return new TargetPlatform(simplePlatforms);
    }

    private final JdkPlatform tryParseJdkPlatform(String platformString) {
        JvmTarget jvmTarget;
        if (Intrinsics.areEqual((Object)platformString, (Object)JVM)) {
            jvmTarget = JvmTarget.DEFAULT;
        } else {
            JvmTarget jvmTarget2;
            block5: {
                if (!StringsKt.startsWith$default((String)platformString, (String)JDK, (boolean)false, (int)2, null)) {
                    return null;
                }
                JvmTarget[] jvmTargetArray = JvmTarget.values();
                int n = jvmTargetArray.length;
                for (int i = 0; i < n; ++i) {
                    JvmTarget jvmTarget3;
                    JvmTarget it = jvmTarget3 = jvmTargetArray[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)platformString)) continue;
                    jvmTarget2 = jvmTarget3;
                    break block5;
                }
                jvmTarget2 = jvmTarget = null;
            }
            if (jvmTarget2 == null) {
                throw new IllegalStateException(("JvmTarget \"" + platformString + "\" not found.\nAvailable targets: " + StringUtilsKt.joinToArrayString(JvmTarget.values())).toString());
            }
        }
        JvmTarget target = jvmTarget;
        return new JdkPlatform(target);
    }

    private final JsPlatform tryParseJsPlatform(String platformString) {
        JsPlatforms.DefaultSimpleJsPlatform defaultSimpleJsPlatform;
        boolean condition$iv = Intrinsics.areEqual((Object)platformString, (Object)JS);
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            defaultSimpleJsPlatform = JsPlatforms.DefaultSimpleJsPlatform.INSTANCE;
        } else {
            defaultSimpleJsPlatform = null;
        }
        return (JsPlatform)defaultSimpleJsPlatform;
    }

    private final NativePlatform tryParseNativePlatform(String platformString) {
        return null;
    }
}

