/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.generators.util;

import java.io.File;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/generators/util/TestGeneratorUtil;", "", "()V", "KT", "", "KTS", "KT_OR_KTS", "KT_OR_KTS_WITHOUT_DOTS_IN_NAME", "KT_WITHOUT_DOTS_IN_NAME", "KT_WITHOUT_FIR_PREFIX", "escapeForJavaIdentifier", "fileName", "fileNameToJavaIdentifier", "file", "Ljava/io/File;", "getMainClassName", "test-generator_test"})
@SourceDebugExtension(value={"SMAP\nTestGeneratorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestGeneratorUtil.kt\norg/jetbrains/kotlin/generators/util/TestGeneratorUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class TestGeneratorUtil {
    @NotNull
    public static final TestGeneratorUtil INSTANCE = new TestGeneratorUtil();
    @Language(value="RegExp")
    @NotNull
    public static final String KT_OR_KTS = "^(.+)\\.(kt|kts)$";
    @Language(value="RegExp")
    @NotNull
    public static final String KT = "^(.+)\\.(kt)$";
    @Language(value="RegExp")
    @NotNull
    public static final String KTS = "^(.+)\\.(kts)$";
    @Language(value="RegExp")
    @NotNull
    public static final String KT_OR_KTS_WITHOUT_DOTS_IN_NAME = "^([^.]+)\\.(kt|kts)$";
    @Language(value="RegExp")
    @NotNull
    public static final String KT_WITHOUT_DOTS_IN_NAME = "^([^.]+)\\.kt$";
    @Language(value="RegExp")
    @NotNull
    public static final String KT_WITHOUT_FIR_PREFIX = "^(.+)(?<!\\.fir)\\.kt$";

    private TestGeneratorUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String escapeForJavaIdentifier(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        StringBuilder result2 = new StringBuilder();
        int n = fileName.length();
        for (int i = 0; i < n; ++i) {
            char c = fileName.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                result2.append(c);
                continue;
            }
            result2.append("_");
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String fileNameToJavaIdentifier(@NotNull File file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string2 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = TestGeneratorUtil.escapeForJavaIdentifier(string2);
        if (((CharSequence)string3).length() > 0) {
            char p0 = string3.charAt(0);
            boolean bl = false;
            char c = Character.toUpperCase(p0);
            String string4 = string3;
            int n = 1;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            string4 = string5;
            string = c + string4;
        } else {
            string = string3;
        }
        return string;
    }

    @Nullable
    public final String getMainClassName() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
        StackTraceElement stackTraceElement = (StackTraceElement)ArraysKt.lastOrNull((Object[])stackTraceElementArray);
        return stackTraceElement != null ? stackTraceElement.getClassName() : null;
    }
}

