/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.ir;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizedResult;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizer;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrTypeSystemContext;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.pipeline.ConvertToIrKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextImpl;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.model.AbstractTestFacade;
import org.jetbrains.kotlin.test.model.BackendKinds;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestArtifactKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/test/backend/ir/IrActualizerAndPluginsFacade;", "Lorg/jetbrains/kotlin/test/model/AbstractTestFacade;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "inputKind", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "getInputKind", "()Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "outputKind", "getOutputKind", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "shouldRunAnalysis", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "transform", "inputArtifact", "irGenerationExtensions", "", "Lorg/jetbrains/kotlin/backend/common/extensions/IrGenerationExtension;", "tests-common-new_test"})
public final class IrActualizerAndPluginsFacade
extends AbstractTestFacade<IrBackendInput, IrBackendInput> {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final TestArtifactKind<IrBackendInput> inputKind;
    @NotNull
    private final TestArtifactKind<IrBackendInput> outputKind;

    public IrActualizerAndPluginsFacade(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
        this.inputKind = BackendKinds.IrBackend.INSTANCE;
        this.outputKind = BackendKinds.IrBackend.INSTANCE;
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    @Override
    @NotNull
    public IrBackendInput transform(@NotNull TestModule module, @NotNull IrBackendInput inputArtifact) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)inputArtifact, (String)"inputArtifact");
        if (!Intrinsics.areEqual(module.getFrontendKind(), (Object)FrontendKinds.FIR.INSTANCE)) {
            return inputArtifact;
        }
        if (module.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiPlatformProjects)) {
            IrTypeSystemContext irTypeSystemContext;
            IrBuiltIns builtins = inputArtifact.getIrModuleFragment().getIrBuiltins();
            boolean bl = JvmPlatformKt.isJvm((TargetPlatform)module.getTargetPlatform());
            if (bl) {
                irTypeSystemContext = (IrTypeSystemContext)new JvmIrTypeSystemContext(builtins);
            } else if (!bl) {
                irTypeSystemContext = (IrTypeSystemContext)new IrTypeSystemContextImpl(builtins);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            IrTypeSystemContext typeSystemContext = irTypeSystemContext;
            IrActualizedResult result2 = IrActualizer.INSTANCE.actualize(inputArtifact.getIrModuleFragment(), inputArtifact.getDependentIrModuleFragments(), (DiagnosticReporter)inputArtifact.getDiagnosticReporter(), typeSystemContext, CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.testServices).getCompilerConfiguration(module)));
            inputArtifact.setIrActualizerResult(result2);
        }
        ConvertToIrKt.applyIrGenerationExtensions((IrPluginContext)inputArtifact.getIrPluginContext(), (IrModuleFragment)inputArtifact.getIrModuleFragment(), this.irGenerationExtensions(module, this.testServices));
        return inputArtifact;
    }

    private final Collection<IrGenerationExtension> irGenerationExtensions(TestModule $this$irGenerationExtensions, TestServices testServices) {
        return IrGenerationExtension.Companion.getInstances(CompilerConfigurationProviderKt.getCompilerConfigurationProvider(testServices).getProject($this$irGenerationExtensions));
    }

    @Override
    @NotNull
    public TestArtifactKind<IrBackendInput> getInputKind() {
        return this.inputKind;
    }

    @Override
    @NotNull
    public TestArtifactKind<IrBackendInput> getOutputKind() {
        return this.outputKind;
    }

    @Override
    public boolean shouldRunAnalysis(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return true;
    }
}

