/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.checkers.diagnostics.factories.DebugInfoDiagnosticFactory0;
import org.jetbrains.kotlin.checkers.diagnostics.factories.DebugInfoDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.KtLightDiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.KtLightSimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.KtPsiSimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtSimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015J\u0014\u0010\u0016\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/DebugDiagnosticConsumer;", "", "result", "", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "diagnosedRangesToDiagnosticNames", "", "Lkotlin/ranges/IntRange;", "", "", "(Ljava/util/List;Ljava/util/Map;)V", "report", "", "debugFactory", "Lorg/jetbrains/kotlin/checkers/diagnostics/factories/DebugInfoDiagnosticFactory0;", "sourceElement", "Lorg/jetbrains/kotlin/KtSourceElement;", "Lorg/jetbrains/kotlin/checkers/diagnostics/factories/DebugInfoDiagnosticFactory1;", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "argumentFactory", "Lkotlin/Function0;", "getPositionedElement", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nFirDiagnosticsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDiagnosticsHandler.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/DebugDiagnosticConsumer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,557:1\n1#2:558\n*E\n"})
final class DebugDiagnosticConsumer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final List<KtDiagnostic> result;
    @NotNull
    private final Map<IntRange, Set<String>> diagnosedRangesToDiagnosticNames;
    @NotNull
    private static final Set<KtSourceElementKind> allowedKindsForDebugInfo;

    public DebugDiagnosticConsumer(@NotNull List<KtDiagnostic> result, @NotNull Map<IntRange, ? extends Set<String>> diagnosedRangesToDiagnosticNames) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Intrinsics.checkNotNullParameter(diagnosedRangesToDiagnosticNames, (String)"diagnosedRangesToDiagnosticNames");
        this.result = result;
        this.diagnosedRangesToDiagnosticNames = diagnosedRangesToDiagnosticNames;
    }

    public final void report(@NotNull DebugInfoDiagnosticFactory0 debugFactory, @Nullable KtSourceElement sourceElement) {
        KtSimpleDiagnostic ktSimpleDiagnostic;
        Intrinsics.checkNotNullParameter((Object)debugFactory, (String)"debugFactory");
        if (sourceElement == null || !allowedKindsForDebugInfo.contains(sourceElement.getKind())) {
            return;
        }
        if (Intrinsics.areEqual((Object)sourceElement.getElementType(), (Object)KtNodeTypes.LAMBDA_ARGUMENT) || Intrinsics.areEqual((Object)sourceElement.getElementType(), (Object)KtNodeTypes.BLOCK)) {
            return;
        }
        Set<String> availableDiagnostics = this.diagnosedRangesToDiagnosticNames.get(new IntRange(sourceElement.getStartOffset(), sourceElement.getEndOffset()));
        if (availableDiagnostics == null || !availableDiagnostics.contains(debugFactory.getName())) {
            return;
        }
        KtDiagnosticFactory0 factory = new KtDiagnosticFactory0(debugFactory.getName(), debugFactory.getSeverity(), AbstractSourceElementPositioningStrategy.Companion.getDEFAULT(), Reflection.getOrCreateKotlinClass(PsiElement.class));
        KtSourceElement ktSourceElement = sourceElement;
        if (ktSourceElement instanceof KtPsiSourceElement) {
            ktSimpleDiagnostic = (KtSimpleDiagnostic)new KtPsiSimpleDiagnostic((KtPsiSourceElement)sourceElement, debugFactory.getSeverity(), factory, factory.getDefaultPositioningStrategy());
        } else if (ktSourceElement instanceof KtLightSourceElement) {
            ktSimpleDiagnostic = (KtSimpleDiagnostic)new KtLightSimpleDiagnostic((KtLightSourceElement)sourceElement, debugFactory.getSeverity(), factory, factory.getDefaultPositioningStrategy());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        KtSimpleDiagnostic diagnostic = ktSimpleDiagnostic;
        this.result.add((KtDiagnostic)diagnostic);
    }

    public final void report(@NotNull DebugInfoDiagnosticFactory1 debugFactory, @NotNull FirElement element, @NotNull Function0<String> argumentFactory) {
        KtDiagnosticWithParameters1 ktDiagnosticWithParameters1;
        Object object;
        block10: {
            block9: {
                KtSourceElement ktSourceElement;
                Intrinsics.checkNotNullParameter((Object)debugFactory, (String)"debugFactory");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter(argumentFactory, (String)"argumentFactory");
                object = element.getSource();
                if (object == null) break block9;
                KtSourceElement it = ktSourceElement = object;
                boolean bl = false;
                object = allowedKindsForDebugInfo.contains(it.getKind()) ? ktSourceElement : null;
                if (object != null) break block10;
            }
            return;
        }
        KtSourceElement sourceElement = object;
        if (Intrinsics.areEqual((Object)sourceElement.getElementType(), (Object)KtNodeTypes.LAMBDA_ARGUMENT) || Intrinsics.areEqual((Object)sourceElement.getElementType(), (Object)KtNodeTypes.BLOCK)) {
            return;
        }
        KtSourceElement positionedElement = this.getPositionedElement(debugFactory, sourceElement);
        Set<String> availableDiagnostics = this.diagnosedRangesToDiagnosticNames.get(new IntRange(positionedElement.getStartOffset(), positionedElement.getEndOffset()));
        if (availableDiagnostics == null || !availableDiagnostics.contains(debugFactory.getName())) {
            return;
        }
        KtDiagnosticFactory1 factory = new KtDiagnosticFactory1(debugFactory.getName(), debugFactory.getSeverity(), AbstractSourceElementPositioningStrategy.Companion.getDEFAULT(), Reflection.getOrCreateKotlinClass(PsiElement.class));
        KtSourceElement ktSourceElement = positionedElement;
        if (ktSourceElement instanceof KtPsiSourceElement) {
            ktDiagnosticWithParameters1 = (KtDiagnosticWithParameters1)new KtPsiDiagnosticWithParameters1((KtPsiSourceElement)positionedElement, argumentFactory.invoke(), debugFactory.getSeverity(), factory, factory.getDefaultPositioningStrategy());
        } else if (ktSourceElement instanceof KtLightSourceElement) {
            ktDiagnosticWithParameters1 = (KtDiagnosticWithParameters1)new KtLightDiagnosticWithParameters1((KtLightSourceElement)positionedElement, argumentFactory.invoke(), debugFactory.getSeverity(), factory, factory.getDefaultPositioningStrategy());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        KtDiagnosticWithParameters1 diagnostic = ktDiagnosticWithParameters1;
        this.result.add((KtDiagnostic)diagnostic);
    }

    private final KtSourceElement getPositionedElement(DebugInfoDiagnosticFactory1 $this$getPositionedElement, KtSourceElement sourceElement) {
        KtSourceElement ktSourceElement;
        IElementType elementType = sourceElement.getElementType();
        if ($this$getPositionedElement == DebugInfoDiagnosticFactory1.Companion.getCALL() && (Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.DOT_QUALIFIED_EXPRESSION) || Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.SAFE_ACCESS_EXPRESSION))) {
            if (sourceElement instanceof KtPsiSourceElement) {
                KtPsiSourceElement ktPsiSourceElement;
                KtExpression psi;
                PsiElement psiElement = ((KtPsiSourceElement)sourceElement).getPsi();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
                KtExpression ktExpression = psi = ((KtQualifiedExpression)psiElement).getSelectorExpression();
                if (ktExpression != null) {
                    KtExpression it = ktExpression;
                    boolean bl = false;
                    ktPsiSourceElement = (KtPsiSourceElement)new KtRealPsiSourceElement((PsiElement)it);
                } else {
                    ktPsiSourceElement = (KtPsiSourceElement)sourceElement;
                }
                ktSourceElement = (KtSourceElement)ktPsiSourceElement;
            } else {
                FlyweightCapableTreeStructure tree = sourceElement.getTreeStructure();
                LighterASTNode selector = LightTreePositioningStrategiesKt.selector((FlyweightCapableTreeStructure)tree, (LighterASTNode)sourceElement.getLighterASTNode());
                if (selector == null) {
                    ktSourceElement = sourceElement;
                } else {
                    int startDelta = tree.getStartOffset((Object)selector) - tree.getStartOffset((Object)sourceElement.getLighterASTNode());
                    int endDelta = tree.getEndOffset((Object)selector) - tree.getEndOffset((Object)sourceElement.getLighterASTNode());
                    ktSourceElement = (KtSourceElement)new KtLightSourceElement(selector, sourceElement.getStartOffset() + startDelta, sourceElement.getEndOffset() + endDelta, tree, null, 16, null);
                }
            }
        } else {
            ktSourceElement = sourceElement;
        }
        return ktSourceElement;
    }

    static {
        Object[] objectArray = new KtSourceElementKind[]{KtRealSourceElementKind.INSTANCE, KtFakeSourceElementKind.DesugaredCompoundAssignment.INSTANCE, KtFakeSourceElementKind.ReferenceInAtomicQualifiedAccess.INSTANCE, KtFakeSourceElementKind.SmartCastExpression.INSTANCE, KtFakeSourceElementKind.DelegatingConstructorCall.INSTANCE, KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE, KtFakeSourceElementKind.ArrayIndexExpressionReference.INSTANCE, KtFakeSourceElementKind.DesugaredPrefixNameReference.INSTANCE, KtFakeSourceElementKind.DesugaredPostfixNameReference.INSTANCE};
        allowedKindsForDebugInfo = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/DebugDiagnosticConsumer$Companion;", "", "()V", "allowedKindsForDebugInfo", "", "Lorg/jetbrains/kotlin/KtSourceElementKind;", "tests-common-new_test"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

