/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.ir;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.test.FirParser;
import org.jetbrains.kotlin.test.backend.handlers.AbstractIrHandler;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirDiagnosticsHandlerKt;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DiagnosticsService;
import org.jetbrains.kotlin.test.services.DiagnosticsServiceKt;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandlerKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/test/backend/ir/IrDiagnosticsHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/AbstractIrHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "diagnosticsService", "Lorg/jetbrains/kotlin/test/services/DiagnosticsService;", "getDiagnosticsService", "()Lorg/jetbrains/kotlin/test/services/DiagnosticsService;", "globalMetadataInfoHandler", "Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "getGlobalMetadataInfoHandler", "()Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "tests-common-new_test"})
public final class IrDiagnosticsHandler
extends AbstractIrHandler {
    public IrDiagnosticsHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, false, 6, null);
    }

    private final GlobalMetadataInfoHandler getGlobalMetadataInfoHandler() {
        return GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler(this.getTestServices());
    }

    private final DiagnosticsService getDiagnosticsService() {
        return DiagnosticsServiceKt.getDiagnosticsService(this.getTestServices());
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull IrBackendInput info) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        IrBackendInput irBackendInput = info;
        if (irBackendInput instanceof IrBackendInput.JvmIrBackendInput) {
            DiagnosticReporter diagnosticReporter = ((IrBackendInput.JvmIrBackendInput)info).getState().getDiagnosticReporter();
            Intrinsics.checkNotNull((Object)diagnosticReporter, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector");
            map = ((BaseDiagnosticsCollector)diagnosticReporter).getDiagnosticsByFilePath();
        } else if (irBackendInput instanceof IrBackendInput.JsIrBackendInput) {
            map = ((IrBackendInput.JsIrBackendInput)info).getDiagnosticsCollector().getDiagnosticsByFilePath();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Map diagnosticsByFilePath = map;
        for (TestModule currentModule : TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules()) {
            boolean lightTreeComparingModeEnabled = currentModule.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getCOMPARE_WITH_LIGHT_TREE());
            boolean lightTreeEnabled = DirectiveKt.singleOrZeroValue(currentModule.getDirectives(), FirDiagnosticsDirectives.INSTANCE.getFIR_PARSER()) == FirParser.LightTree;
            for (TestFile file : currentModule.getFiles()) {
                List diagnostics = (List)diagnosticsByFilePath.get('/' + file.getRelativePath());
                if (diagnostics == null || !(!((Collection)diagnostics).isEmpty())) continue;
                List diagnosticsMetadataInfos = FirDiagnosticsHandlerKt.diagnosticCodeMetaInfos$default(diagnostics, module, file, this.getDiagnosticsService(), this.getGlobalMetadataInfoHandler(), lightTreeEnabled, lightTreeComparingModeEnabled, false, 64, null);
                this.getGlobalMetadataInfoHandler().addMetadataInfosForFile(file, diagnosticsMetadataInfos);
            }
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }
}

