/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.runners.AbstractDiagnosticUsingJavacTest;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="compiler/testData/diagnostics/tests/javac")
@TestDataPath(value="$PROJECT_ROOT")
public class DiagnosticUsingJavacTestGenerated
extends AbstractDiagnosticUsingJavacTest {
    @Test
    public void testAllFilesPresentInJavac() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/javac"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), true, new String[0]);
    }

    @Test
    @TestMetadata(value="Annotations.kt")
    public void testAnnotations() throws Exception {
        this.runTest("compiler/testData/diagnostics/tests/javac/Annotations.kt");
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/tests/javac/typeParameters")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeParameters {
        @Test
        public void testAllFilesPresentInTypeParameters() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/javac/typeParameters"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), true, new String[0]);
        }

        @Test
        @TestMetadata(value="Clash.kt")
        public void testClash() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/typeParameters/Clash.kt");
        }

        @Test
        @TestMetadata(value="ComplexCase.kt")
        public void testComplexCase() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/typeParameters/ComplexCase.kt");
        }

        @Test
        @TestMetadata(value="InheritedInnerAndTypeParameterWithSameNames.kt")
        public void testInheritedInnerAndTypeParameterWithSameNames() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/typeParameters/InheritedInnerAndTypeParameterWithSameNames.kt");
        }

        @Test
        @TestMetadata(value="InnerWithTypeParameter.kt")
        public void testInnerWithTypeParameter() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/typeParameters/InnerWithTypeParameter.kt");
        }

        @Test
        @TestMetadata(value="NestedWithInner.kt")
        public void testNestedWithInner() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/typeParameters/NestedWithInner.kt");
        }

        @Test
        @TestMetadata(value="SeveralInnersWithTypeParameters.kt")
        public void testSeveralInnersWithTypeParameters() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/typeParameters/SeveralInnersWithTypeParameters.kt");
        }

        @Test
        @TestMetadata(value="TypeParametersInInnerAndOuterWithSameNames.kt")
        public void testTypeParametersInInnerAndOuterWithSameNames() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/typeParameters/TypeParametersInInnerAndOuterWithSameNames.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/tests/javac/qualifiedExpression")
    @TestDataPath(value="$PROJECT_ROOT")
    public class QualifiedExpression {
        @Test
        public void testAllFilesPresentInQualifiedExpression() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/javac/qualifiedExpression"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), true, new String[0]);
        }

        @Test
        @TestMetadata(value="GenericClassVsPackage.kt")
        public void testGenericClassVsPackage() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/qualifiedExpression/GenericClassVsPackage.kt");
        }

        @Test
        @TestMetadata(value="PackageVsClass.kt")
        public void testPackageVsClass() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/qualifiedExpression/PackageVsClass.kt");
        }

        @Test
        @TestMetadata(value="PackageVsClass2.kt")
        public void testPackageVsClass2() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/qualifiedExpression/PackageVsClass2.kt");
        }

        @Test
        @TestMetadata(value="PackageVsRootClass.kt")
        public void testPackageVsRootClass() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/qualifiedExpression/PackageVsRootClass.kt");
        }

        @Test
        @TestMetadata(value="visibleClassVsQualifiedClass.kt")
        public void testVisibleClassVsQualifiedClass() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/qualifiedExpression/visibleClassVsQualifiedClass.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/tests/javac/inners")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Inners {
        @Test
        public void testAllFilesPresentInInners() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/javac/inners"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), true, new String[0]);
        }

        @Test
        @TestMetadata(value="ComplexCase.kt")
        public void testComplexCase() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inners/ComplexCase.kt");
        }

        @Test
        @TestMetadata(value="ComplexCase2.kt")
        public void testComplexCase2() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inners/ComplexCase2.kt");
        }

        @Test
        @TestMetadata(value="CurrentPackageAndInner.kt")
        public void testCurrentPackageAndInner() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inners/CurrentPackageAndInner.kt");
        }

        @Test
        @TestMetadata(value="ImportThriceNestedClass.kt")
        public void testImportThriceNestedClass() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inners/ImportThriceNestedClass.kt");
        }

        @Test
        @TestMetadata(value="InnerInInner.kt")
        public void testInnerInInner() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inners/InnerInInner.kt");
        }

        @Test
        @TestMetadata(value="Nested.kt")
        public void testNested() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inners/Nested.kt");
        }

        @Test
        @TestMetadata(value="ThriceNestedClass.kt")
        public void testThriceNestedClass() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inners/ThriceNestedClass.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/tests/javac/inheritance")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Inheritance {
        @Test
        public void testAllFilesPresentInInheritance() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/javac/inheritance"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), true, new String[0]);
        }

        @Test
        @TestMetadata(value="IheritanceOfInner.kt")
        public void testIheritanceOfInner() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/IheritanceOfInner.kt");
        }

        @Test
        @TestMetadata(value="InheritanceAmbiguity.kt")
        public void testInheritanceAmbiguity() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritanceAmbiguity.kt");
        }

        @Test
        @TestMetadata(value="InheritanceAmbiguity2.kt")
        public void testInheritanceAmbiguity2() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritanceAmbiguity2.kt");
        }

        @Test
        @TestMetadata(value="InheritanceAmbiguity3.kt")
        public void testInheritanceAmbiguity3() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritanceAmbiguity3.kt");
        }

        @Test
        @TestMetadata(value="InheritanceAmbiguity4.kt")
        public void testInheritanceAmbiguity4() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritanceAmbiguity4.kt");
        }

        @Test
        @TestMetadata(value="InheritanceWithKotlin.kt")
        public void testInheritanceWithKotlin() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritanceWithKotlin.kt");
        }

        @Test
        @TestMetadata(value="InheritanceWithKotlinClasses.kt")
        public void testInheritanceWithKotlinClasses() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritanceWithKotlinClasses.kt");
        }

        @Test
        @TestMetadata(value="InheritedInner.kt")
        public void testInheritedInner() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritedInner.kt");
        }

        @Test
        @TestMetadata(value="InheritedInner2.kt")
        public void testInheritedInner2() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritedInner2.kt");
        }

        @Test
        @TestMetadata(value="InheritedInnerAndSupertypeWithSameName.kt")
        public void testInheritedInnerAndSupertypeWithSameName() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritedInnerAndSupertypeWithSameName.kt");
        }

        @Test
        @TestMetadata(value="InheritedInnerUsageInInner.kt")
        public void testInheritedInnerUsageInInner() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritedInnerUsageInInner.kt");
        }

        @Test
        @TestMetadata(value="InheritedKotlinInner.kt")
        public void testInheritedKotlinInner() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritedKotlinInner.kt");
        }

        @Test
        @TestMetadata(value="InnerAndInheritedInner.kt")
        public void testInnerAndInheritedInner() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/InnerAndInheritedInner.kt");
        }

        @Test
        @TestMetadata(value="ManyInheritedClasses.kt")
        public void testManyInheritedClasses() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/ManyInheritedClasses.kt");
        }

        @Test
        @TestMetadata(value="SameInnersInSupertypeAndSupertypesSupertype.kt")
        public void testSameInnersInSupertypeAndSupertypesSupertype() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/SameInnersInSupertypeAndSupertypesSupertype.kt");
        }

        @Test
        @TestMetadata(value="SuperTypeWithSameInner.kt")
        public void testSuperTypeWithSameInner() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/SuperTypeWithSameInner.kt");
        }

        @Test
        @TestMetadata(value="SupertypeInnerAndTypeParameterWithSameNames.kt")
        public void testSupertypeInnerAndTypeParameterWithSameNames() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/inheritance/SupertypeInnerAndTypeParameterWithSameNames.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/tests/javac/imports")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Imports {
        @Test
        public void testAllFilesPresentInImports() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/javac/imports"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), true, new String[0]);
        }

        @Test
        @TestMetadata(value="AllUnderImportsAmbiguity.kt")
        public void testAllUnderImportsAmbiguity() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/AllUnderImportsAmbiguity.kt");
        }

        @Test
        @TestMetadata(value="AllUnderImportsLessPriority.kt")
        public void testAllUnderImportsLessPriority() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/AllUnderImportsLessPriority.kt");
        }

        @Test
        @TestMetadata(value="ClassImportsConflicting.kt")
        public void testClassImportsConflicting() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/ClassImportsConflicting.kt");
        }

        @Test
        @TestMetadata(value="CurrentPackageAndAllUnderImport.kt")
        public void testCurrentPackageAndAllUnderImport() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/CurrentPackageAndAllUnderImport.kt");
        }

        @Test
        @TestMetadata(value="CurrentPackageAndExplicitImport.kt")
        public void testCurrentPackageAndExplicitImport() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/CurrentPackageAndExplicitImport.kt");
        }

        @Test
        @TestMetadata(value="CurrentPackageAndExplicitNestedImport.kt")
        public void testCurrentPackageAndExplicitNestedImport() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/CurrentPackageAndExplicitNestedImport.kt");
        }

        @Test
        @TestMetadata(value="CurrentPackageAndNestedAsteriskImport.kt")
        public void testCurrentPackageAndNestedAsteriskImport() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/CurrentPackageAndNestedAsteriskImport.kt");
        }

        @Test
        @TestMetadata(value="ImportGenericVsPackage.kt")
        public void testImportGenericVsPackage() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/ImportGenericVsPackage.kt");
        }

        @Test
        @TestMetadata(value="ImportProtectedClass.kt")
        public void testImportProtectedClass() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/ImportProtectedClass.kt");
        }

        @Test
        @TestMetadata(value="ImportTwoTimes.kt")
        public void testImportTwoTimes() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/ImportTwoTimes.kt");
        }

        @Test
        @TestMetadata(value="ImportTwoTimesStar.kt")
        public void testImportTwoTimesStar() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/ImportTwoTimesStar.kt");
        }

        @Test
        @TestMetadata(value="NestedAndTopLevelClassClash.kt")
        public void testNestedAndTopLevelClassClash() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/NestedAndTopLevelClassClash.kt");
        }

        @Test
        @TestMetadata(value="NestedClassClash.kt")
        public void testNestedClassClash() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/NestedClassClash.kt");
        }

        @Test
        @TestMetadata(value="PackageExplicitAndStartImport.kt")
        public void testPackageExplicitAndStartImport() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/PackageExplicitAndStartImport.kt");
        }

        @Test
        @TestMetadata(value="PackagePrivateAndPublicNested.kt")
        public void testPackagePrivateAndPublicNested() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/PackagePrivateAndPublicNested.kt");
        }

        @Test
        @TestMetadata(value="TopLevelClassVsPackage.kt")
        public void testTopLevelClassVsPackage() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/TopLevelClassVsPackage.kt");
        }

        @Test
        @TestMetadata(value="TopLevelClassVsPackage2.kt")
        public void testTopLevelClassVsPackage2() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/imports/TopLevelClassVsPackage2.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/tests/javac/fieldsResolution")
    @TestDataPath(value="$PROJECT_ROOT")
    public class FieldsResolution {
        @Test
        public void testAllFilesPresentInFieldsResolution() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/javac/fieldsResolution"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), true, new String[0]);
        }

        @Test
        @TestMetadata(value="AsteriskStaticImportsAmbiguity.kt")
        public void testAsteriskStaticImportsAmbiguity() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/AsteriskStaticImportsAmbiguity.kt");
        }

        @Test
        @TestMetadata(value="BinaryInitializers.kt")
        public void testBinaryInitializers() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/BinaryInitializers.kt");
        }

        @Test
        @TestMetadata(value="ConstantByFqName.kt")
        public void testConstantByFqName() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/ConstantByFqName.kt");
        }

        @Test
        @TestMetadata(value="ConstantValues.kt")
        public void testConstantValues() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/ConstantValues.kt");
        }

        @Test
        @TestMetadata(value="ConstantValuesFromKtFile.kt")
        public void testConstantValuesFromKtFile() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/ConstantValuesFromKtFile.kt");
        }

        @Test
        @TestMetadata(value="FieldFromOuterClass.kt")
        public void testFieldFromOuterClass() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/FieldFromOuterClass.kt");
        }

        @Test
        @TestMetadata(value="InheritedField.kt")
        public void testInheritedField() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/InheritedField.kt");
        }

        @Test
        @TestMetadata(value="MultipleOuters.kt")
        public void testMultipleOuters() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/MultipleOuters.kt");
        }

        @Test
        @TestMetadata(value="ResolutionPriority.kt")
        public void testResolutionPriority() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/ResolutionPriority.kt");
        }

        @Test
        @TestMetadata(value="SameFieldInSupertypes.kt")
        public void testSameFieldInSupertypes() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/SameFieldInSupertypes.kt");
        }

        @Test
        @TestMetadata(value="StaticImport.kt")
        public void testStaticImport() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/StaticImport.kt");
        }

        @Test
        @TestMetadata(value="StaticImportsAmbiguity.kt")
        public void testStaticImportsAmbiguity() throws Exception {
            DiagnosticUsingJavacTestGenerated.this.runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/StaticImportsAmbiguity.kt");
        }
    }
}

