/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import com.intellij.lang.LighterASTNode;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.test.frontend.fir.handlers.TreeWithOffset;
import org.jetbrains.kotlin.test.frontend.fir.handlers.VisitorState;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirTreesExtractVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/VisitorState;", "()V", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "tests-common-new_test"})
final class FirTreesExtractVisitor
extends FirVisitor<Unit, VisitorState> {
    @NotNull
    public static final FirTreesExtractVisitor INSTANCE = new FirTreesExtractVisitor();

    private FirTreesExtractVisitor() {
    }

    public void visitElement(@NotNull FirElement element, @NotNull VisitorState data) {
        VisitorState visitorState;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtSourceElement ktSourceElement = element.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        FlyweightCapableTreeStructure currentTree = source.getTreeStructure();
        FlyweightCapableTreeStructure<LighterASTNode> lastTree = data.component1();
        Set<FlyweightCapableTreeStructure<LighterASTNode>> visitedTrees = data.component2();
        List<TreeWithOffset> result = data.component3();
        if (lastTree != currentTree && visitedTrees.add((FlyweightCapableTreeStructure<LighterASTNode>)currentTree)) {
            KtSourceElement ktSourceElement2 = element.getSource();
            TreeWithOffset newTreeWithOffset = new TreeWithOffset((FlyweightCapableTreeStructure<LighterASTNode>)currentTree, ktSourceElement2 != null ? ktSourceElement2.getStartOffset() : 0);
            result.add(newTreeWithOffset);
            visitorState = VisitorState.copy$default(data, lastTree, null, null, 6, null);
        } else {
            visitorState = data;
        }
        VisitorState newData = visitorState;
        element.acceptChildren((FirVisitor)this, (Object)newData);
    }
}

