/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\u001a\u0014\u0010\u0016\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0018\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\"\u0015\u0010\r\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\f\"\u0015\u0010\u000e\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\"\u0015\u0010\u000f\u001a\u00020\u0007*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\t\"\u0015\u0010\u0011\u001a\u00020\u0007*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\t\"\u0015\u0010\u0013\u001a\u00020\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"CUSTOM_TEST_DATA_EXTENSION_PATTERN", "", "FIR_PREFIX", "KT", "KTS", "LL_FIR_PREFIX", "firTestDataFile", "Ljava/io/File;", "getFirTestDataFile", "(Ljava/io/File;)Ljava/io/File;", "isCustomTestData", "", "(Ljava/io/File;)Z", "isFirTestData", "isLLFirTestData", "llFirTestDataFile", "getLlFirTestDataFile", "originalTestDataFile", "getOriginalTestDataFile", "originalTestDataFileName", "getOriginalTestDataFileName", "(Ljava/io/File;)Ljava/lang/String;", "getCustomTestDataFileWithPrefix", "prefix", "getOriginalTestDataFileNameFromPrefix", "isCustomTestDataWithPrefix", "test-infrastructure-utils_test"})
public final class CustomTestDataUtilsKt {
    @NotNull
    private static final String KT = ".kt";
    @NotNull
    private static final String KTS = ".kts";
    @NotNull
    private static final String FIR_PREFIX = ".fir";
    @NotNull
    private static final String LL_FIR_PREFIX = ".ll";
    @NotNull
    public static final String CUSTOM_TEST_DATA_EXTENSION_PATTERN = "^(.+)\\.(fir|ll)\\.kts?$";

    public static final boolean isFirTestData(@NotNull File $this$isFirTestData) {
        Intrinsics.checkNotNullParameter((Object)$this$isFirTestData, (String)"<this>");
        return CustomTestDataUtilsKt.isCustomTestDataWithPrefix($this$isFirTestData, FIR_PREFIX);
    }

    public static final boolean isLLFirTestData(@NotNull File $this$isLLFirTestData) {
        Intrinsics.checkNotNullParameter((Object)$this$isLLFirTestData, (String)"<this>");
        return CustomTestDataUtilsKt.isCustomTestDataWithPrefix($this$isLLFirTestData, LL_FIR_PREFIX);
    }

    public static final boolean isCustomTestData(@NotNull File $this$isCustomTestData) {
        Intrinsics.checkNotNullParameter((Object)$this$isCustomTestData, (String)"<this>");
        return CustomTestDataUtilsKt.isFirTestData($this$isCustomTestData) || CustomTestDataUtilsKt.isLLFirTestData($this$isCustomTestData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isCustomTestDataWithPrefix(File $this$isCustomTestDataWithPrefix, String prefix) {
        String string = $this$isCustomTestDataWithPrefix.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (StringsKt.endsWith$default((String)string, (String)(prefix + KT), (boolean)false, (int)2, null)) return true;
        String string2 = $this$isCustomTestDataWithPrefix.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        if (!StringsKt.endsWith$default((String)string2, (String)(prefix + KTS), (boolean)false, (int)2, null)) return false;
        return true;
    }

    @NotNull
    public static final File getFirTestDataFile(@NotNull File $this$firTestDataFile) {
        Intrinsics.checkNotNullParameter((Object)$this$firTestDataFile, (String)"<this>");
        return CustomTestDataUtilsKt.getCustomTestDataFileWithPrefix($this$firTestDataFile, FIR_PREFIX);
    }

    @NotNull
    public static final File getLlFirTestDataFile(@NotNull File $this$llFirTestDataFile) {
        Intrinsics.checkNotNullParameter((Object)$this$llFirTestDataFile, (String)"<this>");
        return CustomTestDataUtilsKt.getCustomTestDataFileWithPrefix($this$llFirTestDataFile, LL_FIR_PREFIX);
    }

    private static final File getCustomTestDataFileWithPrefix(File $this$getCustomTestDataFileWithPrefix, String prefix) {
        File file;
        if (CustomTestDataUtilsKt.isCustomTestDataWithPrefix($this$getCustomTestDataFileWithPrefix, prefix)) {
            file = $this$getCustomTestDataFileWithPrefix;
        } else {
            String originalName = CustomTestDataUtilsKt.getOriginalTestDataFileName($this$getCustomTestDataFileWithPrefix);
            String customName = StringsKt.endsWith$default((String)originalName, (String)KTS, (boolean)false, (int)2, null) ? StringsKt.removeSuffix((String)originalName, (CharSequence)KTS) + prefix + KTS : StringsKt.removeSuffix((String)originalName, (CharSequence)KT) + prefix + KT;
            File file2 = $this$getCustomTestDataFileWithPrefix.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"parentFile");
            file = FilesKt.resolve((File)file2, (String)customName);
        }
        return file;
    }

    @NotNull
    public static final File getOriginalTestDataFile(@NotNull File $this$originalTestDataFile) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$originalTestDataFile, (String)"<this>");
        String originalName = CustomTestDataUtilsKt.getOriginalTestDataFileName($this$originalTestDataFile);
        if (!Intrinsics.areEqual((Object)originalName, (Object)$this$originalTestDataFile.getName())) {
            File file2 = $this$originalTestDataFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"parentFile");
            file = FilesKt.resolve((File)file2, (String)originalName);
        } else {
            file = $this$originalTestDataFile;
        }
        return file;
    }

    @NotNull
    public static final String getOriginalTestDataFileName(@NotNull File $this$originalTestDataFileName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$originalTestDataFileName, (String)"<this>");
        if (CustomTestDataUtilsKt.isLLFirTestData($this$originalTestDataFileName)) {
            string = CustomTestDataUtilsKt.getOriginalTestDataFileNameFromPrefix($this$originalTestDataFileName, LL_FIR_PREFIX);
        } else if (CustomTestDataUtilsKt.isFirTestData($this$originalTestDataFileName)) {
            string = CustomTestDataUtilsKt.getOriginalTestDataFileNameFromPrefix($this$originalTestDataFileName, FIR_PREFIX);
        } else {
            String string2 = $this$originalTestDataFileName.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        }
        return string;
    }

    private static final String getOriginalTestDataFileNameFromPrefix(File $this$getOriginalTestDataFileNameFromPrefix, String prefix) {
        String string;
        String string2 = $this$getOriginalTestDataFileNameFromPrefix.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        if (StringsKt.endsWith$default((String)string2, (String)KTS, (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = $this$getOriginalTestDataFileNameFromPrefix.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
            string = stringBuilder.append(StringsKt.removeSuffix((String)string3, (CharSequence)(prefix + KTS))).append(KTS).toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = $this$getOriginalTestDataFileNameFromPrefix.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name");
            string = stringBuilder.append(StringsKt.removeSuffix((String)string4, (CharSequence)(prefix + KT))).append(KT).toString();
        }
        return string;
    }
}

