/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.deserialization.ModuleDataProvider;
import org.jetbrains.kotlin.fir.extensions.FirExtensionRegistrar;
import org.jetbrains.kotlin.fir.java.FirProjectSessionProvider;
import org.jetbrains.kotlin.fir.session.FirJsSessionFactory;
import org.jetbrains.kotlin.fir.session.FirSessionConfigurator;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.ir.backend.js.JsLibraryResolverKt;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.library.metadata.resolver.KotlinLibraryResolveResult;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.test.frontend.fir.TestFirJsSessionFactoryKt;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u0014Jc\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u00142\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0002\b \u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/TestFirJsSessionFactory;", "", "()V", "createLibrarySession", "Lorg/jetbrains/kotlin/fir/FirSession;", "mainModuleName", "Lorg/jetbrains/kotlin/name/Name;", "sessionProvider", "Lorg/jetbrains/kotlin/fir/java/FirProjectSessionProvider;", "moduleDataProvider", "Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "registerExtraComponents", "Lkotlin/Function1;", "", "createModuleBasedSession", "mainModuleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "extensionRegistrars", "", "Lorg/jetbrains/kotlin/fir/extensions/FirExtensionRegistrar;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "sessionConfigurator", "Lorg/jetbrains/kotlin/fir/session/FirSessionConfigurator;", "Lkotlin/ExtensionFunctionType;", "tests-common-new_test"})
public final class TestFirJsSessionFactory {
    @NotNull
    public static final TestFirJsSessionFactory INSTANCE = new TestFirJsSessionFactory();

    private TestFirJsSessionFactory() {
    }

    @NotNull
    public final FirSession createLibrarySession(@NotNull Name mainModuleName, @NotNull FirProjectSessionProvider sessionProvider, @NotNull ModuleDataProvider moduleDataProvider, @NotNull TestModule module, @NotNull TestServices testServices, @NotNull CompilerConfiguration configuration2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Function1<? super FirSession, Unit> registerExtraComponents) {
        Intrinsics.checkNotNullParameter((Object)mainModuleName, (String)"mainModuleName");
        Intrinsics.checkNotNullParameter((Object)sessionProvider, (String)"sessionProvider");
        Intrinsics.checkNotNullParameter((Object)moduleDataProvider, (String)"moduleDataProvider");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter(registerExtraComponents, (String)"registerExtraComponents");
        Collection collection = (Collection)configuration2.get(JSConfigurationKeys.REPOSITORIES);
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Collection repositories = collection;
        Logger logger = KlibKt.getResolverLogger((CompilerConfiguration)configuration2);
        List<String> libraries = TestFirJsSessionFactoryKt.getAllJsDependenciesPaths(module, testServices);
        List resolvedLibraries = KotlinLibraryResolveResult.getFullResolvedList$default((KotlinLibraryResolveResult)JsLibraryResolverKt.jsResolveLibraries((Collection)libraries, (Collection)repositories, (Logger)logger), null, (int)1, null);
        return FirJsSessionFactory.INSTANCE.createJsLibrarySession(mainModuleName, resolvedLibraries, sessionProvider, moduleDataProvider, languageVersionSettings, registerExtraComponents);
    }

    @NotNull
    public final FirSession createModuleBasedSession(@NotNull FirModuleData mainModuleData, @NotNull FirProjectSessionProvider sessionProvider, @NotNull List<? extends FirExtensionRegistrar> extensionRegistrars, @NotNull LanguageVersionSettings languageVersionSettings, @Nullable LookupTracker lookupTracker, @NotNull Function1<? super FirSession, Unit> registerExtraComponents, @NotNull Function1<? super FirSessionConfigurator, Unit> sessionConfigurator2) {
        Intrinsics.checkNotNullParameter((Object)mainModuleData, (String)"mainModuleData");
        Intrinsics.checkNotNullParameter((Object)sessionProvider, (String)"sessionProvider");
        Intrinsics.checkNotNullParameter(extensionRegistrars, (String)"extensionRegistrars");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter(registerExtraComponents, (String)"registerExtraComponents");
        Intrinsics.checkNotNullParameter(sessionConfigurator2, (String)"sessionConfigurator");
        return FirJsSessionFactory.INSTANCE.createJsModuleBasedSession(mainModuleData, sessionProvider, extensionRegistrars, languageVersionSettings, lookupTracker, registerExtraComponents, sessionConfigurator2);
    }
}

