/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.backend.handlers.DebugRunner;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.LocalNullValue;
import org.jetbrains.kotlin.test.utils.LocalPrimitive;
import org.jetbrains.kotlin.test.utils.LocalReference;
import org.jetbrains.kotlin.test.utils.LocalValue;
import org.jetbrains.kotlin.test.utils.LocalVariableRecord;
import org.jetbrains.kotlin.test.utils.SteppingTestLoggedData;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner;", "Lorg/jetbrains/kotlin/test/backend/handlers/DebugRunner;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "storeStep", "", "loggedItems", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/test/utils/SteppingTestLoggedData;", "Lkotlin/collections/ArrayList;", "event", "Lcom/sun/jdi/event/Event;", "toRecord", "Lorg/jetbrains/kotlin/test/utils/LocalVariableRecord;", "frame", "Lcom/sun/jdi/StackFrame;", "variable", "Lcom/sun/jdi/LocalVariable;", "waitUntil", "condition", "Lkotlin/Function0;", "", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nDebugRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugRunner.kt\norg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n1549#2:249\n1620#2,3:250\n*S KotlinDebug\n*F\n+ 1 DebugRunner.kt\norg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner\n*L\n234#1:249\n234#1:250,3\n*E\n"})
public final class LocalVariableDebugRunner
extends DebugRunner {
    public LocalVariableDebugRunner(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    private final LocalVariableRecord toRecord(StackFrame frame, LocalVariable variable) {
        LocalValue localValue;
        Value value = frame.getValue(variable);
        if (value == null) {
            localValue = LocalNullValue.INSTANCE;
        } else if (value instanceof ObjectReference && !Intrinsics.areEqual((Object)((ObjectReference)value).referenceType().name(), (Object)"java.lang.String")) {
            String string = String.valueOf(((ObjectReference)value).uniqueID());
            String string2 = ((ObjectReference)value).referenceType().name();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.referenceType().name()");
            localValue = new LocalReference(string, string2);
        } else {
            String string = value.toString();
            String string3 = value.type().name();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"value.type().name()");
            localValue = new LocalPrimitive(string, string3);
        }
        LocalValue valueRecord = localValue;
        String string = variable.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variable.name()");
        return new LocalVariableRecord(string, variable.typeName(), valueRecord);
    }

    private final void waitUntil(Function0<Boolean> condition) {
        while (!((Boolean)condition.invoke()).booleanValue()) {
            Thread.sleep(10L);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void storeStep(@NotNull ArrayList<SteppingTestLoggedData> loggedItems, @NotNull Event event) {
        List list;
        Intrinsics.checkNotNullParameter(loggedItems, (String)"loggedItems");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LocatableEvent locatableEvent = (LocatableEvent)event;
        this.waitUntil((Function0<Boolean>)((Function0)new Function0<Boolean>(locatableEvent){
            final /* synthetic */ LocatableEvent $locatableEvent;
            {
                this.$locatableEvent = $locatableEvent;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$locatableEvent.thread().isSuspended();
            }
        }));
        Location location = locatableEvent.location();
        if (location.method().isSynthetic()) {
            return;
        }
        StackFrame frame = locatableEvent.thread().frame(0);
        try {
            void $this$mapTo$iv$iv;
            List<LocalVariable> list2 = frame.visibleVariables();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"frame.visibleVariables()");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void variable;
                LocalVariable localVariable = (LocalVariable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)frame, (String)"frame");
                Intrinsics.checkNotNullExpressionValue((Object)variable, (String)"variable");
                collection.add(this.toRecord(frame, (LocalVariable)variable));
            }
            list = (List)destination$iv$iv;
        }
        catch (AbsentInformationException e) {
            list = CollectionsKt.emptyList();
        }
        List visibleVars = list;
        int n = location.lineNumber();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location");
        loggedItems.add(new SteppingTestLoggedData(n, false, this.formatAsExpectation(location, visibleVars)));
    }
}

