/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH$J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\u000b\u001a\u00020\fH$\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/test/frontend/AbstractFailingTestSuppressor;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "hasFailure", "", "failedAssertions", "", "Lorg/jetbrains/kotlin/test/WrappedException;", "suppressIfNeeded", "testFile", "Ljava/io/File;", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nAbstractFailingTestSuppressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractFailingTestSuppressor.kt\norg/jetbrains/kotlin/test/frontend/AbstractFailingTestSuppressor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1#2:32\n*E\n"})
public abstract class AbstractFailingTestSuppressor
extends AfterAnalysisChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String INCONSISTENT_DIAGNOSTICS = "INCONSISTENT_DIAGNOSTICS";

    public AbstractFailingTestSuppressor(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @NotNull
    protected abstract File testFile();

    protected abstract boolean hasFailure(@NotNull List<? extends WrappedException> var1);

    @Override
    @NotNull
    public List<WrappedException> suppressIfNeeded(@NotNull List<? extends WrappedException> failedAssertions) {
        File file;
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        File file2 = this.testFile().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"testFile().parentFile");
        File it = file = FilesKt.resolve((File)file2, (String)(FilesKt.getNameWithoutExtension((File)this.testFile()) + ".fail"));
        boolean bl = false;
        File file3 = it.exists() ? file : null;
        if (file3 == null) {
            return failedAssertions;
        }
        File failFile = file3;
        String failReason = ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)failFile, null, (int)1, null))).toString();
        if (this.hasFailure(failedAssertions) || Intrinsics.areEqual((Object)failReason, (Object)INCONSISTENT_DIAGNOSTICS)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)failedAssertions, (Object)this.wrap((Throwable)((Object)new AssertionError((Object)("Fail file exists but no exception was thrown. Please remove " + failFile.getName())))));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/test/frontend/AbstractFailingTestSuppressor$Companion;", "", "()V", "INCONSISTENT_DIAGNOSTICS", "", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

