/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.classic;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CodegenTestUtil;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.test.JvmCompilationUtils;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManagerKt;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ<\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/test/backend/classic/JavaCompilerFacade;", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "compileJavaFiles", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "classFileFactory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "files", "", "Ljava/io/File;", "javacOptions", "", "ignoreErrors", "", "extractJavacOptions", "kotlinTarget", "isJvmPreviewEnabled", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nJavaCompilerFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCompilerFacade.kt\norg/jetbrains/kotlin/test/backend/classic/JavaCompilerFacade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1549#2:92\n1620#2,3:93\n*S KotlinDebug\n*F\n+ 1 JavaCompilerFacade.kt\norg/jetbrains/kotlin/test/backend/classic/JavaCompilerFacade\n*L\n28#1:92\n28#1:93,3\n*E\n"})
public final class JavaCompilerFacade {
    @NotNull
    private final TestServices testServices;

    public JavaCompilerFacade(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
    }

    /*
     * WARNING - void declaration
     */
    public final void compileJavaFiles(@NotNull TestModule module, @NotNull CompilerConfiguration configuration2, @NotNull ClassFileFactory classFileFactory) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)classFileFactory, (String)"classFileFactory");
        if (SourceFileProviderKt.getJavaFiles(module).isEmpty()) {
            return;
        }
        Iterable iterable = JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)configuration2);
        Collection collection = CollectionsKt.listOf((Object)CompiledClassesManagerKt.getCompiledClassesManager(this.testServices).getCompiledKotlinDirForModule(module, classFileFactory).getPath());
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getAbsolutePath());
        }
        List javaClasspath = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        File javaClassesOutputDirectory = CompiledClassesManagerKt.getCompiledClassesManager(this.testServices).getOrCreateCompiledJavaDirForModule(module);
        List<String> javacOptions = this.extractJavacOptions(module, (JvmTarget)configuration2.get(JVMConfigurationKeys.JVM_TARGET), configuration2.getBoolean(JVMConfigurationKeys.ENABLE_JVM_PREVIEW));
        List<String> list = CodegenTestUtil.prepareJavacOptions(javaClasspath, javacOptions, javaClassesOutputDirectory);
        Intrinsics.checkNotNullExpressionValue(list, (String)"prepareJavacOptions(\n   \u2026OutputDirectory\n        )");
        List<String> finalJavacOptions = list;
        List<File> javaFiles = SourceFileProviderKt.getRealJavaFiles(SourceFileProviderKt.getSourceFileProvider(this.testServices), module);
        boolean ignoreErrors = module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_JAVA_ERRORS());
        JvmTarget jvmTarget = (JvmTarget)configuration2.get(JVMConfigurationKeys.JVM_TARGET);
        if (jvmTarget == null) {
            jvmTarget = JvmTarget.DEFAULT;
        }
        Intrinsics.checkNotNullExpressionValue((Object)jvmTarget, (String)"configuration[JVMConfigu\u2026GET] ?: JvmTarget.DEFAULT");
        this.compileJavaFiles(module, jvmTarget, javaFiles, finalJavacOptions, ignoreErrors);
    }

    private final List<String> extractJavacOptions(TestModule module, JvmTarget kotlinTarget, boolean isJvmPreviewEnabled) {
        List list;
        block1: {
            List $this$extractJavacOptions_u24lambda_u242;
            block0: {
                $this$extractJavacOptions_u24lambda_u242 = list = CollectionsKt.createListBuilder();
                boolean bl = false;
                $this$extractJavacOptions_u24lambda_u242.addAll((Collection)module.getDirectives().get(CodegenTestDirectives.INSTANCE.getJAVAC_OPTIONS()));
                if (kotlinTarget == null || !isJvmPreviewEnabled) break block0;
                $this$extractJavacOptions_u24lambda_u242.add("--release");
                $this$extractJavacOptions_u24lambda_u242.add(kotlinTarget.getDescription());
                $this$extractJavacOptions_u24lambda_u242.add("--enable-preview");
                break block1;
            }
            String string = CodegenTestUtil.computeJavaTarget($this$extractJavacOptions_u24lambda_u242, kotlinTarget);
            if (string == null) break block1;
            String javaTarget = string;
            boolean bl = false;
            $this$extractJavacOptions_u24lambda_u242.add("-source");
            Intrinsics.checkNotNullExpressionValue((Object)javaTarget, (String)"javaTarget");
            $this$extractJavacOptions_u24lambda_u242.add(javaTarget);
            $this$extractJavacOptions_u24lambda_u242.add("-target");
            $this$extractJavacOptions_u24lambda_u242.add(javaTarget);
        }
        return CollectionsKt.build((List)list);
    }

    private final void compileJavaFiles(TestModule module, JvmTarget jvmTarget, List<? extends File> files, List<String> javacOptions, boolean ignoreErrors) {
        File file;
        boolean targetIsJava8OrLower;
        String string = System.getProperty("java.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"java.version\")");
        boolean bl = targetIsJava8OrLower = StringsKt.startsWith$default((String)string, (String)"1.", (boolean)false, (int)2, null) && jvmTarget.compareTo((Enum)JvmTarget.JVM_1_6) <= 0;
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getUSE_JAVAC_BASED_ON_JVM_TARGET()) || targetIsJava8OrLower) {
            JvmCompilationUtils.compileJavaFiles$default(files, javacOptions, null, AssertionsKt.getAssertions(this.testServices), ignoreErrors, 4, null);
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[jvmTarget.ordinal()]) {
            case 1: {
                file = KtTestUtil.getJdk6Home();
                break;
            }
            case 2: {
                file = KtTestUtil.getJdk8Home();
                break;
            }
            case 3: 
            case 4: {
                file = KtTestUtil.getJdk11Home();
                break;
            }
            case 5: 
            case 6: {
                file = KtTestUtil.getJdk17Home();
                break;
            }
            default: {
                file = null;
            }
        }
        if (file == null) {
            throw new IllegalStateException(("JDK for " + jvmTarget + " is not found").toString());
        }
        File jdkHome = file;
        JvmCompilationUtils.compileJavaFilesExternally((Collection<? extends File>)files, javacOptions, jdkHome);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JvmTarget.values().length];
            try {
                nArray[JvmTarget.JVM_1_6.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmTarget.JVM_1_8.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmTarget.JVM_9.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmTarget.JVM_11.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmTarget.JVM_15.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmTarget.JVM_17.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

