/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.TestConfiguration;
import org.jetbrains.kotlin.test.TestRunner;
import org.jetbrains.kotlin.test.TestStep;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.AnalysisHandler;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.DependencyProviderImpl;
import org.jetbrains.kotlin.test.services.ExceptionFromModuleStructureTransformer;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandlerKt;
import org.jetbrains.kotlin.test.services.MetaTestConfigurator;
import org.jetbrains.kotlin.test.services.PreAnalysisHandler;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.TestServicesKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J$\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u001dJ\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018J+\u0010\"\u001a\u00020\u00102\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00070\u001d2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0082\bJ4\u0010&\u001a\u0006\u0012\u0002\b\u00030'*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030(2\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010+\u001a\u00020\u0010H\u0002JH\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030'\"\u000e\b\u0000\u0010,*\b\u0012\u0004\u0012\u0002H,0**\f\u0012\u0004\u0012\u0002H,\u0012\u0002\b\u00030(2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H,0*2\u0006\u0010+\u001a\u00020\u0010H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/test/TestRunner;", "", "testConfiguration", "Lorg/jetbrains/kotlin/test/TestConfiguration;", "(Lorg/jetbrains/kotlin/test/TestConfiguration;)V", "allFailedExceptions", "", "Lorg/jetbrains/kotlin/test/WrappedException;", "allRanHandlers", "", "Lorg/jetbrains/kotlin/test/model/AnalysisHandler;", "filterFailedExceptions", "", "", "failedExceptions", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "dependencyProvider", "Lorg/jetbrains/kotlin/test/services/DependencyProviderImpl;", "reportFailures", "", "services", "Lorg/jetbrains/kotlin/test/services/TestServices;", "runTest", "testDataFileName", "", "beforeDispose", "Lkotlin/Function1;", "runTestImpl", "runTestPipeline", "moduleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "withAssertionCatching", "exceptionWrapper", "block", "Lkotlin/Function0;", "hackyProcessModule", "Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "Lorg/jetbrains/kotlin/test/TestStep;", "inputArtifact", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "thereWereExceptionsOnPreviousSteps", "I", "artifact", "Companion", "test-infrastructure"})
public final class TestRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestConfiguration testConfiguration;
    @NotNull
    private final List<WrappedException> allFailedExceptions;
    @NotNull
    private final Set<AnalysisHandler<?>> allRanHandlers;

    public TestRunner(@NotNull TestConfiguration testConfiguration) {
        Intrinsics.checkNotNullParameter((Object)testConfiguration, (String)"testConfiguration");
        this.testConfiguration = testConfiguration;
        this.allFailedExceptions = new ArrayList();
        this.allRanHandlers = new LinkedHashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runTest(@NotNull String testDataFileName, @NotNull Function1<? super TestConfiguration, Unit> beforeDispose) {
        Intrinsics.checkNotNullParameter((Object)testDataFileName, (String)"testDataFileName");
        Intrinsics.checkNotNullParameter(beforeDispose, (String)"beforeDispose");
        try {
            this.runTestImpl(testDataFileName);
        }
        finally {
            try {
                TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(this.testConfiguration.getTestServices()).cleanupTemporaryDirectories();
            }
            catch (IOException iOException) {}
            beforeDispose.invoke((Object)this.testConfiguration);
            Disposer.dispose((Disposable)this.testConfiguration.getRootDisposable());
        }
    }

    public static /* synthetic */ void runTest$default(TestRunner testRunner, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = runTest.1.INSTANCE;
        }
        testRunner.runTest(string, (Function1<? super TestConfiguration, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final void runTestImpl(String testDataFileName) {
        TestServices services = this.testConfiguration.getTestServices();
        Iterable $this$fold$iv = this.testConfiguration.getMetaTestConfigurators();
        boolean $i$f$fold = false;
        String accumulator$iv = testDataFileName;
        for (Object element$iv : $this$fold$iv) {
            void configurator;
            MetaTestConfigurator metaTestConfigurator = (MetaTestConfigurator)element$iv;
            String fileName = accumulator$iv;
            boolean bl = false;
            accumulator$iv = configurator.transformTestDataPath(fileName);
        }
        String testDataFileName2 = accumulator$iv;
        try {
            TestModuleStructure it = $i$f$fold = this.testConfiguration.getModuleStructureExtractor().splitTestDataByModules(testDataFileName2, this.testConfiguration.getDirectives());
            boolean bl = false;
            services.register((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(TestModuleStructure.class), it);
        }
        catch (ExceptionFromModuleStructureTransformer e) {
            services.register((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(TestModuleStructure.class), e.getAlreadyParsedModuleStructure());
            Throwable throwable = (Throwable)CollectionsKt.singleOrNull(this.filterFailedExceptions(CollectionsKt.listOf((Object)new WrappedException.FromModuleStructureTransformer(e.getCause()))));
            if (throwable == null) {
                return;
            }
            Throwable exception = throwable;
            throw exception;
        }
        TestModuleStructure moduleStructure = $i$f$fold;
        Iterable $this$forEach$iv = this.testConfiguration.getMetaTestConfigurators();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetaTestConfigurator it = (MetaTestConfigurator)element$iv;
            boolean bl = false;
            if (!it.shouldSkipTest()) continue;
            return;
        }
        this.runTestPipeline(moduleStructure, services);
    }

    /*
     * WARNING - void declaration
     */
    public final void runTestPipeline(@NotNull TestModuleStructure moduleStructure, @NotNull TestServices services) {
        TestModule module;
        boolean shouldProcessNextModules;
        PreAnalysisHandler preprocessor;
        Object element$iv;
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        Intrinsics.checkNotNullParameter((Object)((Object)services), (String)"services");
        GlobalMetadataInfoHandler globalMetadataInfoHandler = GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler(this.testConfiguration.getTestServices());
        globalMetadataInfoHandler.parseExistingMetadataInfosFromAllSources();
        List<TestModule> modules = moduleStructure.getModules();
        DependencyProviderImpl dependencyProvider = new DependencyProviderImpl(services, modules);
        TestServicesKt.registerDependencyProvider(services, dependencyProvider);
        Object $this$forEach$iv = this.testConfiguration.getPreAnalysisHandlers();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            preprocessor = (PreAnalysisHandler)element$iv;
            boolean bl = false;
            preprocessor.preprocessModuleStructure(moduleStructure);
        }
        $this$forEach$iv = this.testConfiguration.getPreAnalysisHandlers();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            preprocessor = (PreAnalysisHandler)element$iv;
            boolean bl = false;
            preprocessor.prepareSealedClassInheritors(moduleStructure);
        }
        $this$forEach$iv = modules.iterator();
        while ($this$forEach$iv.hasNext() && (shouldProcessNextModules = this.processModule(module = (TestModule)$this$forEach$iv.next(), dependencyProvider))) {
        }
        for (AnalysisHandler<?> handler : this.allRanHandlers) {
            boolean bl;
            Function1 wrapperFactory2 = (Function1)new Function1<Throwable, WrappedException.FromHandler>(handler){
                final /* synthetic */ AnalysisHandler<?> $handler;
                {
                    this.$handler = $handler;
                    super(1);
                }

                @NotNull
                public final WrappedException.FromHandler invoke(@NotNull Throwable it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new WrappedException.FromHandler(it, this.$handler);
                }
            };
            TestRunner this_$iv = this;
            boolean $i$f$withAssertionCatching2 = false;
            try {
                boolean thereWasAnException;
                boolean bl2 = false;
                boolean bl3 = thereWasAnException = !((Collection)this.allFailedExceptions).isEmpty();
                if (Companion.shouldRun(handler, thereWasAnException)) {
                    handler.processAfterAllModules(thereWasAnException);
                }
                bl = false;
            }
            catch (Throwable e$iv) {
                ((Collection)this_$iv.allFailedExceptions).add(wrapperFactory2.invoke((Object)e$iv));
                bl = true;
            }
        }
        if (this.testConfiguration.getMetaInfoHandlerEnabled()) {
            boolean this_$iv;
            TestRunner this_$iv2 = this;
            boolean $i$f$withAssertionCatching = false;
            try {
                boolean bl = false;
                globalMetadataInfoHandler.compareAllMetaDataInfos();
                this_$iv = false;
            }
            catch (Throwable e$iv) {
                void p0;
                Throwable $i$f$withAssertionCatching2 = e$iv;
                Collection collection = this_$iv2.allFailedExceptions;
                boolean bl = false;
                collection.add(new WrappedException.FromMetaInfoHandler((Throwable)p0));
                this_$iv = true;
            }
        }
        $this$forEach$iv = this.testConfiguration.getAfterAnalysisCheckers();
        $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            Object element$iv2 = iterator2.next();
            AfterAnalysisChecker it = (AfterAnalysisChecker)element$iv2;
            boolean bl4 = false;
            TestRunner this_$iv = this;
            boolean $i$f$withAssertionCatching = false;
            try {
                boolean bl5 = false;
                it.check(this.allFailedExceptions);
                bl = false;
            }
            catch (Throwable e$iv) {
                void p0;
                Throwable bl5 = e$iv;
                Collection collection = this_$iv.allFailedExceptions;
                boolean bl6 = false;
                collection.add(new WrappedException.FromAfterAnalysisChecker((Throwable)p0));
                bl = true;
            }
        }
        this.reportFailures(services);
    }

    public final void reportFailures(@NotNull TestServices services) {
        Object v0;
        List<Throwable> filteredFailedAssertions;
        block2: {
            Intrinsics.checkNotNullParameter((Object)((Object)services), (String)"services");
            filteredFailedAssertions = this.filterFailedExceptions(this.allFailedExceptions);
            Iterable $this$firstIsInstanceOrNull$iv = filteredFailedAssertions;
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof WrappedException.FromFacade)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        WrappedException.FromFacade fromFacade = v0;
        if (fromFacade != null) {
            WrappedException.FromFacade it = fromFacade;
            boolean bl = false;
            throw it;
        }
        AssertionsKt.getAssertions(services).assertAll(filteredFailedAssertions);
    }

    public final boolean processModule(@NotNull TestModule module, @NotNull DependencyProviderImpl dependencyProvider) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)dependencyProvider, (String)"dependencyProvider");
        ResultingArtifact<Object> inputArtifact = (ResultingArtifact)this.testConfiguration.getStartingArtifactFactory().invoke((Object)module);
        for (TestStep<?, ?> step2 : this.testConfiguration.getSteps()) {
            if (!step2.shouldProcessModule(module, inputArtifact)) continue;
            TestStep.StepResult<?> result = this.hackyProcessModule(step2, module, inputArtifact, !((Collection)this.allFailedExceptions).isEmpty());
            if (result instanceof TestStep.StepResult.Artifact) {
                if (!(step2 instanceof TestStep.FacadeStep)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!Intrinsics.areEqual(step2.getInputArtifactKind(), ((TestStep.FacadeStep)step2).getOutputArtifactKind())) {
                    dependencyProvider.registerArtifact(module, ((TestStep.StepResult.Artifact)result).getOutputArtifact());
                }
                inputArtifact = ((TestStep.StepResult.Artifact)result).getOutputArtifact();
                continue;
            }
            if (result instanceof TestStep.StepResult.ErrorFromFacade) {
                ((Collection)this.allFailedExceptions).add(((TestStep.StepResult.ErrorFromFacade)result).getException());
                return false;
            }
            if (result instanceof TestStep.StepResult.HandlersResult) {
                Collection<WrappedException> exceptionsFromHandlers = ((TestStep.StepResult.HandlersResult)result).component1();
                boolean shouldRunNextSteps = ((TestStep.StepResult.HandlersResult)result).component2();
                if (!(step2 instanceof TestStep.HandlersStep)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                CollectionsKt.addAll((Collection)this.allRanHandlers, (Iterable)((TestStep.HandlersStep)step2).getHandlers());
                CollectionsKt.addAll((Collection)this.allFailedExceptions, (Iterable)exceptionsFromHandlers);
                if (shouldRunNextSteps) continue;
                return false;
            }
            if (!(result instanceof TestStep.StepResult.NoArtifactFromFacade)) continue;
            return false;
        }
        return true;
    }

    private final boolean withAssertionCatching(Function1<? super Throwable, ? extends WrappedException> exceptionWrapper, Function0<Unit> block) {
        boolean bl;
        boolean $i$f$withAssertionCatching = false;
        try {
            block.invoke();
            bl = false;
        }
        catch (Throwable e) {
            ((Collection)this.allFailedExceptions).add(exceptionWrapper.invoke((Object)e));
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Throwable> filterFailedExceptions(List<? extends WrappedException> failedExceptions) {
        void $this$mapTo$iv$iv;
        Iterable $this$fold$iv = this.testConfiguration.getAfterAnalysisCheckers();
        boolean $i$f$fold = false;
        Iterable<WrappedException> accumulator$iv = failedExceptions;
        for (Object element$iv : $this$fold$iv) {
            void checker;
            AfterAnalysisChecker afterAnalysisChecker = (AfterAnalysisChecker)element$iv;
            List<? extends WrappedException> assertions = accumulator$iv;
            boolean bl = false;
            accumulator$iv = checker.suppressIfNeeded(assertions);
        }
        Iterable $this$map$iv = CollectionsKt.sorted((Iterable)accumulator$iv);
        boolean $i$f$map = false;
        accumulator$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WrappedException bl = (WrappedException)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getCause());
        }
        return (List)destination$iv$iv;
    }

    private final TestStep.StepResult<?> hackyProcessModule(TestStep<?, ?> $this$hackyProcessModule, TestModule module, ResultingArtifact<?> inputArtifact, boolean thereWereExceptionsOnPreviousSteps) {
        Intrinsics.checkNotNull($this$hackyProcessModule, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.test.TestStep<org.jetbrains.kotlin.test.model.ResultingArtifact.Source, *>");
        Intrinsics.checkNotNull(inputArtifact, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.test.model.ResultingArtifact<org.jetbrains.kotlin.test.model.ResultingArtifact.Source>");
        return this.processModule($this$hackyProcessModule, module, inputArtifact, thereWereExceptionsOnPreviousSteps);
    }

    private final <I extends ResultingArtifact<I>> TestStep.StepResult<?> processModule(TestStep<I, ?> $this$processModule, TestModule module, ResultingArtifact<I> artifact, boolean thereWereExceptionsOnPreviousSteps) {
        Intrinsics.checkNotNull(artifact, (String)"null cannot be cast to non-null type I of org.jetbrains.kotlin.test.TestRunner.processModule");
        return $this$processModule.processModule(module, artifact, thereWereExceptionsOnPreviousSteps);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/test/TestRunner$Companion;", "", "()V", "shouldRun", "", "Lorg/jetbrains/kotlin/test/model/AnalysisHandler;", "thereWasAnException", "test-infrastructure"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean shouldRun(@NotNull AnalysisHandler<?> $this$shouldRun, boolean thereWasAnException) {
            Intrinsics.checkNotNullParameter($this$shouldRun, (String)"<this>");
            return !$this$shouldRun.getDoNotRunIfThereWerePreviousFailures() || !thereWasAnException;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

