/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.generators.model;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.generators.model.MethodModel;
import org.jetbrains.kotlin.generators.util.TestGeneratorUtil;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001:\u0001 BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001f\u001a\u00020\bH\u0016R\u0014\u0010\u0010\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/generators/model/SimpleTestMethodModel;", "Lorg/jetbrains/kotlin/generators/model/MethodModel;", "rootDir", "Ljava/io/File;", "file", "filenamePattern", "Ljava/util/regex/Pattern;", "checkFilenameStartsLowerCase", "", "targetBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "skipIgnored", "tags", "", "", "(Ljava/io/File;Ljava/io/File;Ljava/util/regex/Pattern;Ljava/lang/Boolean;Lorg/jetbrains/kotlin/test/TargetBackend;ZLjava/util/List;)V", "dataString", "getDataString", "()Ljava/lang/String;", "getFile", "()Ljava/io/File;", "kind", "Lorg/jetbrains/kotlin/generators/model/MethodModel$Kind;", "getKind", "()Lorg/jetbrains/kotlin/generators/model/MethodModel$Kind;", "name", "getName", "getTags", "()Ljava/util/List;", "getTargetBackend$test_generator", "()Lorg/jetbrains/kotlin/test/TargetBackend;", "shouldBeGenerated", "Kind", "test-generator"})
public class SimpleTestMethodModel
implements MethodModel {
    @NotNull
    private final File rootDir;
    @NotNull
    private final File file;
    @NotNull
    private final Pattern filenamePattern;
    @NotNull
    private final TargetBackend targetBackend;
    private final boolean skipIgnored;
    @NotNull
    private final List<String> tags;

    public SimpleTestMethodModel(@NotNull File rootDir, @NotNull File file, @NotNull Pattern filenamePattern, @Nullable Boolean checkFilenameStartsLowerCase, @NotNull TargetBackend targetBackend, boolean skipIgnored, @NotNull List<String> tags) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)filenamePattern, (String)"filenamePattern");
        Intrinsics.checkNotNullParameter((Object)((Object)targetBackend), (String)"targetBackend");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.rootDir = rootDir;
        this.file = file;
        this.filenamePattern = filenamePattern;
        this.targetBackend = targetBackend;
        this.skipIgnored = skipIgnored;
        this.tags = tags;
        if (checkFilenameStartsLowerCase != null) {
            char c = this.file.getName().charAt(0);
            if (checkFilenameStartsLowerCase.booleanValue()) {
                boolean bl = Character.isLowerCase(c);
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-SimpleTestMethodModel$32 = false;
                    String $i$a$-assert-SimpleTestMethodModel$32 = "Invalid file name '" + this.file + "', file name should start with lower-case letter";
                    throw new AssertionError((Object)$i$a$-assert-SimpleTestMethodModel$32);
                }
            } else {
                boolean bl = Character.isUpperCase(c);
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string = "Invalid file name '" + this.file + "', file name should start with upper-case letter";
                    throw new AssertionError((Object)string);
                }
            }
        }
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final TargetBackend getTargetBackend$test_generator() {
        return this.targetBackend;
    }

    @Override
    @NotNull
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    @NotNull
    public MethodModel.Kind getKind() {
        return Kind.INSTANCE;
    }

    @Override
    @NotNull
    public String getDataString() {
        String string = FileUtil.getRelativePath((File)this.rootDir, (File)this.file);
        Intrinsics.checkNotNull((Object)string);
        String path = string;
        String string2 = KtTestUtil.getFilePath(new File(path));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFilePath(File(path))");
        return string2;
    }

    @Override
    public boolean shouldBeGenerated() {
        return InTextDirectivesUtils.isCompatibleTarget(this.targetBackend, this.file);
    }

    @Override
    @NotNull
    public String getName() {
        String string;
        int n;
        char c;
        char p0;
        StringBuilder stringBuilder;
        char c2;
        String string2;
        String string3;
        String $i$a$-assert-SimpleTestMethodModel$name$422;
        boolean $i$a$-assert-SimpleTestMethodModel$name$322;
        Matcher matcher = this.filenamePattern.matcher(this.file.getName());
        boolean found = matcher.find();
        if (_Assertions.ENABLED && !found) {
            boolean $i$a$-assert-SimpleTestMethodModel$name$322 = false;
            String $i$a$-assert-SimpleTestMethodModel$name$322 = this.file.getName() + " isn't matched by regex " + this.filenamePattern.pattern();
            throw new AssertionError((Object)$i$a$-assert-SimpleTestMethodModel$name$322);
        }
        boolean bl = $i$a$-assert-SimpleTestMethodModel$name$322 = matcher.groupCount() >= 1;
        if (_Assertions.ENABLED && !$i$a$-assert-SimpleTestMethodModel$name$322) {
            boolean $i$a$-assert-SimpleTestMethodModel$name$422 = false;
            String string4 = this.filenamePattern.pattern();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"filenamePattern.pattern()");
            String $i$a$-assert-SimpleTestMethodModel$name$422 = string4;
            throw new AssertionError((Object)$i$a$-assert-SimpleTestMethodModel$name$422);
        }
        try {
            String string5 = matcher.group(1);
            if (string5 == null) {
                throw new IllegalStateException(("extractedName should not be null: " + this.filenamePattern.pattern()).toString());
            }
            $i$a$-assert-SimpleTestMethodModel$name$422 = string5;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Error generating test " + this.file.getName(), e);
        }
        String extractedName = $i$a$-assert-SimpleTestMethodModel$name$422;
        if (Intrinsics.areEqual((Object)this.rootDir, (Object)this.file.getParentFile())) {
            string3 = extractedName;
        } else {
            String string6;
            String relativePath = FileUtil.getRelativePath((File)this.rootDir, (File)this.file.getParentFile());
            StringBuilder stringBuilder2 = new StringBuilder().append(relativePath).append('-');
            string2 = extractedName;
            if (((CharSequence)string2).length() > 0) {
                c2 = string2.charAt(0);
                stringBuilder = stringBuilder2;
                boolean $i$a$-replaceFirstCharWithChar-SimpleTestMethodModel$name$unescapedName$22 = false;
                c = Character.toUpperCase(p0);
                stringBuilder2 = stringBuilder;
                p0 = c;
                String $i$a$-replaceFirstCharWithChar-SimpleTestMethodModel$name$unescapedName$22 = string2;
                n = 1;
                String string7 = $i$a$-replaceFirstCharWithChar-SimpleTestMethodModel$name$unescapedName$22.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
                $i$a$-replaceFirstCharWithChar-SimpleTestMethodModel$name$unescapedName$22 = string7;
                string6 = p0 + $i$a$-replaceFirstCharWithChar-SimpleTestMethodModel$name$unescapedName$22;
            } else {
                string6 = string2;
            }
            string3 = stringBuilder2.append(string6).toString();
        }
        String unescapedName = string3;
        boolean ignored = this.skipIgnored && InTextDirectivesUtils.isIgnoredTarget(this.targetBackend, this.file);
        StringBuilder stringBuilder3 = new StringBuilder().append(ignored ? "ignore" : "test");
        string2 = TestGeneratorUtil.escapeForJavaIdentifier(unescapedName);
        if (((CharSequence)string2).length() > 0) {
            p0 = string2.charAt(0);
            stringBuilder = stringBuilder3;
            boolean bl2 = false;
            c = Character.toUpperCase(p0);
            stringBuilder3 = stringBuilder;
            c2 = c;
            String string8 = string2;
            n = 1;
            String string9 = string8.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).substring(startIndex)");
            string8 = string9;
            string = c2 + string8;
        } else {
            string = string2;
        }
        return stringBuilder3.append(string).toString();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/generators/model/SimpleTestMethodModel$Kind;", "Lorg/jetbrains/kotlin/generators/model/MethodModel$Kind;", "()V", "test-generator"})
    public static final class Kind
    extends MethodModel.Kind {
        @NotNull
        public static final Kind INSTANCE = new Kind();

        private Kind() {
        }
    }
}

