/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrVerifier;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.test.backend.handlers.AbstractIrHandler;
import org.jetbrains.kotlin.test.backend.handlers.IrTextDumpHandler;
import org.jetbrains.kotlin.test.backend.handlers.IrTreeVerifierHandler;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrTreeVerifierHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/AbstractIrHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "tests-common-new"})
public final class IrTreeVerifierHandler
extends AbstractIrHandler {
    public IrTreeVerifierHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, false, 6, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processModule(@NotNull TestModule module, @NotNull IrBackendInput info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_IR())) {
            return;
        }
        List irFiles = info.getIrModuleFragment().getFiles();
        List<Pair<TestFile, IrFile>> testFileToIrFile = IrTextDumpHandler.Companion.groupWithTestFiles(irFiles, module);
        for (Pair<TestFile, IrFile> pair : testFileToIrFile) {
            void p1;
            DeepCopyTypeRemapper typeRemapper$iv$iv;
            void $this$deepCopyWithSymbols$iv$iv;
            TestFile testFile = (TestFile)pair.component1();
            IrFile irFile = (IrFile)pair.component2();
            Object object = testFile;
            if (object != null && (object = ((TestFile)object).getDirectives()) != null ? ((RegisteredDirectives)object).contains(CodegenTestDirectives.INSTANCE.getEXTERNAL_FILE()) : false) continue;
            new IrVerifier(this.getAssertions(), Intrinsics.areEqual(module.getFrontendKind(), (Object)FrontendKinds.FIR.INSTANCE)).verifyWithAssert(irFile);
            String actualDump = DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)irFile, (int)0, (boolean)true);
            IrElement $this$deepCopyWithSymbols_u24default$iv = (IrElement)irFile;
            IrDeclarationParent initialParent$iv = null;
            boolean $i$f$deepCopyWithSymbols = false;
            IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
            DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
            boolean $i$f$deepCopyWithSymbols2 = false;
            IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, (IrElementVisitorVoid)((IrElementVisitorVoid)symbolRemapper$iv$iv));
            DeepCopyTypeRemapper deepCopyTypeRemapper = typeRemapper$iv$iv = new DeepCopyTypeRemapper((SymbolRemapper)symbolRemapper$iv$iv);
            DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
            void var21_21 = $this$deepCopyWithSymbols$iv$iv;
            boolean bl = false;
            deepCopyTypeRemapper = (TypeRemapper)deepCopyTypeRemapper;
            SymbolRemapper p0 = (SymbolRemapper)deepCopySymbolRemapper;
            IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents((IrElement)var21_21.transform((IrElementTransformer)new DeepCopyIrTreeWithSymbols(p0, (TypeRemapper)p1), null), initialParent$iv);
            if (irElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
            }
            IrFile irFileCopy = (IrFile)((IrElement)((IrFile)irElement2));
            String dumpOfCopy = DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)irFileCopy, (int)0, (boolean)true);
            this.getAssertions().assertEquals(actualDump, dumpOfCopy, (Function0<String>)((Function0)processModule.1.INSTANCE));
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }
}

