/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.test.TestInfrastructureInternals;
import org.jetbrains.kotlin.test.directives.JsEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AbstractEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProvider;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.util.AbstractArrayMapOwner;
import org.jetbrains.kotlin.util.ArrayMapAccessor;
import org.jetbrains.kotlin.util.TypeRegistry;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0007\u001a2\u0010\u0011\u001a\u00020\u0012\"\b\b\u0000\u0010\u0013*\u00020\u0014*\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00162\u0006\u0010\u0017\u001a\u0002H\u0013H\u0082\u0002\u00a2\u0006\u0002\u0010\u0018\"\u001f\u0010\u0000\u001a\u00020\u0001*\u00020\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0019"}, d2={"compilerConfigurationProvider", "Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;", "Lorg/jetbrains/kotlin/test/services/TestServices;", "getCompilerConfigurationProvider", "(Lorg/jetbrains/kotlin/test/services/TestServices;)Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;", "compilerConfigurationProvider$delegate", "Lorg/jetbrains/kotlin/util/ArrayMapAccessor;", "createCompilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "configurators", "", "Lorg/jetbrains/kotlin/test/services/AbstractEnvironmentConfigurator;", "platformToEnvironmentConfigFiles", "Lorg/jetbrains/kotlin/cli/jvm/compiler/EnvironmentConfigFiles;", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "set", "", "T", "", "key", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "value", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;Ljava/lang/Object;)V", "tests-common-new"})
public final class CompilerConfigurationProviderKt {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final ArrayMapAccessor compilerConfigurationProvider$delegate;

    @NotNull
    public static final CompilerConfigurationProvider getCompilerConfigurationProvider(@NotNull TestServices $this$compilerConfigurationProvider) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$compilerConfigurationProvider), (String)"<this>");
        return (CompilerConfigurationProvider)compilerConfigurationProvider$delegate.getValue((AbstractArrayMapOwner)$this$compilerConfigurationProvider, $$delegatedProperties[0]);
    }

    @TestInfrastructureInternals
    @NotNull
    public static final EnvironmentConfigFiles platformToEnvironmentConfigFiles(@NotNull TargetPlatform $this$platformToEnvironmentConfigFiles) {
        EnvironmentConfigFiles environmentConfigFiles;
        Intrinsics.checkNotNullParameter((Object)$this$platformToEnvironmentConfigFiles, (String)"<this>");
        if (JvmPlatformKt.isJvm((TargetPlatform)$this$platformToEnvironmentConfigFiles)) {
            environmentConfigFiles = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        } else if (JsPlatformKt.isJs((TargetPlatform)$this$platformToEnvironmentConfigFiles)) {
            environmentConfigFiles = EnvironmentConfigFiles.JS_CONFIG_FILES;
        } else if (NativePlatformKt.isNative((TargetPlatform)$this$platformToEnvironmentConfigFiles)) {
            environmentConfigFiles = EnvironmentConfigFiles.NATIVE_CONFIG_FILES;
        } else if (TargetPlatformKt.isCommon((TargetPlatform)$this$platformToEnvironmentConfigFiles)) {
            environmentConfigFiles = EnvironmentConfigFiles.METADATA_CONFIG_FILES;
        } else {
            throw new IllegalStateException(("Unknown platform: " + $this$platformToEnvironmentConfigFiles).toString());
        }
        return environmentConfigFiles;
    }

    @TestInfrastructureInternals
    @NotNull
    public static final CompilerConfiguration createCompilerConfiguration(@NotNull TestModule module, @NotNull List<? extends AbstractEnvironmentConfigurator> configurators) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(configurators, (String)"configurators");
        CompilerConfiguration configuration2 = new CompilerConfiguration();
        CompilerConfigurationProviderKt.set(configuration2, CommonConfigurationKeys.MODULE_NAME, module.getName());
        if (module.getDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getGENERATE_STRICT_IMPLICIT_EXPORT())) {
            configuration2.put(JSConfigurationKeys.GENERATE_STRICT_IMPLICIT_EXPORT, (Object)true);
        }
        if (Intrinsics.areEqual(module.getFrontendKind(), (Object)FrontendKinds.FIR.INSTANCE)) {
            CompilerConfigurationProviderKt.set(configuration2, CommonConfigurationKeys.USE_FIR, true);
        }
        CompilerConfigurationKey compilerConfigurationKey = CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey, (String)"MESSAGE_COLLECTOR_KEY");
        CompilerConfigurationProviderKt.set(configuration2, compilerConfigurationKey, new MessageCollector(){

            public void clear() {
            }

            public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
                Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (severity == CompilerMessageSeverity.ERROR) {
                    String prefix = location == null ? "" : '(' + location.getPath() + ':' + location.getLine() + ':' + location.getColumn() + ") ";
                    throw new AssertionError((Object)(prefix + message));
                }
            }

            public boolean hasErrors() {
                return false;
            }
        });
        CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)configuration2, (LanguageVersionSettings)module.getLanguageVersionSettings());
        Iterable $this$forEach$iv = configurators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractEnvironmentConfigurator it = (AbstractEnvironmentConfigurator)element$iv;
            boolean bl = false;
            it.configureCompileConfigurationWithAdditionalConfigurationKeys(configuration2, module);
        }
        return configuration2;
    }

    private static final <T> void set(CompilerConfiguration $this$set, CompilerConfigurationKey<T> key, T value) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        $this$set.put(key, value);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Reflection.getOrCreateKotlinPackage(CompilerConfigurationProviderKt.class, (String)"tests-common-new"), "compilerConfigurationProvider", "getCompilerConfigurationProvider(Lorg/jetbrains/kotlin/test/services/TestServices;)Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;")))};
        $$delegatedProperties = kPropertyArray;
        TestServices.Companion this_$iv = TestServices.Companion;
        boolean $i$f$testServiceAccessor = false;
        compilerConfigurationProvider$delegate = TypeRegistry.generateAccessor$default((TypeRegistry)((TypeRegistry)this_$iv), (KClass)Reflection.getOrCreateKotlinClass(CompilerConfigurationProvider.class), null, (int)2, null);
    }
}

